/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.schema.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis2.schema.BeanWriterMetaInfoHolder;
import org.apache.axis2.schema.CompilerOptions;
import org.apache.axis2.schema.SchemaCompilationException;
import org.apache.axis2.schema.SchemaCompiler;
import org.apache.axis2.schema.i18n.SchemaCompilerMessages;
import org.apache.axis2.schema.typemap.JavaTypeMap;
import org.apache.axis2.schema.util.PrimitiveTypeFinder;
import org.apache.axis2.schema.util.SchemaPropertyLoader;
import org.apache.axis2.schema.writer.BeanWriter;
import org.apache.axis2.util.FileWriter;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.XSLTTemplateProcessor;
import org.apache.axis2.util.XSLTUtils;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CStructWriter
implements BeanWriter {
    public static final String WRAPPED_DATABINDING_CLASS_NAME = "WrappedDatabinder";
    public static final String AXIS2_PREFIX = "axis2_";
    private String javaBeanTemplateName = null;
    private boolean templateLoaded = false;
    private Templates sourceTemplateCache;
    private Templates headerTemplateCache;
    private List namesList;
    private static int count = 0;
    private boolean wrapClasses = false;
    private boolean writeClasses = false;
    protected File rootDir;
    private Document globalWrappedSourceDocument;
    private Document globalWrappedHeaderDocument;
    private Map modelMap = new HashMap();
    private static final String DEFAULT_PACKAGE = "adb";
    private static final String DEFAULT_C_CLASS_NAME = "axiom_node_t*";
    private Map baseTypeMap = new JavaTypeMap().getTypeMap();
    private int lastPrefixIndex = 1;
    HashMap mapURItoPrefix = new HashMap();
    HashMap mapPrefixtoURI = new HashMap();

    public Map getModelMap() {
        return this.modelMap;
    }

    public void init(CompilerOptions options) throws SchemaCompilationException {
        try {
            this.initWithFile(options.getOutputLocation());
            this.writeClasses = options.isWriteOutput();
            this.wrapClasses = !this.writeClasses ? false : options.isWrapClasses();
            if (options.isWrapClasses()) {
                this.globalWrappedSourceDocument = XSLTUtils.getDocument();
                Element rootElement = XSLTUtils.getElement((Document)this.globalWrappedSourceDocument, (String)"beans");
                this.globalWrappedSourceDocument.appendChild(rootElement);
                XSLTUtils.addAttribute((Document)this.globalWrappedSourceDocument, (String)"name", (String)WRAPPED_DATABINDING_CLASS_NAME, (Element)rootElement);
                this.globalWrappedHeaderDocument = XSLTUtils.getDocument();
                rootElement = XSLTUtils.getElement((Document)this.globalWrappedHeaderDocument, (String)"beans");
                this.globalWrappedHeaderDocument.appendChild(rootElement);
                XSLTUtils.addAttribute((Document)this.globalWrappedHeaderDocument, (String)"name", (String)WRAPPED_DATABINDING_CLASS_NAME, (Element)rootElement);
            }
        }
        catch (IOException e) {
            throw new SchemaCompilationException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SchemaCompilationException(e);
        }
    }

    public String write(XmlSchemaElement element, Map typeMap, BeanWriterMetaInfoHolder metainf) throws SchemaCompilationException {
        try {
            QName qName = element.getQName();
            return this.process(qName, metainf, typeMap, true);
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    public String write(XmlSchemaComplexType complexType, Map typeMap, BeanWriterMetaInfoHolder metainf) throws SchemaCompilationException {
        try {
            QName qName = complexType.getQName();
            return this.process(qName, metainf, typeMap, false);
        }
        catch (SchemaCompilationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    public void writeBatch() throws SchemaCompilationException {
        try {
            if (this.wrapClasses) {
                File outSource = this.createOutFile(WRAPPED_DATABINDING_CLASS_NAME, ".c");
                File outHeader = this.createOutFile(WRAPPED_DATABINDING_CLASS_NAME, ".h");
                this.parseSource(this.globalWrappedSourceDocument, outSource);
                this.parseHeader(this.globalWrappedHeaderDocument, outHeader);
            }
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    public String write(XmlSchemaSimpleType simpleType, Map typeMap, BeanWriterMetaInfoHolder metainf) throws SchemaCompilationException {
        try {
            QName qName = simpleType.getQName();
            return this.process(qName, metainf, typeMap, false);
        }
        catch (SchemaCompilationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    private void initWithFile(File rootDir) throws IOException {
        if (rootDir == null) {
            this.rootDir = new File(".");
        } else {
            if (!rootDir.isDirectory()) {
                throw new IOException(SchemaCompilerMessages.getMessage("schema.rootnotfolderexception"));
            }
            this.rootDir = rootDir;
        }
        this.namesList = new ArrayList();
        this.javaBeanTemplateName = SchemaPropertyLoader.getBeanTemplate();
    }

    public String makeFullyQualifiedClassName(QName qName) {
        String originalName = qName.getLocalPart();
        return this.makeUniqueCStructName(this.namesList, originalName);
    }

    private String process(QName qName, BeanWriterMetaInfoHolder metainf, Map typeMap, boolean isElement) throws Exception {
        String fullyQualifiedClassName = metainf.getOwnClassName();
        if (fullyQualifiedClassName == null) {
            fullyQualifiedClassName = this.makeFullyQualifiedClassName(qName);
        }
        String className = fullyQualifiedClassName;
        String originalName = qName.getLocalPart();
        ArrayList propertyNames = new ArrayList();
        if (!this.templateLoaded) {
            this.loadTemplate();
        }
        if (this.wrapClasses) {
            this.globalWrappedSourceDocument.getDocumentElement().appendChild(this.getBeanElement(this.globalWrappedSourceDocument, className, originalName, qName, isElement, metainf, propertyNames, typeMap));
            this.globalWrappedHeaderDocument.getDocumentElement().appendChild(this.getBeanElement(this.globalWrappedHeaderDocument, className, originalName, qName, isElement, metainf, propertyNames, typeMap));
        } else {
            Document modelSource = XSLTUtils.getDocument();
            Document modelHeader = XSLTUtils.getDocument();
            modelSource.appendChild(this.getBeanElement(modelSource, className, originalName, qName, isElement, metainf, propertyNames, typeMap));
            modelHeader.appendChild(this.getBeanElement(modelHeader, className, originalName, qName, isElement, metainf, propertyNames, typeMap));
            if (this.writeClasses) {
                File outSource = this.createOutFile(className, ".c");
                File outHeader = this.createOutFile(className, ".h");
                this.parseSource(modelSource, outSource);
                this.parseHeader(modelHeader, outHeader);
            }
            this.modelMap.put(new QName(qName.getNamespaceURI(), className), modelSource);
            this.modelMap.put(new QName(qName.getNamespaceURI(), className), modelHeader);
        }
        return fullyQualifiedClassName;
    }

    private Element getBeanElement(Document model, String className, String originalName, QName qName, boolean isElement, BeanWriterMetaInfoHolder metainf, ArrayList propertyNames, Map typeMap) throws SchemaCompilationException {
        Element rootElt = XSLTUtils.getElement((Document)model, (String)"class");
        XSLTUtils.addAttribute((Document)model, (String)"name", (String)className, (Element)rootElt);
        XSLTUtils.addAttribute((Document)model, (String)"caps-name", (String)className.toUpperCase(), (Element)rootElt);
        XSLTUtils.addAttribute((Document)model, (String)"originalName", (String)originalName, (Element)rootElt);
        XSLTUtils.addAttribute((Document)model, (String)"nsuri", (String)qName.getNamespaceURI(), (Element)rootElt);
        XSLTUtils.addAttribute((Document)model, (String)"nsprefix", (String)this.getPrefixForURI(qName.getNamespaceURI(), qName.getPrefix()), (Element)rootElt);
        String capsName = className.toUpperCase();
        XSLTUtils.addAttribute((Document)model, (String)"caps-name", (String)capsName, (Element)rootElt);
        if (!this.wrapClasses) {
            XSLTUtils.addAttribute((Document)model, (String)"unwrapped", (String)"yes", (Element)rootElt);
        }
        if (!this.writeClasses) {
            XSLTUtils.addAttribute((Document)model, (String)"skip-write", (String)"yes", (Element)rootElt);
        }
        if (!isElement) {
            XSLTUtils.addAttribute((Document)model, (String)"type", (String)"yes", (Element)rootElt);
        }
        if (metainf.isAnonymous()) {
            XSLTUtils.addAttribute((Document)model, (String)"anon", (String)"yes", (Element)rootElt);
        }
        if (metainf.isExtension()) {
            XSLTUtils.addAttribute((Document)model, (String)"extension", (String)metainf.getExtensionClassName(), (Element)rootElt);
        }
        if (metainf.isChoice()) {
            XSLTUtils.addAttribute((Document)model, (String)"choice", (String)"yes", (Element)rootElt);
        }
        if (metainf.isOrdered()) {
            XSLTUtils.addAttribute((Document)model, (String)"ordered", (String)"yes", (Element)rootElt);
        }
        if (isElement && metainf.isNillable(qName)) {
            XSLTUtils.addAttribute((Document)model, (String)"nillable", (String)"yes", (Element)rootElt);
        }
        this.populateInfo(metainf, model, rootElt, propertyNames, typeMap, false);
        return rootElt;
    }

    private void populateInfo(BeanWriterMetaInfoHolder metainf, Document model, Element rootElt, ArrayList propertyNames, Map typeMap, boolean isInherited) throws SchemaCompilationException {
        if (metainf.getParent() != null) {
            this.populateInfo(metainf.getParent(), model, rootElt, propertyNames, typeMap, true);
        }
        this.addPropertyEntries(metainf, model, rootElt, propertyNames, typeMap, isInherited);
    }

    private void addPropertyEntries(BeanWriterMetaInfoHolder metainf, Document model, Element rootElt, ArrayList propertyNames, Map typeMap, boolean isInherited) throws SchemaCompilationException {
        QName[] qNames = metainf.isOrdered() ? metainf.getOrderedQNameArray() : metainf.getQNameArray();
        for (int i = 0; i < qNames.length; ++i) {
            Element property = XSLTUtils.addChildElement((Document)model, (String)"property", (Node)rootElt);
            QName name = qNames[i];
            String xmlName = name.getLocalPart();
            XSLTUtils.addAttribute((Document)model, (String)"name", (String)xmlName, (Element)property);
            XSLTUtils.addAttribute((Document)model, (String)"nsuri", (String)name.getNamespaceURI(), (Element)property);
            XSLTUtils.addAttribute((Document)model, (String)"prefix", (String)name.getPrefix(), (Element)property);
            XSLTUtils.addAttribute((Document)model, (String)"cname", (String)xmlName, (Element)property);
            String CClassNameForElement = metainf.getClassNameForQName(name);
            if (CClassNameForElement == null) {
                CClassNameForElement = DEFAULT_C_CLASS_NAME;
            }
            CClassNameForElement = this.getShortTypeName(CClassNameForElement);
            XSLTUtils.addAttribute((Document)model, (String)"type", (String)CClassNameForElement, (Element)property);
            XSLTUtils.addAttribute((Document)model, (String)"caps-cname", (String)xmlName.toUpperCase(), (Element)property);
            XSLTUtils.addAttribute((Document)model, (String)"caps-type", (String)CClassNameForElement.toUpperCase(), (Element)property);
            if (PrimitiveTypeFinder.isPrimitive(CClassNameForElement)) {
                XSLTUtils.addAttribute((Document)model, (String)"primitive", (String)"yes", (Element)property);
            }
            if (this.isDefault(CClassNameForElement)) {
                XSLTUtils.addAttribute((Document)model, (String)"default", (String)"yes", (Element)property);
            }
            if (typeMap.containsKey(metainf.getSchemaQNameForQName(name))) {
                XSLTUtils.addAttribute((Document)model, (String)"ours", (String)"yes", (Element)property);
            }
            if (metainf.getAttributeStatusForQName(name)) {
                XSLTUtils.addAttribute((Document)model, (String)"attribute", (String)"yes", (Element)property);
            }
            if (metainf.isNillable(name)) {
                XSLTUtils.addAttribute((Document)model, (String)"nillable", (String)"yes", (Element)property);
            }
            String shortTypeName = metainf.getSchemaQNameForQName(name) != null ? (this.baseTypeMap.containsKey(metainf.getSchemaQNameForQName(name)) ? metainf.getSchemaQNameForQName(name).getLocalPart() : this.getShortTypeName(CClassNameForElement)) : this.getShortTypeName(CClassNameForElement);
            XSLTUtils.addAttribute((Document)model, (String)"shorttypename", (String)shortTypeName, (Element)property);
            if (isInherited) {
                XSLTUtils.addAttribute((Document)model, (String)"inherited", (String)"yes", (Element)property);
            }
            if (metainf.getAnyStatusForQName(name)) {
                XSLTUtils.addAttribute((Document)model, (String)"any", (String)"yes", (Element)property);
            }
            if (metainf.getBinaryStatusForQName(name)) {
                XSLTUtils.addAttribute((Document)model, (String)"binary", (String)"yes", (Element)property);
            }
            if (metainf.getSimpleStatusForQName(name)) {
                XSLTUtils.addAttribute((Document)model, (String)"simple", (String)"yes", (Element)property);
            }
            long minOccurs = metainf.getMinOccurs(name);
            XSLTUtils.addAttribute((Document)model, (String)"minOccurs", (String)(minOccurs + ""), (Element)property);
            if (!metainf.getArrayStatusForQName(name)) continue;
            String attrName = name.getLocalPart();
            int arrayTokenStart = attrName.indexOf("Array");
            if (arrayTokenStart >= 0) {
                String arrayEle = attrName.substring(0, arrayTokenStart);
                XSLTUtils.addAttribute((Document)model, (String)"arrayele", (String)arrayEle, (Element)property);
            }
            XSLTUtils.addAttribute((Document)model, (String)"isarray", (String)"yes", (Element)property);
            XSLTUtils.addAttribute((Document)model, (String)"arrayBaseType", (String)CClassNameForElement, (Element)property);
            long maxOccurs = metainf.getMaxOccurs(name);
            if (maxOccurs == Long.MAX_VALUE) {
                XSLTUtils.addAttribute((Document)model, (String)"unbound", (String)"yes", (Element)property);
            }
            XSLTUtils.addAttribute((Document)model, (String)"maxOccurs", (String)(maxOccurs + ""), (Element)property);
        }
    }

    private boolean isDefault(String javaClassNameForElement) {
        return SchemaCompiler.DEFAULT_CLASS_NAME.equals(javaClassNameForElement) || "org.apache.axiom.om.OMElement[]".equals(javaClassNameForElement);
    }

    private String makeUniqueCStructName(List listOfNames, String xmlName) {
        String javaName = JavaUtils.isJavaKeyword((String)xmlName) ? JavaUtils.makeNonJavaKeyword((String)xmlName) : xmlName;
        while (listOfNames.contains(javaName.toLowerCase())) {
            javaName = javaName + count++;
        }
        listOfNames.add(javaName.toLowerCase());
        return javaName;
    }

    private void loadTemplate() throws SchemaCompilationException {
        Class<?> clazz = this.getClass();
        String templateName = this.javaBeanTemplateName;
        if (templateName != null) {
            try {
                String sourceTemplateName = templateName + "Source.xsl";
                InputStream xslStream = clazz.getResourceAsStream(sourceTemplateName);
                this.sourceTemplateCache = TransformerFactory.newInstance().newTemplates(new StreamSource(xslStream));
                String headerTemplateName = templateName + "Header.xsl";
                xslStream = clazz.getResourceAsStream(headerTemplateName);
                this.headerTemplateCache = TransformerFactory.newInstance().newTemplates(new StreamSource(xslStream));
                this.templateLoaded = true;
            }
            catch (TransformerConfigurationException e) {
                throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.templateLoadException"), e);
            }
        } else {
            throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.templateNotFoundException"));
        }
    }

    protected File createOutFile(String fileName, String extension) throws Exception {
        return FileWriter.createClassFile((File)this.rootDir, (String)"", (String)(AXIS2_PREFIX + fileName), (String)extension);
    }

    private void parseSource(Document doc, File outputFile) throws Exception {
        FileOutputStream outStream = new FileOutputStream(outputFile);
        XSLTTemplateProcessor.parse((OutputStream)outStream, (Document)doc, (Transformer)this.sourceTemplateCache.newTransformer());
        ((OutputStream)outStream).write(10);
        ((OutputStream)outStream).write(10);
        outStream.flush();
        ((OutputStream)outStream).close();
    }

    private void parseHeader(Document doc, File outputFile) throws Exception {
        FileOutputStream outStream = new FileOutputStream(outputFile);
        XSLTTemplateProcessor.parse((OutputStream)outStream, (Document)doc, (Transformer)this.headerTemplateCache.newTransformer());
        ((OutputStream)outStream).write(10);
        ((OutputStream)outStream).write(10);
        outStream.flush();
        ((OutputStream)outStream).close();
    }

    public String getPrefixForURI(String uri) {
        return this.getPrefixForURI(uri, null);
    }

    public String getPrefixForURI(String uri, String defaultPrefix) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        String prefix = (String)this.mapURItoPrefix.get(uri);
        if (prefix == null) {
            if (defaultPrefix == null || defaultPrefix.length() == 0) {
                prefix = "ns" + this.lastPrefixIndex++;
                while (this.mapPrefixtoURI.get(prefix) != null) {
                    prefix = "ns" + this.lastPrefixIndex++;
                }
            } else {
                prefix = defaultPrefix;
            }
            this.mapPrefixtoURI.put(prefix, uri);
            this.mapURItoPrefix.put(uri, prefix);
        }
        return prefix;
    }

    private String getShortTypeName(String typeClassName) {
        if (typeClassName.endsWith("[]")) {
            typeClassName = typeClassName.substring(0, typeClassName.lastIndexOf("["));
        }
        return typeClassName;
    }

    public void registerExtensionMapperPackageName(String mapperPackageName) {
    }

    public void writeExtensionMapper(BeanWriterMetaInfoHolder[] metainfArray) throws SchemaCompilationException {
    }

    public String getExtensionMapperPackageName() {
        return null;
    }
}

