/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.schema.BeanWriterMetaInfoHolder;
import org.apache.axis2.schema.CompilerOptions;
import org.apache.axis2.schema.SchemaCompilationException;
import org.apache.axis2.schema.SchemaConstants;
import org.apache.axis2.schema.i18n.SchemaCompilerMessages;
import org.apache.axis2.schema.util.SchemaPropertyLoader;
import org.apache.axis2.schema.writer.BeanWriter;
import org.apache.axis2.util.SchemaUtil;
import org.apache.axis2.util.URLProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAnyAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaEnumerationFacet;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxExclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxInclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaMinExclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMinInclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMinLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaObjectTable;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaPatternFacet;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeUnion;
import org.apache.ws.commons.schema.XmlSchemaType;

public class SchemaCompiler {
    private static final Log log = LogFactory.getLog((Class)SchemaCompiler.class);
    private CompilerOptions options;
    private HashMap processedTypemap;
    private HashMap processedElementMap;
    private HashMap processedAnonymousComplexTypesMap;
    private HashMap processedElementRefMap;
    private HashMap simpleTypesMap;
    private HashMap changedTypeMap;
    private HashMap processedTypeMetaInfoMap;
    private ArrayList processedElementList;
    private List nillableElementList;
    private BeanWriter writer = null;
    private Map baseSchemaTypeMap = null;
    private Map loadedSchemaMap = new HashMap();
    private Map availableSchemaMap = new HashMap();
    private Map loadedSourceURI = new HashMap();
    public static final String ANY_ELEMENT_FIELD_NAME = "extraElement";
    public static final String EXTRA_ATTRIBUTE_FIELD_NAME = "extraAttributes";
    public static final String DEFAULT_CLASS_NAME = OMElement.class.getName();
    public static final String DEFAULT_CLASS_ARRAY_NAME = "org.apache.axiom.om.OMElement[]";
    public static final String DEFAULT_ATTRIB_CLASS_NAME = OMAttribute.class.getName();
    public static final String DEFAULT_ATTRIB_ARRAY_CLASS_NAME = "org.apache.axiom.om.OMAttribute[]";
    private static int typeCounter = 0;

    public HashMap getProcessedElementMap() {
        return this.processedElementMap;
    }

    public Map getProcessedModelMap() {
        return this.writer.getModelMap();
    }

    public SchemaCompiler(CompilerOptions options) throws SchemaCompilationException {
        this.options = options == null ? new CompilerOptions() : options;
        this.processedTypemap = new HashMap();
        this.processedElementMap = new HashMap();
        this.simpleTypesMap = new HashMap();
        this.processedElementList = new ArrayList();
        this.processedAnonymousComplexTypesMap = new HashMap();
        this.changedTypeMap = new HashMap();
        this.processedTypeMetaInfoMap = new HashMap();
        this.processedElementRefMap = new HashMap();
        this.nillableElementList = new ArrayList();
        this.writer = SchemaPropertyLoader.getBeanWriterInstance();
        this.writer.init(this.options);
        this.baseSchemaTypeMap = SchemaPropertyLoader.getTypeMapperInstance().getTypeMap();
    }

    public void compile(List schemalist) throws SchemaCompilationException {
        try {
            int i;
            if (schemalist.isEmpty()) {
                return;
            }
            this.loadedSchemaMap.clear();
            this.availableSchemaMap.clear();
            for (i = 0; i < schemalist.size(); ++i) {
                XmlSchema schema = (XmlSchema)schemalist.get(i);
                this.availableSchemaMap.put(schema.getTargetNamespace(), schema);
            }
            if (this.writer.getExtensionMapperPackageName() == null) {
                String nsp = null;
                for (int i2 = 0; nsp == null && i2 < schemalist.size() && (nsp = ((XmlSchema)schemalist.get(i2)).getTargetNamespace()) == null; ++i2) {
                    XmlSchema[] schemas = SchemaUtil.getAllSchemas((XmlSchema)((XmlSchema)schemalist.get(i2)));
                    for (int j = 0; schemas != null && j < schemas.length && (nsp = schemas[j].getTargetNamespace()) == null; ++j) {
                    }
                }
                if (nsp == null) {
                    nsp = "org.apache.axis2";
                }
                this.writer.registerExtensionMapperPackageName(URLProcessor.makePackageName((String)nsp));
            }
            for (i = 0; i < schemalist.size(); ++i) {
                this.compile((XmlSchema)schemalist.get(i), true);
            }
            this.finalizeSchemaCompilation();
        }
        catch (SchemaCompilationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    public void compile(XmlSchema schema) throws SchemaCompilationException {
        this.compile(schema, false);
    }

    private void compile(XmlSchema schema, boolean isPartofGroup) throws SchemaCompilationException {
        XmlSchemaObjectCollection includes;
        if ("http://www.w3.org/2001/XMLSchema".equals(schema.getTargetNamespace())) {
            return;
        }
        if (!isPartofGroup && this.writer.getExtensionMapperPackageName() == null) {
            this.writer.registerExtensionMapperPackageName(URLProcessor.makePackageName((String)schema.getTargetNamespace()));
        }
        if (!this.loadedSchemaMap.containsKey(schema.getTargetNamespace())) {
            this.loadedSchemaMap.put(schema.getTargetNamespace(), schema);
        }
        if (schema.getSourceURI() != null) {
            String key = schema.getTargetNamespace() + ":" + schema.getSourceURI();
            if (this.loadedSourceURI.containsKey(key)) {
                return;
            }
            this.loadedSourceURI.put(key, key);
        }
        if ((includes = schema.getIncludes()) != null) {
            Iterator tempIterator = includes.getIterator();
            while (tempIterator.hasNext()) {
                XmlSchema schema1;
                Object o = tempIterator.next();
                if (o instanceof XmlSchemaImport && (schema1 = ((XmlSchemaImport)o).getSchema()) != null) {
                    this.compile(schema1, isPartofGroup);
                }
                if (!(o instanceof XmlSchemaInclude) || (schema1 = ((XmlSchemaInclude)o).getSchema()) == null) continue;
                this.compile(schema1, isPartofGroup);
            }
        }
        XmlSchemaObjectTable elements = schema.getElements();
        Iterator xmlSchemaElement1Iterator = elements.getValues();
        while (xmlSchemaElement1Iterator.hasNext()) {
            this.processElement((XmlSchemaElement)xmlSchemaElement1Iterator.next(), schema);
        }
        Iterator xmlSchemaElement2Iterator = elements.getValues();
        while (xmlSchemaElement2Iterator.hasNext()) {
            this.writeElement((XmlSchemaElement)xmlSchemaElement2Iterator.next());
        }
        if (this.options.isGenerateAll()) {
            Iterator xmlSchemaTypes2Iterator = schema.getSchemaTypes().getValues();
            while (xmlSchemaTypes2Iterator.hasNext()) {
                XmlSchemaType schemaType = (XmlSchemaType)xmlSchemaTypes2Iterator.next();
                if (this.isAlreadyProcessed(schemaType.getQName())) continue;
                if (schemaType instanceof XmlSchemaComplexType) {
                    XmlSchemaComplexType complexType = (XmlSchemaComplexType)schemaType;
                    if (complexType.getName() == null) continue;
                    this.processNamedComplexSchemaType(complexType, schema);
                    continue;
                }
                if (!(schemaType instanceof XmlSchemaSimpleType)) continue;
                this.processSimpleSchemaType((XmlSchemaSimpleType)schemaType, null, schema);
            }
        }
        if (!isPartofGroup) {
            this.finalizeSchemaCompilation();
        }
    }

    private void finalizeSchemaCompilation() throws SchemaCompilationException {
        this.writer.writeExtensionMapper(this.processedTypeMetaInfoMap.values().toArray(new BeanWriterMetaInfoHolder[this.processedTypeMetaInfoMap.size()]));
        if (this.options.isWrapClasses()) {
            this.writer.writeBatch();
        }
    }

    public Properties getCompilerProperties() {
        return SchemaPropertyLoader.getPropertyMap();
    }

    private void writeElement(XmlSchemaElement xsElt) throws SchemaCompilationException {
        QName qName;
        if (this.processedElementMap.containsKey(xsElt.getQName())) {
            return;
        }
        XmlSchemaType schemaType = xsElt.getSchemaType();
        BeanWriterMetaInfoHolder metainf = new BeanWriterMetaInfoHolder();
        if (schemaType != null && schemaType.getName() != null) {
            qName = schemaType.getQName();
            String className = this.findClassName(qName, this.isArray((XmlSchemaParticle)xsElt));
            if (this.changedTypeMap.containsKey(qName)) {
                metainf.registerMapping(xsElt.getQName(), (QName)this.changedTypeMap.get(qName), className);
            } else {
                metainf.registerMapping(xsElt.getQName(), qName, className);
            }
        } else if (xsElt.getRefName() == null) {
            if (xsElt.getSchemaTypeName() != null) {
                qName = xsElt.getSchemaTypeName();
                String className = this.findClassName(qName, this.isArray((XmlSchemaParticle)xsElt));
                metainf.registerMapping(xsElt.getQName(), qName, className);
            } else if (schemaType != null) {
                metainf = (BeanWriterMetaInfoHolder)this.processedAnonymousComplexTypesMap.get(xsElt);
                metainf.setAnonymous(true);
            } else {
                log.warn((Object)SchemaCompilerMessages.getMessage("schema.elementWithNoType", xsElt.getQName().toString()));
                metainf.registerMapping(xsElt.getQName(), null, DEFAULT_CLASS_NAME, 8);
            }
        }
        if (this.nillableElementList.contains(xsElt.getQName())) {
            metainf.registerNillableQName(xsElt.getQName());
        }
        String writtenClassName = this.writer.write(xsElt, (Map)this.processedTypemap, metainf);
        xsElt.addMetaInfo((Object)"CLASS_NAME", (Object)writtenClassName);
        this.processedElementMap.put(xsElt.getQName(), writtenClassName);
    }

    private void processElement(XmlSchemaElement xsElt, Map innerElementMap, List localNillableList, XmlSchema parentSchema) throws SchemaCompilationException {
        this.processElement(xsElt, false, innerElementMap, localNillableList, parentSchema);
    }

    private void processElement(XmlSchemaElement xsElt, XmlSchema parentSchema) throws SchemaCompilationException {
        this.processElement(xsElt, true, null, null, parentSchema);
    }

    private void processElement(XmlSchemaElement xsElt, boolean isOuter, Map innerElementMap, List localNillableList, XmlSchema parentSchema) throws SchemaCompilationException {
        if (xsElt == null) {
            throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.elementNull"));
        }
        if (isOuter && this.processedElementList.contains(xsElt.getQName())) {
            return;
        }
        XmlSchemaType schemaType = xsElt.getSchemaType();
        if (schemaType != null) {
            this.processSchema(xsElt, schemaType, parentSchema);
            if (!isOuter) {
                if (schemaType.getName() != null) {
                    String className = this.findClassName(schemaType.getQName(), this.isArray((XmlSchemaParticle)xsElt));
                    innerElementMap.put(xsElt.getQName(), className);
                    schemaType.addMetaInfo((Object)"CLASS_NAME", (Object)className);
                    if (this.baseSchemaTypeMap.containsValue(className)) {
                        schemaType.addMetaInfo((Object)"CLASS_NAME_PRIMITIVE", (Object)Boolean.TRUE);
                    }
                } else {
                    QName generatedTypeName = this.generateTypeQName(xsElt.getQName(), parentSchema);
                    if (schemaType instanceof XmlSchemaComplexType) {
                        schemaType.setName(generatedTypeName.getLocalPart());
                        String fullyQualifiedClassName = this.writer.makeFullyQualifiedClassName(schemaType.getQName());
                        this.processedTypemap.put(schemaType.getQName(), fullyQualifiedClassName);
                        BeanWriterMetaInfoHolder metaInfHolder = (BeanWriterMetaInfoHolder)this.processedAnonymousComplexTypesMap.get(xsElt);
                        metaInfHolder.setOwnQname(schemaType.getQName());
                        metaInfHolder.setOwnClassName(fullyQualifiedClassName);
                        this.writeComplexType((XmlSchemaComplexType)schemaType, metaInfHolder);
                        this.processedAnonymousComplexTypesMap.remove(xsElt);
                        String className = this.findClassName(schemaType.getQName(), this.isArray((XmlSchemaParticle)xsElt));
                        innerElementMap.put(xsElt.getQName(), className);
                        xsElt.addMetaInfo((Object)"CLASS_NAME", (Object)className);
                    } else if (schemaType instanceof XmlSchemaSimpleType) {
                        schemaType.setName(generatedTypeName.getLocalPart());
                        String fullyQualifiedClassName = this.writer.makeFullyQualifiedClassName(schemaType.getQName());
                        this.processedTypemap.put(schemaType.getQName(), fullyQualifiedClassName);
                        BeanWriterMetaInfoHolder metaInfHolder = (BeanWriterMetaInfoHolder)this.processedAnonymousComplexTypesMap.get(xsElt);
                        metaInfHolder.setOwnQname(schemaType.getQName());
                        metaInfHolder.setOwnClassName(fullyQualifiedClassName);
                        this.writeSimpleType((XmlSchemaSimpleType)schemaType, metaInfHolder);
                        this.processedAnonymousComplexTypesMap.remove(xsElt);
                        String className = this.findClassName(schemaType.getQName(), this.isArray((XmlSchemaParticle)xsElt));
                        innerElementMap.put(xsElt.getQName(), className);
                        xsElt.addMetaInfo((Object)"CLASS_NAME", (Object)className);
                    }
                }
            } else {
                this.processedElementList.add(xsElt.getQName());
            }
        } else if (xsElt.getRefName() != null) {
            if (xsElt.getRefName().equals(SchemaConstants.XSD_SCHEMA)) {
                innerElementMap.put(xsElt.getQName(), DEFAULT_CLASS_NAME);
                return;
            }
            XmlSchemaElement referencedElement = this.getReferencedElement(parentSchema, xsElt.getRefName());
            if (referencedElement == null) {
                throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.referencedElementNotFound", xsElt.getRefName().toString()));
            }
            this.processElement(referencedElement, parentSchema);
            QName referenceEltQName = referencedElement.getQName();
            if (referencedElement.getSchemaTypeName() != null) {
                String className = this.findClassName(referencedElement.getSchemaTypeName(), this.isArray((XmlSchemaParticle)xsElt));
                this.processedElementRefMap.put(referenceEltQName, className);
                referencedElement.addMetaInfo((Object)"CLASS_NAME", (Object)className);
            } else {
                QName generatedTypeName = this.generateTypeQName(referenceEltQName, parentSchema);
                XmlSchemaType referenceSchemaType = referencedElement.getSchemaType();
                if (referenceSchemaType instanceof XmlSchemaComplexType) {
                    referenceSchemaType.setName(generatedTypeName.getLocalPart());
                    this.writeComplexType((XmlSchemaComplexType)referenceSchemaType, (BeanWriterMetaInfoHolder)this.processedAnonymousComplexTypesMap.get(referencedElement));
                    this.processedElementRefMap.put(referenceEltQName, this.findClassName(referenceSchemaType.getQName(), this.isArray((XmlSchemaParticle)referencedElement)));
                }
            }
        } else if (xsElt.getSchemaTypeName() != null) {
            QName schemaTypeName = xsElt.getSchemaTypeName();
            XmlSchema currentParentSchema = this.resolveParentSchema(schemaTypeName, parentSchema);
            XmlSchemaType typeByName = this.getType(currentParentSchema, schemaTypeName);
            if (typeByName != null) {
                this.processSchema(xsElt, typeByName, currentParentSchema);
                if (!isOuter) {
                    String className = this.findClassName(schemaTypeName, this.isArray((XmlSchemaParticle)xsElt));
                    innerElementMap.put(xsElt.getQName(), className);
                } else {
                    this.processedElementList.add(xsElt.getQName());
                }
            } else if (!isOuter) {
                String className = this.findClassName(schemaTypeName, this.isArray((XmlSchemaParticle)xsElt));
                innerElementMap.put(xsElt.getQName(), className);
            } else {
                this.processedElementList.add(xsElt.getQName());
            }
        }
        if (xsElt.isNillable()) {
            if (isOuter) {
                this.nillableElementList.add(xsElt.getQName());
            } else {
                localNillableList.add(xsElt.getQName());
            }
        }
    }

    private XmlSchema resolveParentSchema(QName schemaTypeName, XmlSchema currentSchema) throws SchemaCompilationException {
        String targetNamespace = schemaTypeName.getNamespaceURI();
        Object loadedSchema = this.loadedSchemaMap.get(targetNamespace);
        if (loadedSchema != null) {
            return (XmlSchema)loadedSchema;
        }
        if (this.availableSchemaMap.containsKey(targetNamespace)) {
            XmlSchema schema = (XmlSchema)this.availableSchemaMap.get(targetNamespace);
            this.compile(schema);
            return schema;
        }
        return currentSchema;
    }

    private QName generateTypeQName(QName referenceEltQName, XmlSchema parentSchema) {
        QName generatedTypeName = new QName(referenceEltQName.getNamespaceURI(), referenceEltQName.getLocalPart() + this.getNextTypeSuffix());
        while (parentSchema.getTypeByName(generatedTypeName) != null) {
            generatedTypeName = new QName(referenceEltQName.getNamespaceURI(), referenceEltQName.getLocalPart() + this.getNextTypeSuffix());
        }
        return generatedTypeName;
    }

    private QName generateAttributeQName(QName attrRefName, XmlSchema parentSchema) {
        if (typeCounter == Integer.MAX_VALUE) {
            typeCounter = 0;
        }
        QName generatedAttrName = new QName(attrRefName.getNamespaceURI(), attrRefName.getLocalPart() + typeCounter++);
        while (parentSchema.getTypeByName(generatedAttrName) != null) {
            generatedAttrName = new QName(attrRefName.getNamespaceURI(), attrRefName.getLocalPart() + typeCounter++);
        }
        return generatedAttrName;
    }

    private boolean isAlreadyProcessed(QName qName) {
        return this.processedTypemap.containsKey(qName) || this.simpleTypesMap.containsKey(qName) || this.baseSchemaTypeMap.containsKey(qName);
    }

    private String findRefClassName(QName name, boolean isArray) {
        String className = null;
        if (this.processedElementRefMap.get(name) != null) {
            className = (String)this.processedElementRefMap.get(name);
        }
        return className;
    }

    private String findClassName(QName qName, boolean isArray) throws SchemaCompilationException {
        String className;
        if (this.processedTypemap.containsKey(qName)) {
            className = (String)this.processedTypemap.get(qName);
        } else if (this.simpleTypesMap.containsKey(qName)) {
            className = (String)this.simpleTypesMap.get(qName);
        } else if (this.baseSchemaTypeMap.containsKey(qName)) {
            className = (String)this.baseSchemaTypeMap.get(qName);
        } else {
            if (SchemaCompiler.isSOAP_ENC(qName.getNamespaceURI())) {
                throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.soapencoding.error", qName.toString()));
            }
            className = DEFAULT_CLASS_NAME;
            log.warn((Object)SchemaCompilerMessages.getMessage("schema.typeMissing", qName.toString()));
        }
        if (isArray) {
            className = className + "[]";
        }
        return className;
    }

    public static boolean isSOAP_ENC(String s) {
        if (s.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            return true;
        }
        return s.equals("http://www.w3.org/2003/05/soap-encoding");
    }

    private void processSchema(XmlSchemaElement xsElt, XmlSchemaType schemaType, XmlSchema parentSchema) throws SchemaCompilationException {
        if (schemaType instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType complexType = (XmlSchemaComplexType)schemaType;
            if (complexType.getName() != null) {
                this.processNamedComplexSchemaType(complexType, parentSchema);
            } else {
                this.processAnonymousComplexSchemaType(xsElt, complexType, parentSchema);
            }
        } else if (schemaType instanceof XmlSchemaSimpleType) {
            this.processSimpleSchemaType((XmlSchemaSimpleType)schemaType, xsElt, parentSchema);
        }
    }

    private void processAnonymousComplexSchemaType(XmlSchemaElement elt, XmlSchemaComplexType complexType, XmlSchema parentSchema) throws SchemaCompilationException {
        BeanWriterMetaInfoHolder metaInfHolder = this.processComplexType(complexType, parentSchema);
        this.processedAnonymousComplexTypesMap.put(elt, metaInfHolder);
    }

    private void processNamedComplexSchemaType(XmlSchemaComplexType complexType, XmlSchema parentSchema) throws SchemaCompilationException {
        if (this.processedTypemap.containsKey(complexType.getQName()) || this.baseSchemaTypeMap.containsKey(complexType.getQName())) {
            return;
        }
        String fullyQualifiedClassName = this.writer.makeFullyQualifiedClassName(complexType.getQName());
        this.processedTypemap.put(complexType.getQName(), fullyQualifiedClassName);
        complexType.addMetaInfo((Object)"CLASS_NAME", (Object)fullyQualifiedClassName);
        BeanWriterMetaInfoHolder metaInfHolder = this.processComplexType(complexType, parentSchema);
        metaInfHolder.setOwnQname(complexType.getQName());
        metaInfHolder.setOwnClassName(fullyQualifiedClassName);
        this.writeComplexType(complexType, metaInfHolder);
    }

    private void writeComplexType(XmlSchemaComplexType complexType, BeanWriterMetaInfoHolder metaInfHolder) throws SchemaCompilationException {
        this.writer.write(complexType, (Map)this.processedTypemap, metaInfHolder);
        this.processedTypeMetaInfoMap.put(complexType.getQName(), metaInfHolder);
    }

    private void writeSimpleType(XmlSchemaSimpleType simpleType, BeanWriterMetaInfoHolder metaInfHolder) throws SchemaCompilationException {
        this.writer.write(simpleType, (Map)this.processedTypemap, metaInfHolder);
        this.processedTypeMetaInfoMap.put(simpleType.getQName(), metaInfHolder);
    }

    private BeanWriterMetaInfoHolder processComplexType(XmlSchemaComplexType complexType, XmlSchema parentSchema) throws SchemaCompilationException {
        XmlSchemaParticle particle = complexType.getParticle();
        BeanWriterMetaInfoHolder metaInfHolder = new BeanWriterMetaInfoHolder();
        if (particle != null) {
            this.processParticle(particle, metaInfHolder, parentSchema);
        }
        XmlSchemaObjectCollection attribs = complexType.getAttributes();
        Iterator attribIterator = attribs.getIterator();
        while (attribIterator.hasNext()) {
            Object o = attribIterator.next();
            if (!(o instanceof XmlSchemaAttribute)) continue;
            this.processAttribute((XmlSchemaAttribute)o, metaInfHolder, parentSchema);
        }
        XmlSchemaAnyAttribute anyAtt = complexType.getAnyAttribute();
        if (anyAtt != null) {
            this.processAnyAttribute(metaInfHolder, anyAtt);
        }
        if (complexType.getContentModel() != null) {
            this.processContentModel(complexType.getContentModel(), metaInfHolder, parentSchema);
        }
        return metaInfHolder;
    }

    private void processContentModel(XmlSchemaContentModel content, BeanWriterMetaInfoHolder metaInfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        if (content instanceof XmlSchemaComplexContent) {
            this.processComplexContent((XmlSchemaComplexContent)content, metaInfHolder, parentSchema);
        } else if (content instanceof XmlSchemaSimpleContent) {
            this.processSimpleContent((XmlSchemaSimpleContent)content, metaInfHolder, parentSchema);
            metaInfHolder.setSimple(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processComplexContent(XmlSchemaComplexContent complexContent, BeanWriterMetaInfoHolder metaInfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        XmlSchemaContent content = complexContent.getContent();
        if (content instanceof XmlSchemaComplexContentExtension) {
            XmlSchemaComplexContentExtension extension = (XmlSchemaComplexContentExtension)content;
            if (!this.isAlreadyProcessed(extension.getBaseTypeName())) {
                XmlSchemaType type = this.getType(parentSchema, extension.getBaseTypeName());
                if (type instanceof XmlSchemaComplexType) {
                    XmlSchemaComplexType complexType = (XmlSchemaComplexType)type;
                    if (complexType.getName() == null) throw new SchemaCompilationException("Unnamed complex type used in extension");
                    this.processNamedComplexSchemaType(complexType, parentSchema);
                } else if (type instanceof XmlSchemaSimpleType) {
                    this.processSimpleSchemaType((XmlSchemaSimpleType)type, null, parentSchema);
                }
            }
            this.copyMetaInfoHierarchy(metaInfHolder, extension.getBaseTypeName(), parentSchema);
            this.processParticle(extension.getParticle(), metaInfHolder, parentSchema);
            String className = this.findClassName(extension.getBaseTypeName(), false);
            if (DEFAULT_CLASS_NAME.equals(className)) return;
            metaInfHolder.setExtension(true);
            metaInfHolder.setExtensionClassName(className);
            return;
        } else {
            if (!(content instanceof XmlSchemaComplexContentRestriction)) return;
            XmlSchemaComplexContentRestriction restriction = (XmlSchemaComplexContentRestriction)content;
            if (!this.isAlreadyProcessed(restriction.getBaseTypeName())) {
                XmlSchemaType type = this.getType(parentSchema, restriction.getBaseTypeName());
                if (type instanceof XmlSchemaComplexType) {
                    XmlSchemaComplexType complexType = (XmlSchemaComplexType)type;
                    if (complexType.getName() == null) throw new SchemaCompilationException("Unnamed complex type used in restriction");
                    this.processNamedComplexSchemaType(complexType, parentSchema);
                } else if (type instanceof XmlSchemaSimpleType) {
                    throw new SchemaCompilationException("Not a valid restriction, complex content restriction base type cannot be a simple type.");
                }
            }
            this.copyMetaInfoHierarchy(metaInfHolder, restriction.getBaseTypeName(), parentSchema);
            this.processParticle(restriction.getParticle(), metaInfHolder, parentSchema);
            String className = this.findClassName(restriction.getBaseTypeName(), false);
            if (DEFAULT_CLASS_NAME.equals(className)) return;
            metaInfHolder.setRestriction(true);
            metaInfHolder.setRestrictionClassName(this.findClassName(restriction.getBaseTypeName(), false));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyMetaInfoHierarchy(BeanWriterMetaInfoHolder metaInfHolder, QName baseTypeName, XmlSchema parentSchema) throws SchemaCompilationException {
        XmlSchemaType type = parentSchema.getTypeByName(baseTypeName);
        BeanWriterMetaInfoHolder baseMetaInfoHolder = (BeanWriterMetaInfoHolder)this.processedTypeMetaInfoMap.get(baseTypeName);
        if (baseMetaInfoHolder == null || !(type instanceof XmlSchemaComplexType)) return;
        XmlSchemaComplexType complexType = (XmlSchemaComplexType)type;
        if (complexType.getContentModel() != null) {
            XmlSchemaContentModel content = complexType.getContentModel();
            if (content instanceof XmlSchemaComplexContent) {
                XmlSchemaComplexContent complexContent = (XmlSchemaComplexContent)content;
                if (complexContent.getContent() instanceof XmlSchemaComplexContentExtension) {
                    XmlSchemaComplexContentExtension extension = (XmlSchemaComplexContentExtension)complexContent.getContent();
                    this.copyMetaInfoHierarchy(baseMetaInfoHolder, extension.getBaseTypeName(), parentSchema);
                } else {
                    if (!(complexContent.getContent() instanceof XmlSchemaComplexContentRestriction)) throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.unknowncontenterror"));
                    XmlSchemaComplexContentRestriction restriction = (XmlSchemaComplexContentRestriction)complexContent.getContent();
                    this.copyMetaInfoHierarchy(baseMetaInfoHolder, restriction.getBaseTypeName(), parentSchema);
                }
            } else {
                if (!(content instanceof XmlSchemaSimpleContent)) throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.unknowncontenterror"));
                throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.unsupportedcontenterror", "Simple Content"));
            }
        }
        metaInfHolder.setAsParent(baseMetaInfoHolder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processSimpleContent(XmlSchemaSimpleContent simpleContent, BeanWriterMetaInfoHolder metaInfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        XmlSchemaContent content = simpleContent.getContent();
        if (content instanceof XmlSchemaSimpleContentExtension) {
            XmlSchemaSimpleContentExtension extension = (XmlSchemaSimpleContentExtension)content;
            if (!this.isAlreadyProcessed(extension.getBaseTypeName())) {
                XmlSchemaType type = this.getType(parentSchema, extension.getBaseTypeName());
                if (type instanceof XmlSchemaComplexType) {
                    XmlSchemaComplexType complexType = (XmlSchemaComplexType)type;
                    if (complexType.getName() == null) throw new SchemaCompilationException("Unnamed complex type used in extension");
                    this.processNamedComplexSchemaType(complexType, parentSchema);
                } else if (type instanceof XmlSchemaSimpleType) {
                    this.processSimpleSchemaType((XmlSchemaSimpleType)type, null, parentSchema);
                }
            }
            this.processSimpleExtensionBaseType(extension.getBaseTypeName(), metaInfHolder);
            XmlSchemaObjectCollection attribs = extension.getAttributes();
            Iterator attribIterator = attribs.getIterator();
            while (attribIterator.hasNext()) {
                Object attr = attribIterator.next();
                if (!(attr instanceof XmlSchemaAttribute)) continue;
                this.processAttribute((XmlSchemaAttribute)attr, metaInfHolder, parentSchema);
            }
            XmlSchemaAnyAttribute anyAtt = extension.getAnyAttribute();
            if (anyAtt == null) return;
            this.processAnyAttribute(metaInfHolder, anyAtt);
            return;
        } else {
            if (!(content instanceof XmlSchemaSimpleContentRestriction)) return;
            XmlSchemaSimpleContentRestriction restriction = (XmlSchemaSimpleContentRestriction)content;
            if (!this.isAlreadyProcessed(restriction.getBaseTypeName())) {
                XmlSchemaType type = this.getType(parentSchema, restriction.getBaseTypeName());
                if (type instanceof XmlSchemaComplexType) {
                    XmlSchemaComplexType complexType = (XmlSchemaComplexType)type;
                    if (complexType.getName() == null) throw new SchemaCompilationException("Unnamed complex type used in restriction");
                    this.processNamedComplexSchemaType(complexType, parentSchema);
                } else if (type instanceof XmlSchemaSimpleType) {
                    this.processSimpleSchemaType((XmlSchemaSimpleType)type, null, parentSchema);
                }
            }
            this.processSimpleRestrictionBaseType(restriction.getBaseTypeName(), restriction.getBaseTypeName(), metaInfHolder);
        }
    }

    public void processSimpleExtensionBaseType(QName extBaseType, BeanWriterMetaInfoHolder metaInfHolder) throws SchemaCompilationException {
        String className = this.findClassName(extBaseType, false);
        if (this.changedTypeMap.containsKey(extBaseType)) {
            metaInfHolder.registerMapping(extBaseType, (QName)this.changedTypeMap.get(extBaseType), className, 2);
        } else {
            metaInfHolder.registerMapping(extBaseType, extBaseType, className, 2);
        }
        if (this.isBinary(extBaseType)) {
            metaInfHolder.addtStatus(extBaseType, 16);
        }
    }

    public void processSimpleRestrictionBaseType(QName qName, QName resBaseType, BeanWriterMetaInfoHolder metaInfHolder) throws SchemaCompilationException {
        String className = this.findClassName(resBaseType, false);
        if (this.changedTypeMap.containsKey(resBaseType)) {
            metaInfHolder.registerMapping(qName, (QName)this.changedTypeMap.get(resBaseType), className, 2);
        } else {
            metaInfHolder.registerMapping(qName, resBaseType, className, 2);
        }
        metaInfHolder.setRestrictionBaseType(resBaseType);
    }

    private void processFacets(XmlSchemaObjectCollection facets, BeanWriterMetaInfoHolder metaInfHolder) {
        Iterator facetIterator = facets.getIterator();
        while (facetIterator.hasNext()) {
            Object obj = facetIterator.next();
            if (obj instanceof XmlSchemaPatternFacet) {
                XmlSchemaPatternFacet pattern = (XmlSchemaPatternFacet)obj;
                metaInfHolder.setPatternFacet(pattern.getValue().toString());
                continue;
            }
            if (obj instanceof XmlSchemaEnumerationFacet) {
                XmlSchemaEnumerationFacet enumeration = (XmlSchemaEnumerationFacet)obj;
                metaInfHolder.addEnumFacet(enumeration.getValue().toString());
                continue;
            }
            if (obj instanceof XmlSchemaLengthFacet) {
                XmlSchemaLengthFacet length = (XmlSchemaLengthFacet)obj;
                metaInfHolder.setLengthFacet(Integer.parseInt(length.getValue().toString()));
                continue;
            }
            if (obj instanceof XmlSchemaMaxExclusiveFacet) {
                XmlSchemaMaxExclusiveFacet maxEx = (XmlSchemaMaxExclusiveFacet)obj;
                metaInfHolder.setMaxExclusiveFacet(maxEx.getValue().toString());
                continue;
            }
            if (obj instanceof XmlSchemaMinExclusiveFacet) {
                XmlSchemaMinExclusiveFacet minEx = (XmlSchemaMinExclusiveFacet)obj;
                metaInfHolder.setMinExclusiveFacet(minEx.getValue().toString());
                continue;
            }
            if (obj instanceof XmlSchemaMaxInclusiveFacet) {
                XmlSchemaMaxInclusiveFacet maxIn = (XmlSchemaMaxInclusiveFacet)obj;
                metaInfHolder.setMaxInclusiveFacet(maxIn.getValue().toString());
                continue;
            }
            if (obj instanceof XmlSchemaMinInclusiveFacet) {
                XmlSchemaMinInclusiveFacet minIn = (XmlSchemaMinInclusiveFacet)obj;
                metaInfHolder.setMinInclusiveFacet(minIn.getValue().toString());
                continue;
            }
            if (obj instanceof XmlSchemaMaxLengthFacet) {
                XmlSchemaMaxLengthFacet maxLen = (XmlSchemaMaxLengthFacet)obj;
                metaInfHolder.setMaxLengthFacet(Integer.parseInt(maxLen.getValue().toString()));
                continue;
            }
            if (!(obj instanceof XmlSchemaMinLengthFacet)) continue;
            XmlSchemaMinLengthFacet minLen = (XmlSchemaMinLengthFacet)obj;
            metaInfHolder.setMinLengthFacet(Integer.parseInt(minLen.getValue().toString()));
        }
    }

    private void processAnyAttribute(BeanWriterMetaInfoHolder metainf, XmlSchemaAnyAttribute anyAtt) {
        QName qName = new QName(EXTRA_ATTRIBUTE_FIELD_NAME);
        metainf.registerMapping(qName, null, DEFAULT_ATTRIB_ARRAY_CLASS_NAME, 8);
        metainf.addtStatus(qName, 1);
        metainf.addtStatus(qName, 4);
    }

    public void processAttribute(XmlSchemaAttribute att, BeanWriterMetaInfoHolder metainf, XmlSchema parentSchema) throws SchemaCompilationException {
        block4: {
            block3: {
                QName schemaTypeName = att.getSchemaTypeName();
                if (schemaTypeName == null) break block3;
                if (!this.baseSchemaTypeMap.containsKey(schemaTypeName) || att.getQName() == null) break block4;
                metainf.registerMapping(att.getQName(), schemaTypeName, this.baseSchemaTypeMap.get(schemaTypeName).toString(), 1);
                String use = att.getUse().getValue();
                if (use.indexOf("optional") == -1) break block4;
                metainf.addtStatus(att.getQName(), 32);
                break block4;
            }
            if (att.getRefName() != null) {
                XmlSchema currentParentSchema = this.resolveParentSchema(att.getRefName(), parentSchema);
                QName attrQname = this.generateAttributeQName(att.getRefName(), parentSchema);
                XmlSchemaObjectCollection items = currentParentSchema.getItems();
                Iterator itemIterator = items.getIterator();
                while (itemIterator.hasNext()) {
                    XmlSchemaSimpleType simpleType;
                    XmlSchemaAttribute attribute;
                    Object attr = itemIterator.next();
                    if (!(attr instanceof XmlSchemaAttribute) || !(attribute = (XmlSchemaAttribute)attr).getName().equals(att.getRefName().getLocalPart())) continue;
                    QName attrTypeName = attribute.getSchemaTypeName();
                    Object type = this.baseSchemaTypeMap.get(attrTypeName);
                    if (type == null && (simpleType = attribute.getSchemaType()) != null && simpleType.getContent() instanceof XmlSchemaSimpleTypeRestriction) {
                        XmlSchemaSimpleTypeRestriction restriction = (XmlSchemaSimpleTypeRestriction)simpleType.getContent();
                        QName baseTypeName = restriction.getBaseTypeName();
                        type = this.baseSchemaTypeMap.get(baseTypeName);
                        attrQname = att.getRefName();
                    }
                    if (type == null) continue;
                    metainf.registerMapping(attrQname, attrQname, type.toString(), 1);
                    String use = att.getUse().getValue();
                    if (use.indexOf("optional") == -1) continue;
                    metainf.addtStatus(att.getQName(), 32);
                }
            }
        }
    }

    private void processParticle(XmlSchemaParticle particle, BeanWriterMetaInfoHolder metainfHolder, XmlSchema parentSchema) throws SchemaCompilationException {
        if (particle instanceof XmlSchemaSequence) {
            XmlSchemaObjectCollection items = ((XmlSchemaSequence)particle).getItems();
            if (this.options.isBackwordCompatibilityMode()) {
                this.process(items, metainfHolder, false, parentSchema);
            } else {
                this.process(items, metainfHolder, true, parentSchema);
            }
        } else if (particle instanceof XmlSchemaAll) {
            XmlSchemaObjectCollection items = ((XmlSchemaAll)particle).getItems();
            this.process(items, metainfHolder, false, parentSchema);
        } else if (particle instanceof XmlSchemaChoice) {
            XmlSchemaObjectCollection items = ((XmlSchemaChoice)particle).getItems();
            metainfHolder.setChoice(true);
            this.process(items, metainfHolder, false, parentSchema);
        }
    }

    private void process(XmlSchemaObjectCollection items, BeanWriterMetaInfoHolder metainfHolder, boolean order, XmlSchema parentSchema) throws SchemaCompilationException {
        int count = items.getCount();
        LinkedHashMap<Object, Boolean> processedElementArrayStatusMap = new LinkedHashMap<Object, Boolean>();
        LinkedHashMap<QName, XmlSchemaAny> processedElementTypeMap = new LinkedHashMap<QName, XmlSchemaAny>();
        ArrayList localNillableList = new ArrayList();
        HashMap<Object, Integer> elementOrderMap = new HashMap<Object, Integer>();
        for (int i = 0; i < count; ++i) {
            XmlSchemaObject item = items.getItem(i);
            if (item instanceof XmlSchemaElement) {
                XmlSchemaElement xsElt = (XmlSchemaElement)item;
                boolean isArray = this.isArray((XmlSchemaParticle)xsElt);
                this.processElement(xsElt, processedElementTypeMap, localNillableList, parentSchema);
                processedElementArrayStatusMap.put(xsElt, isArray ? Boolean.TRUE : Boolean.FALSE);
                if (!order) continue;
                elementOrderMap.put(xsElt, new Integer(i));
                continue;
            }
            if (!(item instanceof XmlSchemaAny)) continue;
            XmlSchemaAny any = (XmlSchemaAny)item;
            processedElementTypeMap.put(new QName(ANY_ELEMENT_FIELD_NAME), any);
            if (order) {
                elementOrderMap.put(any, new Integer(i));
            }
            processedElementArrayStatusMap.put(any, this.isArray((XmlSchemaParticle)any) ? Boolean.TRUE : Boolean.FALSE);
        }
        Iterator processedElementsIterator = processedElementArrayStatusMap.keySet().iterator();
        int startingItemNumberOrder = metainfHolder.getOrderStartPoint();
        while (processedElementsIterator.hasNext()) {
            Object child = processedElementsIterator.next();
            if (child instanceof XmlSchemaElement) {
                String clazzName;
                XmlSchemaElement elt = (XmlSchemaElement)child;
                QName referencedQName = null;
                if (elt.getQName() != null) {
                    QName schemaTypeQName;
                    referencedQName = elt.getQName();
                    QName qName = schemaTypeQName = elt.getSchemaType() != null ? elt.getSchemaType().getQName() : elt.getSchemaTypeName();
                    if (schemaTypeQName != null) {
                        clazzName = (String)processedElementTypeMap.get(elt.getQName());
                        metainfHolder.registerMapping(referencedQName, schemaTypeQName, clazzName, (Boolean)processedElementArrayStatusMap.get(elt) != false ? 4 : 2);
                    }
                }
                if (elt.getRefName() != null) {
                    XmlSchemaElement refElement;
                    boolean arrayStatus;
                    referencedQName = elt.getRefName();
                    clazzName = this.findRefClassName(referencedQName, arrayStatus = ((Boolean)processedElementArrayStatusMap.get(elt)).booleanValue());
                    if (clazzName == null) {
                        clazzName = this.findClassName(referencedQName, arrayStatus);
                    }
                    if ((refElement = this.getReferencedElement(parentSchema, referencedQName)) != null) {
                        metainfHolder.registerMapping(referencedQName, refElement.getSchemaTypeName(), clazzName, arrayStatus ? 4 : 2);
                    } else if (referencedQName.equals(SchemaConstants.XSD_SCHEMA)) {
                        metainfHolder.registerMapping(referencedQName, null, DEFAULT_CLASS_NAME, 8);
                    } else {
                        throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.referencedElementNotFound", referencedQName.toString()));
                    }
                }
                if (referencedQName == null) {
                    throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.emptyName"));
                }
                metainfHolder.addMaxOccurs(referencedQName, elt.getMaxOccurs());
                metainfHolder.addMinOccurs(referencedQName, elt.getMinOccurs());
                if (order) {
                    Integer integer = (Integer)elementOrderMap.get(elt);
                    metainfHolder.registerQNameIndex(referencedQName, startingItemNumberOrder + integer);
                }
                if (localNillableList.contains(elt.getQName())) {
                    metainfHolder.registerNillableQName(elt.getQName());
                }
                if (!this.isBinary(elt)) continue;
                metainfHolder.addtStatus(elt.getQName(), 16);
                continue;
            }
            if (!(child instanceof XmlSchemaAny)) continue;
            XmlSchemaAny any = (XmlSchemaAny)child;
            QName anyElementFieldName = new QName(ANY_ELEMENT_FIELD_NAME);
            boolean isArray = (Boolean)processedElementArrayStatusMap.get(any);
            metainfHolder.registerMapping(anyElementFieldName, null, isArray ? DEFAULT_CLASS_ARRAY_NAME : DEFAULT_CLASS_NAME, 8);
            if (isArray) {
                metainfHolder.addtStatus(anyElementFieldName, 4);
            }
            metainfHolder.addMaxOccurs(anyElementFieldName, any.getMaxOccurs());
            metainfHolder.addMinOccurs(anyElementFieldName, any.getMinOccurs());
            if (!order) continue;
            Integer integer = (Integer)elementOrderMap.get(any);
            metainfHolder.registerQNameIndex(anyElementFieldName, startingItemNumberOrder + integer);
        }
        metainfHolder.setOrdered(order);
    }

    private XmlSchemaType getType(XmlSchema schema, QName schemaTypeName) throws SchemaCompilationException {
        XmlSchemaObjectCollection includes;
        XmlSchemaType typeByName = (schema = this.resolveParentSchema(schemaTypeName, schema)).getTypeByName(schemaTypeName);
        if (typeByName == null && (includes = schema.getIncludes()) != null) {
            Iterator tempIterator = includes.getIterator();
            while (tempIterator.hasNext()) {
                Object o = tempIterator.next();
                XmlSchema inclSchema = null;
                if (o instanceof XmlSchemaImport && (inclSchema = ((XmlSchemaImport)o).getSchema()) == null) {
                    inclSchema = (XmlSchema)this.loadedSchemaMap.get(((XmlSchemaImport)o).getNamespace());
                }
                if (o instanceof XmlSchemaInclude) {
                    inclSchema = ((XmlSchemaInclude)o).getSchema();
                }
                if (inclSchema != null) {
                    typeByName = inclSchema.getTypeByName(schemaTypeName);
                }
                if (typeByName == null) continue;
                break;
            }
        }
        return typeByName;
    }

    private XmlSchemaElement getReferencedElement(XmlSchema parentSchema, QName referencedQName) {
        XmlSchemaObjectCollection includes;
        XmlSchemaElement refElement = parentSchema.getElementByName(referencedQName);
        if (refElement == null && (includes = parentSchema.getIncludes()) != null) {
            Iterator tempIterator = includes.getIterator();
            while (tempIterator.hasNext()) {
                Object o = tempIterator.next();
                XmlSchema inclSchema = null;
                if (o instanceof XmlSchemaImport && (inclSchema = ((XmlSchemaImport)o).getSchema()) == null) {
                    inclSchema = (XmlSchema)this.loadedSchemaMap.get(((XmlSchemaImport)o).getNamespace());
                }
                if (o instanceof XmlSchemaInclude) {
                    inclSchema = ((XmlSchemaInclude)o).getSchema();
                }
                if (inclSchema != null) {
                    refElement = inclSchema.getElementByName(referencedQName);
                }
                if (refElement == null) continue;
                break;
            }
        }
        return refElement;
    }

    private boolean isBinary(XmlSchemaElement elt) {
        return elt.getSchemaType() != null && SchemaConstants.XSD_BASE64.equals(elt.getSchemaType().getQName());
    }

    private boolean isBinary(QName qName) {
        return qName != null && SchemaConstants.XSD_BASE64.equals(qName);
    }

    private void processSimpleSchemaType(XmlSchemaSimpleType simpleType, XmlSchemaElement xsElt, XmlSchema parentSchema) throws SchemaCompilationException {
        if (this.processedTypemap.containsKey(simpleType.getQName()) || this.baseSchemaTypeMap.containsKey(simpleType.getQName())) {
            return;
        }
        String fullyQualifiedClassName = null;
        if (simpleType.getQName() != null) {
            fullyQualifiedClassName = this.writer.makeFullyQualifiedClassName(simpleType.getQName());
        } else {
            fullyQualifiedClassName = this.writer.makeFullyQualifiedClassName(xsElt.getQName());
            simpleType.addMetaInfo((Object)"Q_NAME", (Object)new QName(xsElt.getQName().getNamespaceURI(), xsElt.getQName().getLocalPart()));
        }
        this.processedTypemap.put(simpleType.getQName(), fullyQualifiedClassName);
        simpleType.addMetaInfo((Object)"CLASS_NAME", (Object)fullyQualifiedClassName);
        BeanWriterMetaInfoHolder metaInfHolder = this.processSimpleType(simpleType, parentSchema);
        metaInfHolder.setSimple(true);
        if (simpleType.getQName() == null) {
            this.processedAnonymousComplexTypesMap.put(xsElt, metaInfHolder);
            this.simpleTypesMap.put(new QName(xsElt.getQName().getNamespaceURI(), xsElt.getQName().getLocalPart()), fullyQualifiedClassName);
        }
        metaInfHolder.setOwnQname(simpleType.getQName());
        if (fullyQualifiedClassName != null) {
            metaInfHolder.setOwnClassName(fullyQualifiedClassName);
        }
        this.writeSimpleType(simpleType, metaInfHolder);
    }

    private BeanWriterMetaInfoHolder processSimpleType(XmlSchemaSimpleType simpleType, XmlSchema parentSchema) throws SchemaCompilationException {
        BeanWriterMetaInfoHolder metaInfHolder = new BeanWriterMetaInfoHolder();
        XmlSchemaSimpleTypeContent content = simpleType.getContent();
        if (content != null) {
            if (content instanceof XmlSchemaSimpleTypeRestriction) {
                XmlSchemaSimpleTypeRestriction restriction = (XmlSchemaSimpleTypeRestriction)content;
                QName baseTypeName = restriction.getBaseTypeName();
                if (this.baseSchemaTypeMap.containsKey(baseTypeName)) {
                    QName qName = simpleType.getQName();
                    if (qName == null) {
                        qName = (QName)simpleType.getMetaInfoMap().get("Q_NAME");
                    }
                    this.processSimpleRestrictionBaseType(qName, restriction.getBaseTypeName(), metaInfHolder);
                    XmlSchemaObjectCollection facets = restriction.getFacets();
                    this.processFacets(facets, metaInfHolder);
                } else if (restriction.getBaseType() != null) {
                    this.processSimpleSchemaType(restriction.getBaseType(), null, parentSchema);
                }
            } else {
                if (content instanceof XmlSchemaSimpleTypeUnion) {
                    throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.unsupportedcontenterror", "Simple Type Union in " + simpleType.getQName()));
                }
                if (content instanceof XmlSchemaSimpleTypeList) {
                    throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.unsupportedcontenterror", "Simple Type List in " + simpleType.getQName()));
                }
            }
        }
        return metaInfHolder;
    }

    private boolean isArray(XmlSchemaParticle particle) throws SchemaCompilationException {
        long minOccurs = particle.getMinOccurs();
        long maxOccurs = particle.getMaxOccurs();
        if (maxOccurs < minOccurs) {
            throw new SchemaCompilationException();
        }
        return maxOccurs > 1L;
    }

    private String getNextTypeSuffix() {
        if (typeCounter == Integer.MAX_VALUE) {
            typeCounter = 0;
        }
        return "_type" + typeCounter++;
    }
}

