/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class Logger {
    private static final Map _LOGGERS = new HashMap();
    private List _handlers = new LinkedList();
    private Level _level = Level.ALL;
    private String _name = null;

    private Logger(String name) {
        this._name = name;
    }

    public void addHandler(Handler handler) {
        handler.setLevel(this.getLevel());
        this._handlers.add(handler);
    }

    public void config(String message) {
        this.log(Level.CONFIG, message);
    }

    public void fine(String message) {
        this.log(Level.FINE, message);
    }

    public void finer(String message) {
        this.log(Level.FINER, message);
    }

    public void finest(String message) {
        this.log(Level.FINEST, message);
    }

    public Handler[] getHandlers() {
        Handler[] array = new Handler[this._handlers.size()];
        return this._handlers.toArray(array);
    }

    public Level getLevel() {
        return this._level;
    }

    public static Logger getLogger(String name) {
        if (!_LOGGERS.containsKey(name)) {
            _LOGGERS.put(name, new Logger(name));
        }
        return (Logger)_LOGGERS.get(name);
    }

    public String getName() {
        return this._name;
    }

    public void info(String message) {
        this.log(Level.INFO, message);
    }

    public boolean isLoggable(LogRecord record) {
        return this.getLevel().intValue() >= record.getLevel().intValue();
    }

    public void log(Level level, String message) {
        LogRecord record = new LogRecord(level, message);
        if (!this.isLoggable(record)) {
            return;
        }
        Iterator i = this._handlers.iterator();
        while (i.hasNext()) {
            Handler next = (Handler)i.next();
            next.publish(record);
        }
    }

    public void removeHandler(Handler handler) {
        this._handlers.remove(handler);
    }

    public void setLevel(Level level) {
        this._level = level;
    }

    public void severe(String message) {
        this.log(Level.SEVERE, message);
    }

    public String toString() {
        return this.getName();
    }

    public void warning(String message) {
        this.log(Level.WARNING, message);
    }
}

