/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.util.HashMap;
import java.util.Map;

public class Level {
    public static final Level OFF = new Level("OFF", 0);
    public static final Level SEVERE = new Level("SEVERE", 1);
    public static final Level WARNING = new Level("WARNING", 2);
    public static final Level INFO = new Level("INFO", 3);
    public static final Level CONFIG = new Level("CONFIG", 4);
    public static final Level FINE = new Level("FINE", 5);
    public static final Level FINER = new Level("FINER", 6);
    public static final Level FINEST = new Level("FINEST", 7);
    public static final Level ALL = new Level("ALL", 8);
    private static final Map _LEVELS_BY_NAME = new HashMap();
    private String _name = null;
    private int _value;

    static {
        _LEVELS_BY_NAME.put(OFF.getName(), OFF);
        _LEVELS_BY_NAME.put(SEVERE.getName(), SEVERE);
        _LEVELS_BY_NAME.put(WARNING.getName(), WARNING);
        _LEVELS_BY_NAME.put(INFO.getName(), INFO);
        _LEVELS_BY_NAME.put(CONFIG.getName(), CONFIG);
        _LEVELS_BY_NAME.put(FINE.getName(), FINE);
        _LEVELS_BY_NAME.put(FINER.getName(), FINER);
        _LEVELS_BY_NAME.put(FINEST.getName(), FINEST);
        _LEVELS_BY_NAME.put(ALL.getName(), ALL);
    }

    private Level(String name, int value) {
        this._name = name;
        this._value = value;
    }

    public String getName() {
        return this._name;
    }

    public int intValue() {
        return this._value;
    }

    public static Level parse(String name) {
        Level level = (Level)_LEVELS_BY_NAME.get(name);
        if (level == null) {
            throw new IllegalArgumentException("Invalid logging level: " + name);
        }
        return level;
    }

    public String toString() {
        return this.getName();
    }
}

