/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.rpc.receivers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.receivers.AbstractInMessageReceiver;
import org.apache.axis2.rpc.receivers.RPCUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RPCInOnlyMessageReceiver
extends AbstractInMessageReceiver {
    private Method method;
    private static Log log = LogFactory.getLog((Class)RPCInOnlyMessageReceiver.class);

    public void invokeBusinessLogic(MessageContext inMessage) throws AxisFault {
        try {
            Object obj = this.getTheImplementationObject(inMessage);
            Class<?> ImplClass = obj.getClass();
            AxisOperation op = inMessage.getOperationContext().getAxisOperation();
            OMElement methodElement = inMessage.getEnvelope().getBody().getFirstElement();
            AxisMessage inAxisMessage = op.getMessage("In");
            String methodName = op.getName().getLocalPart();
            Method[] methods = ImplClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(methodName)) continue;
                this.method = methods[i];
                break;
            }
            if (inAxisMessage != null) {
                if (inAxisMessage.getElementQName() == null) {
                    this.method.invoke(obj, new Object[0]);
                } else {
                    QName elementQName = inAxisMessage.getElementQName();
                    String messageNameSpace = elementQName.getNamespaceURI();
                    OMNamespace namespace = methodElement.getNamespace();
                    if (messageNameSpace != null) {
                        if (namespace == null || !messageNameSpace.equals(namespace.getNamespaceURI())) {
                            throw new AxisFault("namespace mismatch require " + messageNameSpace + " found " + methodElement.getNamespace().getNamespaceURI());
                        }
                    } else if (namespace != null) {
                        throw new AxisFault("namespace mismatch. Axis Oepration expects non-namespace qualified element. But received a namespace qualified element");
                    }
                    Object[] objectArray = RPCUtil.processRequest(methodElement, this.method, inMessage.getAxisService().getObjectSupplier());
                    this.method.invoke(obj, objectArray);
                }
            }
        }
        catch (InvocationTargetException e) {
            String msg = null;
            if (e.getCause() != null) {
                msg = e.getCause().getMessage();
            }
            if (msg == null) {
                msg = "Exception occurred while trying to invoke service method " + this.method.getName();
            }
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg);
        }
        catch (Exception e) {
            String msg = "Exception occurred while trying to invoke service method " + this.method.getName();
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }
}

