/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.socket.https;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ServerSocketFactory;
import org.eclipse.equinox.socket.ServerSocketInterface;
import org.eclipse.equinox.socket.SocketInterface;
import org.eclipse.equinox.socket.https.HttpsSocket;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class HttpsServerSocket
implements ServerSocketInterface,
ServiceTrackerCustomizer {
    protected String address = null;
    protected BundleContext context = null;
    protected int port = 443;
    protected int backlog = 50;
    protected InetAddress bindAddr = null;
    protected ServiceTracker st = null;
    protected ServerSocketFactory ssf = null;
    protected ServerSocket ss = null;
    protected ServerSocket dummyss = null;

    public HttpsServerSocket(BundleContext context, int port) throws IOException {
        this(context, port, 50);
    }

    public HttpsServerSocket(BundleContext context, int port, int backlog) throws IOException {
        this(context, port, backlog, null);
    }

    public HttpsServerSocket(BundleContext context, int port, int backlog, InetAddress bindAddr) throws IOException {
        this.context = context;
        this.port = port;
        this.backlog = backlog;
        this.bindAddr = bindAddr;
        this.dummyss = new ServerSocket(port, backlog, bindAddr);
        this.st = new ServiceTracker(context, "javax.net.ssl.SSLServerSocketFactory", (ServiceTrackerCustomizer)this);
        this.st.open();
    }

    public synchronized SocketInterface acceptSock() throws IOException {
        while (this.ssf == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException();
            }
        }
        if (this.ss == null) {
            if (this.dummyss != null) {
                this.dummyss.close();
                this.dummyss = null;
            }
            this.ss = this.ssf.createServerSocket(this.port, this.backlog, this.bindAddr);
        }
        Socket socket = this.ss.accept();
        return new HttpsSocket(socket);
    }

    public void close() throws IOException {
        if (this.ss != null) {
            this.ss.close();
        }
    }

    public int getLocalPort() {
        if (this.ss != null) {
            return this.ss.getLocalPort();
        }
        return 0;
    }

    public String getScheme() {
        return "https";
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public synchronized Object addingService(ServiceReference reference) {
        if (this.ssf == null) {
            this.ssf = (ServerSocketFactory)this.context.getService(reference);
            this.notify();
            return this.ssf;
        }
        return null;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public synchronized void removedService(ServiceReference reference, Object service) {
        this.ssf = null;
        if (this.ss != null) {
            try {
                this.ss.close();
            }
            catch (IOException iOException) {}
            this.ss = null;
        }
    }
}

