/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.eclipse.equinox.http.servlet.HttpServletResponseImpl;

class ServletOutputStreamImpl
extends ServletOutputStream {
    private OutputStream realOut;
    private HttpServletResponseImpl response;
    private boolean open;
    private ByteArrayOutputStream buffer;
    private OutputStream out;
    private boolean writeHeaders;
    private boolean flush;
    private boolean closing;

    ServletOutputStreamImpl(OutputStream realOut, HttpServletResponseImpl response) {
        this.realOut = realOut;
        this.response = response;
        this.buffer = new ByteArrayOutputStream(8192);
        this.out = this.buffer;
        this.open = true;
        this.writeHeaders = true;
        this.closing = false;
        this.flush = true;
    }

    synchronized void disableFlush() {
        this.flush = false;
    }

    public synchronized void close() throws IOException {
        if (this.open) {
            this.closing = true;
            this.flush = true;
            this.flush();
            this.open = false;
        }
    }

    public synchronized void flush() throws IOException {
        if (this.open) {
            if (this.writeHeaders) {
                if (this.flush) {
                    this.writeHeaders = false;
                    this.out = this.realOut;
                    this.response.writeHeaders(this.closing ? this.buffer.size() : -1);
                    this.buffer.writeTo(this.out);
                    this.buffer = null;
                    this.out.flush();
                }
            } else {
                this.out.flush();
            }
        } else {
            throw new IOException("closed");
        }
    }

    public synchronized void write(byte[] bytes) throws IOException {
        if (!this.open) {
            throw new IOException("closed");
        }
        this.out.write(bytes, 0, bytes.length);
    }

    public synchronized void write(byte[] bytes, int off, int len) throws IOException {
        if (!this.open) {
            throw new IOException("closed");
        }
        this.out.write(bytes, off, len);
    }

    public synchronized void write(int b) throws IOException {
        if (!this.open) {
            throw new IOException("closed");
        }
        this.out.write(b);
    }
}

