/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import javax.servlet.ServletException;
import org.eclipse.equinox.http.Http;
import org.eclipse.equinox.http.HttpListener;
import org.eclipse.equinox.http.HttpMsg;
import org.eclipse.equinox.http.HttpThreadPool;
import org.eclipse.equinox.socket.SocketInterface;

public class HttpThread
extends Thread {
    protected Http http;
    protected volatile boolean running;
    protected HttpThreadPool pool;
    private SocketInterface socket;
    private HttpListener listener;
    private boolean supportKeepAlive;

    public HttpThread(Http http, HttpThreadPool pool, String name) {
        super((ThreadGroup)pool, name);
        this.http = http;
        this.pool = pool;
        this.setDaemon(true);
    }

    public boolean isClosed() {
        return !this.running;
    }

    public synchronized void close() {
        this.running = false;
        if (this.socket == null) {
            this.interrupt();
        } else {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized void recall() {
        if (this.socket != null && !this.socket.isActive()) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
        this.supportKeepAlive = false;
    }

    public synchronized void handleConnection(HttpListener listenerParam, SocketInterface socketParam, int socketTimeout) {
        if (this.running) {
            this.listener = listenerParam;
            this.socket = socketParam;
            if (socketTimeout > 0) {
                try {
                    socketParam.setSoTimeout(socketTimeout);
                    this.supportKeepAlive = true;
                }
                catch (SocketException socketException) {
                    this.supportKeepAlive = false;
                }
            } else {
                this.supportKeepAlive = false;
            }
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.running = true;
        while (true) {
            block23: {
                Object var3_7;
                if (!this.running) {
                    return;
                }
                if (this.socket == null) {
                    this.pool.putThread(this);
                    HttpThread httpThread = this;
                    synchronized (httpThread) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (!this.running || this.socket == null) continue;
                boolean keepAlive = false;
                try {
                    try {
                        this.socket.markInactive();
                        this.listener.handleConnection(this.socket);
                        keepAlive = this.supportKeepAlive && !this.socket.isClosed();
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        keepAlive = false;
                    }
                    catch (SocketException socketException) {
                        keepAlive = false;
                    }
                    catch (ServletException e) {
                        keepAlive = false;
                        this.http.logWarning(HttpMsg.HTTP_SERVLET_EXCEPTION, e);
                    }
                    catch (IOException e) {
                        keepAlive = false;
                        this.http.logWarning(HttpMsg.HTTP_CONNECTION_EXCEPTION, e);
                    }
                    catch (Throwable t) {
                        keepAlive = false;
                        this.http.logError(HttpMsg.HTTP_CONNECTION_EXCEPTION, t);
                    }
                }
                catch (Throwable throwable) {
                    var3_7 = null;
                    if (!keepAlive) {
                        if (!this.socket.isClosed()) {
                            try {
                                this.socket.close();
                            }
                            catch (IOException iOException) {}
                        }
                        this.socket = null;
                        this.listener = null;
                    }
                    throw throwable;
                }
                {
                    var3_7 = null;
                    if (keepAlive) continue;
                    if (this.socket.isClosed()) break block23;
                }
                try {}
                catch (IOException iOException) {}
                this.socket.close();
            }
            this.socket = null;
            this.listener = null;
        }
    }
}

