/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.DefaultHttpContext;
import org.eclipse.equinox.http.Http;
import org.eclipse.equinox.http.HttpConfiguration;
import org.eclipse.equinox.http.HttpMsg;
import org.eclipse.equinox.http.HttpService;
import org.eclipse.equinox.http.HttpThread;
import org.eclipse.equinox.http.Registration;
import org.eclipse.equinox.http.ResourceRegistration;
import org.eclipse.equinox.http.ResourceUnavailableException;
import org.eclipse.equinox.http.ServletRegistration;
import org.eclipse.equinox.http.servlet.HttpServletRequestImpl;
import org.eclipse.equinox.http.servlet.HttpServletResponseImpl;
import org.eclipse.equinox.http.servlet.ServletConfigImpl;
import org.eclipse.equinox.http.servlet.ServletContextImpl;
import org.eclipse.equinox.socket.ServerSocketInterface;
import org.eclipse.equinox.socket.SocketInterface;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;

public class HttpListener
extends Thread
implements ServiceFactory {
    protected Http http;
    protected volatile ServerSocketInterface serverSocket;
    protected HttpConfiguration configuration;
    protected volatile boolean running;
    protected ServiceRegistration service;
    private String httpsvcClass = "org.osgi.service.http.HttpService";
    protected Hashtable registrations;
    protected Hashtable servletContexts;
    protected int socketTimeout;
    protected Object lock = new Object();

    protected HttpListener(Http http, HttpConfiguration configuration, Dictionary properties) throws IOException {
        this.http = http;
        this.configuration = configuration;
        this.registrations = new Hashtable(51);
        this.servletContexts = new Hashtable(15);
        this.setProperties(properties);
        this.start();
    }

    public boolean isClosed() {
        return !this.running;
    }

    public void close() {
        this.running = false;
        try {
            this.setProperties(null);
        }
        catch (IOException iOException) {}
        this.servletContexts = null;
    }

    public Object getService(Bundle bundle, ServiceRegistration reg) {
        return new HttpService(this, bundle);
    }

    public void ungetService(Bundle bundle, ServiceRegistration reg, Object httpService) {
        ((HttpService)httpService).destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setProperties(Dictionary properties) throws IOException {
        ServerSocketInterface oldServerSocket = this.serverSocket;
        if (properties != null) {
            String address = (String)properties.get("http.address");
            int port = (Integer)properties.get("http.port");
            String scheme = (String)properties.get("http.scheme");
            this.socketTimeout = (Integer)properties.get("http.timeout") * 1000;
            if ("ALL".equalsIgnoreCase(address)) {
                address = null;
            }
            if (this.serverSocket == null || port != this.serverSocket.getLocalPort() || !scheme.equals(this.serverSocket.getScheme())) {
                this.serverSocket = this.configuration.createServerSocket(address, port, scheme);
                this.closeServerSocket(oldServerSocket);
            } else if (this.serverSocket.getAddress() != null && !this.serverSocket.getAddress().equals(address) || this.serverSocket.getAddress() == null && address != null) {
                this.serverSocket = null;
                this.closeServerSocket(oldServerSocket);
                this.serverSocket = this.configuration.createServerSocket(address, port, scheme);
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notify();
                }
            }
            if (this.service == null) {
                this.service = this.http.context.registerService(this.httpsvcClass, (Object)this, properties);
            } else {
                this.service.setProperties(properties);
            }
        } else {
            this.serverSocket = null;
            this.closeServerSocket(oldServerSocket);
            this.service.unregister();
            this.service = null;
        }
    }

    protected Object getProperty(String key) {
        return this.service.getReference().getProperty(key);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeServerSocket(ServerSocketInterface oldServerSocket) {
        block8: {
            if (oldServerSocket == null) return;
            try {
                try {
                    phonyClient = new Socket(InetAddress.getByName(oldServerSocket.getAddress()), oldServerSocket.getLocalPort());
                    phonyClient.close();
                }
                catch (IOException e) {
                    this.http.logWarning(HttpMsg.HTTP_UNEXPECTED_IOEXCEPTION, e);
                }
            }
            catch (Throwable var4_4) {
                var3_5 = null;
                try {
                    oldServerSocket.close();
                    throw var4_4;
                }
                catch (IOException e) {
                    this.http.logWarning(HttpMsg.HTTP_UNEXPECTED_IOEXCEPTION, e);
                }
                throw var4_4;
            }
            {
                var3_6 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 58->67)] { 
lbl21:
            // 1 sources

            oldServerSocket.close();
            break block8;
lbl23:
            // 1 sources

            catch (IOException e) {
                this.http.logWarning(HttpMsg.HTTP_UNEXPECTED_IOEXCEPTION, e);
            }
        }
        this.configuration.pool.recallThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running = true;
        while (this.running) {
            SocketInterface socket;
            block16: {
                socket = null;
                try {
                    if (this.serverSocket == null) {
                        if (!this.running) continue;
                        try {
                            Object object = this.lock;
                            synchronized (object) {
                                this.lock.wait(5000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {}
                        if (this.serverSocket == null) {
                            this.running = false;
                            continue;
                        }
                    }
                    ServerSocketInterface tempServerSocket = this.serverSocket;
                    socket = tempServerSocket.acceptSock();
                    if (tempServerSocket == this.serverSocket) break block16;
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                    socket = null;
                }
                catch (IOException e) {
                    if (this.serverSocket == null) break block16;
                    this.http.logError(NLS.bind((String)HttpMsg.HTTP_ACCEPT_SOCKET_EXCEPTION, (Object)new Integer(this.serverSocket.getLocalPort())), e);
                }
            }
            if (socket == null) continue;
            HttpThread thread = this.configuration.pool.getThread();
            if (thread != null) {
                thread.handleConnection(this, socket, this.socketTimeout);
                continue;
            }
            try {
                socket.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleConnection(SocketInterface socket) throws IOException, ServletException {
        HttpServletResponseImpl response = new HttpServletResponseImpl(socket, this.http);
        HttpServletRequestImpl request = new HttpServletRequestImpl(socket, this.http, response);
        try {
            String uri = request.getRequestURI();
            Registration registration = this.getRegistration(uri);
            while (registration != null) {
                block7: {
                    try {
                        if (!registration.getHttpContext().handleSecurity((HttpServletRequest)request, (HttpServletResponse)response)) break block7;
                        registration.service(request, response);
                    }
                    catch (ResourceUnavailableException resourceUnavailableException) {
                        uri = this.reduceURI(uri);
                        registration = uri == null ? null : this.getRegistration(uri);
                    }
                }
                Object var6_6 = null;
                response.close();
                return;
            }
            if (registration == null) {
                response.sendError(404);
            }
            Object var6_8 = null;
            response.close();
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            response.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceRegistration registerResources(Bundle bundle, String alias, String name, HttpContext httpContext) throws NamespaceException {
        Hashtable hashtable = this.registrations;
        synchronized (hashtable) {
            this.checkAlias(alias);
            int length = name.length();
            if (length > 1 && name.endsWith("/")) {
                throw new IllegalArgumentException(NLS.bind((String)HttpMsg.HTTP_RESOURCE_NAME_INVALID_EXCEPTION, (Object)name));
            }
            this.checkNamespace(alias);
            ResourceRegistration registration = new ResourceRegistration(bundle, alias, name, httpContext, this.http);
            this.registrations.put(alias, registration);
            return registration;
        }
    }

    private void checkAlias(String alias) {
        if (!(alias.equals("/") || alias.startsWith("/") && !alias.endsWith("/"))) {
            throw new IllegalArgumentException(NLS.bind((String)HttpMsg.HTTP_ALIAS_INVALID_EXCEPTION, (Object)alias));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServletRegistration registerServlet(Bundle bundle, String alias, Servlet servlet, Dictionary initparams, HttpContext httpContext) throws ServletException, NamespaceException {
        Hashtable hashtable = this.registrations;
        synchronized (hashtable) {
            this.checkAlias(alias);
            this.checkNamespace(alias);
            if (servlet == null) {
                throw new NullPointerException(HttpMsg.HTTP_SERVLET_NULL_EXCEPTION);
            }
            if (this.http.servlets.contains(servlet)) {
                throw new ServletException(HttpMsg.HTTP_SERVLET_ALREADY_REGISTERED_EXCEPTION);
            }
            ServletContextImpl servletContext = this.getServletContext(httpContext);
            ServletRegistration registration = new ServletRegistration(bundle, alias, servlet, httpContext, servletContext);
            try {
                servlet.init((ServletConfig)new ServletConfigImpl(servletContext, initparams));
            }
            catch (ServletException e) {
                this.ungetServletContext(httpContext);
                throw e;
            }
            catch (Throwable t) {
                this.ungetServletContext(httpContext);
                throw new ServletException(HttpMsg.HTTP_SERVET_INIT_EXCEPTION, t);
            }
            this.http.servlets.addElement(servlet);
            this.registrations.put(alias, registration);
            return registration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregister(Bundle bundle, String alias) throws IllegalArgumentException {
        Hashtable hashtable = this.registrations;
        synchronized (hashtable) {
            Registration registration = (Registration)this.registrations.get(alias);
            if (registration != null && registration.getBundle() != bundle) {
                registration = null;
            }
            this.removeRegistration(registration);
        }
    }

    protected HttpContext createDefaultHttpContext(Bundle bundle) {
        return new DefaultHttpContext(bundle, this.http.securityTracker);
    }

    protected ServletContextImpl getServletContext(HttpContext httpContext) {
        ServletContextImpl servletContext = (ServletContextImpl)this.servletContexts.get(httpContext);
        if (servletContext == null) {
            servletContext = new ServletContextImpl(this.http, this, httpContext);
            this.servletContexts.put(httpContext, servletContext);
        }
        servletContext.incrUseCount();
        return servletContext;
    }

    protected void ungetServletContext(HttpContext httpContext) {
        int useCount;
        ServletContextImpl servletContext = (ServletContextImpl)this.servletContexts.get(httpContext);
        if (servletContext != null && (useCount = servletContext.decrUseCount()) <= 0) {
            this.servletContexts.remove(httpContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyBundle(Bundle bundle) {
        if (this.registrations != null) {
            Hashtable hashtable = this.registrations;
            synchronized (hashtable) {
                Enumeration e = this.registrations.elements();
                while (e.hasMoreElements()) {
                    Registration reg = (Registration)e.nextElement();
                    if (bundle != reg.getBundle()) continue;
                    this.removeRegistration(reg);
                }
            }
        }
    }

    private void checkNamespace(String uri) throws NamespaceException {
        if (this.registrations.get(uri) != null) {
            throw new NamespaceException(NLS.bind((String)HttpMsg.HTTP_ALIAS_ALREADY_REGISTERED_EXCEPTION, (Object)uri));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registration getRegistration(String uri) {
        Hashtable hashtable = this.registrations;
        synchronized (hashtable) {
            while (uri != null) {
                Registration reg = (Registration)this.registrations.get(uri);
                if (reg != null) {
                    return reg;
                }
                uri = this.reduceURI(uri);
            }
            return null;
        }
    }

    private String reduceURI(String uri) {
        if (uri.equals("/")) {
            return null;
        }
        int index = uri.lastIndexOf(47);
        if (index < 0) {
            return null;
        }
        if (index == 0) {
            return "/";
        }
        return uri.substring(0, index);
    }

    private void removeRegistration(Registration registration) {
        if (registration == null) {
            throw new IllegalArgumentException(HttpMsg.HTTP_ALIAS_UNREGISTER_EXCEPTION);
        }
        this.registrations.remove(registration.getAlias());
        if (registration instanceof ServletRegistration) {
            Servlet servlet = ((ServletRegistration)registration).getServlet();
            this.http.servlets.removeElement(servlet);
        }
        registration.destroy();
        if (registration instanceof ServletRegistration) {
            this.ungetServletContext(registration.getHttpContext());
        }
    }
}

