/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.equinox.http.HttpConfiguration;
import org.eclipse.equinox.http.HttpMsg;
import org.eclipse.equinox.http.HttpSecurityTracker;
import org.eclipse.equinox.http.LogTracker;
import org.eclipse.equinox.http.StaticDataReader;
import org.eclipse.equinox.http.servlet.HttpSessionImpl;
import org.eclipse.equinox.socket.ServerSocketInterface;
import org.eclipse.equinox.socket.https.HttpsServerSocket;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class Http {
    public static final boolean DEBUG = false;
    BundleContext context;
    private LogTracker log = null;
    protected HttpConfiguration configuration;
    protected Hashtable sessions;
    protected Vector servlets;
    protected StaticDataReader dataReader;
    HttpSecurityTracker securityTracker;

    protected Http(BundleContext context) throws Exception {
        this.context = context;
        this.initialize();
    }

    protected void initialize() throws Exception {
        this.log = new LogTracker(this.context, System.out);
        this.securityTracker = new HttpSecurityTracker(this.context);
        this.servlets = new Vector(15);
        this.sessions = new Hashtable(15);
        this.dataReader = new StaticDataReader(this);
    }

    protected void start() throws Exception {
        try {
            this.configuration = new HttpConfiguration(this);
        }
        catch (IOException e) {
            this.logError("Http Service failed to start -- HALTING", e);
            this.stop();
            throw e;
        }
    }

    protected void stop() {
        if (this.configuration != null) {
            this.configuration.close();
            this.configuration = null;
        }
    }

    protected void close() {
        if (this.securityTracker != null) {
            this.securityTracker.close();
            this.securityTracker = null;
        }
        if (this.log != null) {
            this.log.close();
            this.log = null;
        }
    }

    public void addSession(HttpSessionImpl session) {
        this.sessions.put(session.getId(), session);
    }

    public void removeSession(HttpSessionImpl session) {
        this.sessions.remove(session.getId());
    }

    public HttpSessionImpl getSession(String id) {
        HttpSessionImpl session = (HttpSessionImpl)this.sessions.get(id);
        if (session != null && session.isValid(true)) {
            return session;
        }
        return null;
    }

    public String getMimeType(String name) {
        return this.dataReader.computeMimeType(name);
    }

    public String getStatusPhrase(int statusCode) {
        return this.dataReader.computeStatusPhrase(statusCode);
    }

    public void logDebug(String message) {
    }

    public void logDebug(String message, Throwable t) {
    }

    public void logError(String message, Throwable t) {
        this.log.log(1, message, t);
    }

    public void logInfo(String message) {
        this.log.log(3, message);
    }

    public void logWarning(String message, Throwable t) {
        this.log.log(2, message, t);
    }

    protected ServerSocketInterface createSSLServerSocket(int port, int backlog, InetAddress address) throws IOException {
        HttpsServerSocket socket;
        try {
            socket = new HttpsServerSocket(this.context, port, backlog, address);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new IOException(NLS.bind((String)HttpMsg.HTTP_INVALID_SCHEME_EXCEPTION, (Object)"https"));
        }
        return socket;
    }
}

