/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.serializer;

import java.lang.reflect.Array;
import javax.xml.namespace.QName;
import org.apache.muse.core.serializer.Serializer;
import org.apache.muse.util.ReflectUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ArraySerializer
implements Serializer {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$core$serializer$ArraySerializer == null ? (class$org$apache$muse$core$serializer$ArraySerializer = ArraySerializer.class$("org.apache.muse.core.serializer.ArraySerializer")) : class$org$apache$muse$core$serializer$ArraySerializer));
    private Class _arrayClass = null;
    private Serializer _classSerializer = null;
    static /* synthetic */ Class class$org$apache$muse$core$serializer$ArraySerializer;

    public ArraySerializer(Class arrayClass, Serializer classSerializer) {
        if (arrayClass == null) {
            throw new NullPointerException(_MESSAGES.get("NullArrayClass"));
        }
        if (classSerializer == null) {
            throw new NullPointerException(_MESSAGES.get("NullSerializer"));
        }
        if (!arrayClass.isArray()) {
            Object[] filler = new Object[]{arrayClass.getName()};
            throw new RuntimeException(_MESSAGES.get("NotArrayClass", filler));
        }
        this._arrayClass = arrayClass;
        this._classSerializer = classSerializer;
    }

    public Object fromXML(Element xml) throws SoapFault {
        Element[] children = XmlUtils.getAllElements((Node)xml);
        Class type = ReflectUtils.getClassFromArrayClass((Class)this.getArrayClass());
        Object array = Array.newInstance(type, children.length);
        Serializer serializer = this.getClassSerializer();
        for (int n = 0; n < children.length; ++n) {
            Object result = serializer.fromXML(children[n]);
            Array.set(array, n, result);
        }
        return array;
    }

    public Class getArrayClass() {
        return this._arrayClass;
    }

    public Serializer getClassSerializer() {
        return this._classSerializer;
    }

    public Class getSerializableType() {
        return this.getArrayClass();
    }

    public Element toXML(Object obj, QName qname) throws SoapFault {
        Serializer serializer = this.getClassSerializer();
        Element root = XmlUtils.createElement((QName)qname);
        int length = Array.getLength(obj);
        for (int n = 0; n < length; ++n) {
            Object item = Array.get(obj, n);
            Element child = serializer.toXML(item, qname);
            root.appendChild(child);
        }
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

