/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.descriptor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.muse.core.descriptor.DescriptorConstants;
import org.apache.muse.core.descriptor.InitParamDescriptor;
import org.apache.muse.util.xml.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleInitParamDescriptor
implements InitParamDescriptor {
    private Map _parameters = null;

    protected Map createInitializationParameters(Element xml) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Element[] paramXML = XmlUtils.getElements((Node)xml, (QName)DescriptorConstants.INIT_PARAM_QNAME);
        for (int n = 0; n < paramXML.length; ++n) {
            String name = XmlUtils.getElementText((Node)paramXML[n], (QName)DescriptorConstants.PARAM_NAME_QNAME);
            String value = XmlUtils.getElementText((Node)paramXML[n], (QName)DescriptorConstants.PARAM_VALUE_QNAME);
            parameters.put(name, value);
        }
        return parameters;
    }

    public Map getInitializationParameters() {
        return this._parameters;
    }

    public void load(Element elementContainingInitParams) {
        this._parameters = this.createInitializationParameters(elementContainingInitParams);
    }

    public void setInitializationParameters(Map parameters) {
        this._parameters = parameters;
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        Element root = XmlUtils.createElement((Document)doc, (QName)DescriptorConstants.INIT_PARAM_QNAME);
        Map parameters = this.getInitializationParameters();
        Iterator i = parameters.keySet().iterator();
        while (i.hasNext()) {
            Object name = i.next();
            Object value = parameters.get(name);
            Element param = XmlUtils.createElement((Document)doc, (QName)DescriptorConstants.INIT_PARAM_QNAME);
            XmlUtils.setElement((Element)param, (QName)DescriptorConstants.PARAM_NAME_QNAME, name);
            XmlUtils.setElement((Element)param, (QName)DescriptorConstants.PARAM_VALUE_QNAME, value);
            root.appendChild(param);
        }
        return root;
    }
}

