/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.namespace;

public class QName {
    private String _localPart = null;
    private String _namespaceURI = null;
    private String _prefix = null;

    public static QName valueOf(String qnameFromToString) {
        String namespaceURI = null;
        String localPart = null;
        int startLocalPart = 0;
        if (qnameFromToString.charAt(0) == '{') {
            int closeBracket = qnameFromToString.indexOf(125);
            if (closeBracket < 0) {
                throw new IllegalArgumentException("Invalid QName string: namespace has no closing bracket.");
            }
            if (closeBracket == qnameFromToString.length() - 1) {
                throw new IllegalArgumentException("Invalid QName string: no local part after namespace.");
            }
            namespaceURI = qnameFromToString.substring(1, closeBracket);
            startLocalPart = closeBracket + 1;
        }
        localPart = qnameFromToString.substring(startLocalPart);
        return new QName(namespaceURI, localPart, null);
    }

    public QName(String localPart) {
        this("", localPart, "");
    }

    public QName(String namespaceURI, String localPart) {
        this(namespaceURI, localPart, "");
    }

    public QName(String namespaceURI, String localPart, String prefix) {
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        if (localPart == null || localPart.length() == 0) {
            throw new IllegalArgumentException("Invalid QName: null or empty local part.");
        }
        this._namespaceURI = namespaceURI;
        this._localPart = localPart;
        this._prefix = prefix;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        QName other = (QName)obj;
        return this.getNamespaceURI().equals(other.getNamespaceURI()) && this.getLocalPart().equals(other.getLocalPart());
    }

    public String getLocalPart() {
        return this._localPart;
    }

    public String getNamespaceURI() {
        return this._namespaceURI;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public int hashCode() {
        return this.getNamespaceURI().hashCode() + this.getLocalPart().hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String namespaceURI = this.getNamespaceURI();
        if (namespaceURI != null) {
            buffer.append('{');
            buffer.append(namespaceURI);
            buffer.append('}');
        }
        buffer.append(this.getLocalPart());
        return buffer.toString();
    }
}

