/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSUtils {
    private static final Log log = LogFactory.getLog((Class)JMSUtils.class);

    public static boolean isJMSService(AxisService service) {
        boolean process = service.isEnableAllTransports();
        if (process) {
            return true;
        }
        List transports = service.getExposedTransports();
        for (int i = 0; i < transports.size(); ++i) {
            if (!"jms".equals(transports.get(i))) continue;
            return true;
        }
        return false;
    }

    public static String getDestination(AxisService service) {
        Parameter destParam = service.getParameter("transport.jms.Destination");
        String destination = null;
        destination = destParam != null ? (String)destParam.getValue() : service.getName();
        return destination;
    }

    public static Hashtable getProperties(String url) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        int propPos = url.indexOf("?");
        if (propPos != -1) {
            StringTokenizer st = new StringTokenizer(url.substring(propPos + 1), "&");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int sep = token.indexOf("=");
                if (sep == -1) continue;
                h.put(token.substring(0, sep), token.substring(sep + 1));
            }
        }
        return h;
    }

    public static void markServiceAsFaulty(String serviceName, String msg, AxisConfiguration axisCfg) {
        if (serviceName != null) {
            try {
                AxisService service = axisCfg.getService(serviceName);
                axisCfg.getFaultyServices().put(service.getName(), msg);
            }
            catch (AxisFault axisFault) {
                log.warn((Object)("Error marking service : " + serviceName + " as faulty due to : " + msg), (Throwable)axisFault);
            }
        }
    }

    public static InputStream getInputStream(Message message) {
        try {
            if (message instanceof BytesMessage) {
                byte[] buffer = new byte[8192];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                BytesMessage byteMsg = (BytesMessage)message;
                int bytesRead = byteMsg.readBytes(buffer);
                while (bytesRead != -1) {
                    out.write(buffer, 0, bytesRead);
                    bytesRead = byteMsg.readBytes(buffer);
                }
                return new ByteArrayInputStream(out.toByteArray());
            }
            if (message instanceof TextMessage) {
                TextMessage txtMsg = (TextMessage)message;
                String contentType = message.getStringProperty("contentType");
                if (contentType != null) {
                    return new ByteArrayInputStream(txtMsg.getText().getBytes(TransportUtils.getCharSetEncoding(contentType)));
                }
                return new ByteArrayInputStream(txtMsg.getText().getBytes());
            }
            JMSUtils.handleException("Unsupported JMS message type : " + message.getClass().getName());
        }
        catch (JMSException e) {
            JMSUtils.handleException("JMS Exception getting InputStream into message", (Exception)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            JMSUtils.handleException("Encoding exception getting InputStream into message", e);
        }
        return null;
    }

    public static String getProperty(Message message, String property) {
        try {
            return message.getStringProperty(property);
        }
        catch (JMSException e) {
            return null;
        }
    }

    public static String getContentType(MessageContext msgCtx) {
        OMOutputFormat format = new OMOutputFormat();
        String soapActionString = JMSUtils.getSOAPAction(msgCtx);
        String charSetEnc = (String)msgCtx.getProperty("CHARACTER_SET_ENCODING");
        if (charSetEnc != null) {
            format.setCharSetEncoding(charSetEnc);
        } else {
            OperationContext opctx = msgCtx.getOperationContext();
            if (opctx != null) {
                charSetEnc = (String)opctx.getProperty("CHARACTER_SET_ENCODING");
            }
        }
        if (charSetEnc == null) {
            charSetEnc = "UTF-8";
        }
        format.setSOAP11(msgCtx.isSOAP11());
        format.setCharSetEncoding(charSetEnc);
        String encoding = format.getCharSetEncoding();
        String contentType = format.getContentType();
        if (encoding != null) {
            contentType = contentType + "; charset=" + encoding;
        }
        if (!msgCtx.isSOAP11() && soapActionString != null && !"".equals(soapActionString.trim())) {
            contentType = contentType + ";action=\"" + soapActionString + "\";";
        }
        return contentType;
    }

    private static String getSOAPAction(MessageContext msgCtx) {
        String soapActionString = msgCtx.getSoapAction();
        if (soapActionString == null || soapActionString.trim().length() == 0) {
            soapActionString = msgCtx.getWSAAction();
        }
        Object disableSoapAction = msgCtx.getOptions().getProperty("disableSoapAction");
        if (soapActionString == null || JavaUtils.isTrueExplicitly(disableSoapAction)) {
            soapActionString = "";
        }
        return soapActionString;
    }

    public static String getDestination(String url) {
        String tempUrl = url.substring("jms:/".length());
        int propPos = tempUrl.indexOf("?");
        if (propPos == -1) {
            return tempUrl;
        }
        return tempUrl.substring(0, propPos);
    }

    public static SOAPEnvelope getSOAPEnvelope(Message message, MessageContext msgContext, InputStream in) throws XMLStreamException {
        XMLStreamReader xmlreader;
        SOAPEnvelope envelope = null;
        StAXBuilder builder = null;
        String contentType = JMSUtils.getProperty(message, "contentType");
        if (contentType != null) {
            if (contentType.indexOf("multipart/related") > -1) {
                builder = TransportUtils.selectBuilderForMIME(msgContext, in, contentType, true);
                envelope = (SOAPEnvelope)builder.getDocumentElement();
            } else {
                if (TransportUtils.getCharSetEncoding(contentType) == null) {
                    xmlreader = StAXUtils.createXMLStreamReader((InputStream)in, (String)"UTF-8");
                    msgContext.setProperty("CHARACTER_SET_ENCODING", "UTF-8");
                } else {
                    String charSetEnc = TransportUtils.getCharSetEncoding(contentType);
                    xmlreader = StAXUtils.createXMLStreamReader((InputStream)in, (String)charSetEnc);
                    msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
                }
                if (contentType.indexOf("application/soap+xml") > -1) {
                    builder = new StAXSOAPModelBuilder(xmlreader, "http://www.w3.org/2003/05/soap-envelope");
                    envelope = (SOAPEnvelope)builder.getDocumentElement();
                } else if (contentType.indexOf("text/xml") > -1) {
                    builder = new StAXSOAPModelBuilder(xmlreader, "http://schemas.xmlsoap.org/soap/envelope/");
                    envelope = (SOAPEnvelope)builder.getDocumentElement();
                }
            }
        }
        if (builder == null) {
            xmlreader = StAXUtils.createXMLStreamReader((InputStream)in, (String)"UTF-8");
            msgContext.setProperty("CHARACTER_SET_ENCODING", "UTF-8");
            builder = new StAXSOAPModelBuilder(xmlreader, "http://schemas.xmlsoap.org/soap/envelope/");
            envelope = (SOAPEnvelope)builder.getDocumentElement();
        }
        String charEncOfMessage = builder.getDocument().getCharsetEncoding();
        String charEncOfTransport = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
        if (charEncOfMessage != null && charEncOfMessage.trim().length() != 0 && !charEncOfMessage.equalsIgnoreCase(charEncOfTransport)) {
            if (envelope.getNamespace() != null && "http://www.w3.org/2003/05/soap-envelope".equals(envelope.getNamespace().getNamespaceURI())) {
                String faultCode = "Sender";
            } else {
                String faultCode = "Client";
            }
            JMSUtils.handleException("Character Set Encoding from transport information do not match with character set encoding in the received SOAP message");
        }
        return envelope;
    }

    private static void handleException(String s) {
        log.error((Object)s);
        throw new AxisJMSException(s);
    }

    private static void handleException(String s, Exception e) {
        log.error((Object)s, (Throwable)e);
        throw new AxisJMSException(s, e);
    }
}

