/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSMessageReceiver;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSConnectionFactory {
    private static final Log log = LogFactory.getLog((Class)JMSConnectionFactory.class);
    private String name = null;
    private String jndiName = null;
    private Map destinations = null;
    private Map jmsSessions = null;
    private Hashtable properties = null;
    private Context context = null;
    private ConnectionFactory conFactory = null;
    private Connection connection = null;
    private JMSMessageReceiver msgRcvr = null;

    JMSConnectionFactory(String name, String jndiName) {
        this.name = name;
        this.jndiName = jndiName;
        this.destinations = new HashMap();
        this.properties = new Hashtable();
        this.jmsSessions = new HashMap();
    }

    JMSConnectionFactory(String name) {
        this(name, null);
    }

    public void connect() throws NamingException {
        if (this.context == null) {
            this.createInitialContext();
        }
        this.conFactory = (ConnectionFactory)this.context.lookup(this.jndiName);
        log.debug((Object)("Connected to the actual connection factory : " + this.jndiName));
    }

    private void createInitialContext() throws NamingException {
        this.context = new InitialContext(this.properties);
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void addDestination(String destinationJndi, String serviceName) {
        this.destinations.put(destinationJndi, serviceName);
    }

    public void removeDestination(String destinationJndi) throws JMSException {
        this.stoplistenOnDestination(destinationJndi);
        this.destinations.remove(destinationJndi);
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getName() {
        return this.name;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public ConnectionFactory getConFactory() {
        return this.conFactory;
    }

    public Map getDestinations() {
        return this.destinations;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public void listen(JMSMessageReceiver msgRcvr) throws JMSException {
        this.msgRcvr = msgRcvr;
        log.debug((Object)("Connection factory : " + this.name + " initializing..."));
        if (this.conFactory == null || this.context == null) {
            this.handleException("Connection factory must be 'connected' before listening");
        } else {
            try {
                this.connection = this.conFactory.createConnection();
            }
            catch (JMSException e) {
                this.handleException("Error creating a JMS connection using the factory : " + this.jndiName, (Exception)((Object)e));
            }
        }
        Iterator iter = this.destinations.keySet().iterator();
        while (iter.hasNext()) {
            String destinationJndi = (String)iter.next();
            this.listenOnDestination(destinationJndi);
        }
        this.connection.start();
        log.info((Object)("Connection factory : " + this.name + " initialized..."));
    }

    public void listenOnDestination(String destinationJndi) throws JMSException {
        Session session = this.connection.createSession(false, 1);
        Destination destination = null;
        try {
            Object o = this.context.lookup(destinationJndi);
            destination = (Destination)o;
        }
        catch (NameNotFoundException e) {
            log.warn((Object)("Cannot find destination : " + destinationJndi + " Creating a Queue with this name"));
            destination = session.createQueue(destinationJndi);
        }
        catch (NamingException e) {
            log.warn((Object)("Error looking up destination : " + destinationJndi), (Throwable)e);
            JMSUtils.markServiceAsFaulty((String)this.destinations.get(destinationJndi), "Error looking up JMS destination : " + destinationJndi, this.msgRcvr.getAxisConf().getAxisConfiguration());
        }
        MessageConsumer consumer = session.createConsumer(destination);
        consumer.setMessageListener((MessageListener)this.msgRcvr);
        this.jmsSessions.put(destinationJndi, session);
    }

    private void stoplistenOnDestination(String destinationJndi) throws JMSException {
        ((Session)this.jmsSessions.get(destinationJndi)).close();
    }

    public String getServiceNameForDestination(String destination) {
        return (String)this.destinations.get(destination);
    }

    public void stop() {
        try {
            this.connection.close();
        }
        catch (JMSException e) {
            log.warn((Object)("Error shutting down connection factory : " + this.name), (Throwable)e);
        }
    }

    private void handleException(String msg) throws AxisJMSException {
        log.error((Object)msg);
        throw new AxisJMSException(msg);
    }

    private void handleException(String msg, Exception e) throws AxisJMSException {
        log.error((Object)msg, (Throwable)e);
        throw new AxisJMSException(msg, e);
    }
}

