/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.receivers;

import java.lang.reflect.Method;
import java.net.URL;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.DependencyManager;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.MultiParentClassLoader;

public abstract class AbstractMessageReceiver
implements MessageReceiver {
    public static final String SCOPE = "scope";
    protected String serviceTCCL = null;
    public static final String SAVED_TCCL = "_SAVED_TCCL_";
    public static final String SAVED_MC = "_SAVED_MC_";

    protected ThreadContextDescriptor setThreadContext(MessageContext msgContext) {
        ClassLoader contextClassLoader;
        ThreadContextDescriptor tc = new ThreadContextDescriptor();
        tc.oldMessageContext = (MessageContext)MessageContext.currentMessageContext.get();
        tc.oldClassLoader = contextClassLoader = Thread.currentThread().getContextClassLoader();
        AxisService service = msgContext.getAxisService();
        String serviceTCCL = (String)service.getParameterValue("ServiceTCCL");
        if (serviceTCCL != null) {
            if ((serviceTCCL = serviceTCCL.trim().toLowerCase()).equals("composite")) {
                Thread.currentThread().setContextClassLoader(new MultiParentClassLoader(new URL[0], new ClassLoader[]{msgContext.getAxisService().getClassLoader(), contextClassLoader}));
            } else if (serviceTCCL.equals("service")) {
                Thread.currentThread().setContextClassLoader(msgContext.getAxisService().getClassLoader());
            }
        }
        MessageContext.setCurrentMessageContext(msgContext);
        return tc;
    }

    protected void restoreThreadContext(ThreadContextDescriptor tc) {
        Thread.currentThread().setContextClassLoader(tc.oldClassLoader);
        MessageContext.currentMessageContext.set(tc.oldMessageContext);
    }

    protected Object makeNewServiceObject(MessageContext msgContext) throws AxisFault {
        try {
            Parameter implInfoParam;
            AxisService service = msgContext.getAxisService();
            ClassLoader classLoader = service.getClassLoader();
            if (service.getParameter("ServiceObjectSupplier") != null) {
                Parameter serviceObjectParam = service.getParameter("ServiceObjectSupplier");
                Class serviceObjectMaker = Loader.loadClass(classLoader, ((String)serviceObjectParam.getValue()).trim());
                Method method = serviceObjectMaker.getMethod("getServiceObject", AxisService.class);
                if (method != null) {
                    return method.invoke(serviceObjectMaker.newInstance(), service);
                }
            }
            if ((implInfoParam = service.getParameter("ServiceClass")) != null) {
                Class implClass = Loader.loadClass(classLoader, ((String)implInfoParam.getValue()).trim());
                return implClass.newInstance();
            }
            throw new AxisFault(Messages.getMessage("paramIsNotSpecified", "SERVICE_OBJECT_SUPPLIER"));
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
    }

    public SOAPFactory getSOAPFactory(MessageContext msgContext) throws AxisFault {
        String nsURI = msgContext.getEnvelope().getNamespace().getNamespaceURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(nsURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(nsURI)) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        throw new AxisFault(Messages.getMessage("invalidSOAPversion"));
    }

    protected Object getTheImplementationObject(MessageContext msgContext) throws AxisFault {
        ServiceContext serviceContext = msgContext.getServiceContext();
        Object serviceimpl = serviceContext.getProperty("serviceObject");
        if (serviceimpl != null) {
            return serviceimpl;
        }
        serviceimpl = this.makeNewServiceObject(msgContext);
        DependencyManager.initServiceClass(serviceimpl, msgContext.getServiceContext());
        serviceContext.setProperty("serviceObject", serviceimpl);
        return serviceimpl;
    }

    public class ThreadContextDescriptor {
        public ClassLoader oldClassLoader;
        public MessageContext oldMessageContext;
    }
}

