/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.phaseresolver;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.phaseresolver.PhaseException;
import org.apache.axis2.phaseresolver.PhaseHolder;

public class PhaseResolver {
    private static final int IN_FLOW = 1;
    private static final int OUT_FAULT_FLOW = 5;
    private AxisConfiguration axisConfig;
    private PhaseHolder phaseHolder;

    public PhaseResolver(AxisConfiguration axisconfig) {
        this.axisConfig = axisconfig;
    }

    public void engageModuleToOperation(AxisOperation axisOperation, AxisModule module) throws PhaseException {
        Flow flow = null;
        for (int type = 1; type < 5; ++type) {
            switch (type) {
                case 1: {
                    Object o2;
                    Iterator itr_axis_config;
                    ArrayList phases = new ArrayList();
                    if (this.axisConfig != null) {
                        itr_axis_config = this.axisConfig.getGlobalInFlow().iterator();
                        while (itr_axis_config.hasNext()) {
                            o2 = itr_axis_config.next();
                            phases.add(o2);
                        }
                    }
                    Iterator itr_ops = axisOperation.getRemainingPhasesInFlow().iterator();
                    while (itr_ops.hasNext()) {
                        o2 = itr_ops.next();
                        phases.add(o2);
                    }
                    this.phaseHolder = new PhaseHolder(phases);
                    break;
                }
                case 2: {
                    Object o;
                    Iterator itr_axis_config;
                    Object o2;
                    ArrayList phases = new ArrayList();
                    Iterator itr_ops = axisOperation.getPhasesOutFlow().iterator();
                    while (itr_ops.hasNext()) {
                        o2 = itr_ops.next();
                        phases.add(o2);
                    }
                    if (this.axisConfig != null) {
                        itr_axis_config = this.axisConfig.getGlobalOutPhases().iterator();
                        while (itr_axis_config.hasNext()) {
                            o = itr_axis_config.next();
                            phases.add(o);
                        }
                    }
                    this.phaseHolder = new PhaseHolder(phases);
                    break;
                }
                case 3: {
                    Object o2;
                    Iterator itr_axis_config;
                    ArrayList phases = new ArrayList();
                    if (this.axisConfig != null) {
                        itr_axis_config = this.axisConfig.getInFaultFlow().iterator();
                        while (itr_axis_config.hasNext()) {
                            o2 = itr_axis_config.next();
                            phases.add(o2);
                        }
                    }
                    Iterator itr_ops = axisOperation.getPhasesInFaultFlow().iterator();
                    while (itr_ops.hasNext()) {
                        o2 = itr_ops.next();
                        phases.add(o2);
                    }
                    this.phaseHolder = new PhaseHolder(phases);
                    break;
                }
                case 4: {
                    Object o;
                    Iterator itr_axis_config;
                    Object o2;
                    ArrayList phases = new ArrayList();
                    Iterator itr_ops = axisOperation.getPhasesOutFaultFlow().iterator();
                    while (itr_ops.hasNext()) {
                        o2 = itr_ops.next();
                        phases.add(o2);
                    }
                    if (this.axisConfig != null) {
                        itr_axis_config = this.axisConfig.getOutFaultFlow().iterator();
                        while (itr_axis_config.hasNext()) {
                            o = itr_axis_config.next();
                            phases.add(o);
                        }
                    }
                    this.phaseHolder = new PhaseHolder(phases);
                    break;
                }
            }
            switch (type) {
                case 1: {
                    flow = module.getInFlow();
                    break;
                }
                case 2: {
                    flow = module.getOutFlow();
                    break;
                }
                case 3: {
                    flow = module.getFaultInFlow();
                    break;
                }
                case 4: {
                    flow = module.getFaultOutFlow();
                }
            }
            if (flow == null) continue;
            for (int j = 0; j < flow.getHandlerCount(); ++j) {
                HandlerDescription metadata = flow.getHandler(j);
                this.phaseHolder.addHandler(metadata);
            }
        }
    }

    public void disengageModuleFromGlobalChains(AxisModule module) {
        HandlerDescription handler;
        int j;
        Flow flow = module.getInFlow();
        if (flow != null) {
            for (j = 0; j < flow.getHandlerCount(); ++j) {
                handler = flow.getHandler(j);
                this.removeHandlerfromaPhase(handler, this.axisConfig.getGlobalInFlow());
            }
        }
        if ((flow = module.getOutFlow()) != null) {
            for (j = 0; j < flow.getHandlerCount(); ++j) {
                handler = flow.getHandler(j);
                this.removeHandlerfromaPhase(handler, this.axisConfig.getGlobalOutPhases());
            }
        }
        if ((flow = module.getFaultInFlow()) != null) {
            for (j = 0; j < flow.getHandlerCount(); ++j) {
                handler = flow.getHandler(j);
                this.removeHandlerfromaPhase(handler, this.axisConfig.getInFaultFlow());
            }
        }
        if ((flow = module.getFaultOutFlow()) != null) {
            for (j = 0; j < flow.getHandlerCount(); ++j) {
                handler = flow.getHandler(j);
                this.removeHandlerfromaPhase(handler, this.axisConfig.getOutFaultFlow());
            }
        }
    }

    public void disengageModuleFromOperationChain(AxisModule module, AxisOperation operation) {
        HandlerDescription handler;
        int j;
        Flow flow = module.getInFlow();
        if (flow != null) {
            for (j = 0; j < flow.getHandlerCount(); ++j) {
                handler = flow.getHandler(j);
                this.removeHandlerfromaPhase(handler, operation.getRemainingPhasesInFlow());
            }
        }
        if ((flow = module.getOutFlow()) != null) {
            for (j = 0; j < flow.getHandlerCount(); ++j) {
                handler = flow.getHandler(j);
                this.removeHandlerfromaPhase(handler, operation.getPhasesOutFlow());
            }
        }
        if ((flow = module.getFaultInFlow()) != null) {
            for (j = 0; j < flow.getHandlerCount(); ++j) {
                handler = flow.getHandler(j);
                this.removeHandlerfromaPhase(handler, operation.getPhasesInFaultFlow());
            }
        }
        if ((flow = module.getFaultOutFlow()) != null) {
            for (j = 0; j < flow.getHandlerCount(); ++j) {
                handler = flow.getHandler(j);
                this.removeHandlerfromaPhase(handler, operation.getPhasesOutFaultFlow());
            }
        }
    }

    private void removeHandlerfromaPhase(HandlerDescription handler, ArrayList phaseList) {
        String phaseName = handler.getRules().getPhaseName();
        Iterator phaseItr = phaseList.iterator();
        while (phaseItr.hasNext()) {
            Phase phase = (Phase)phaseItr.next();
            if (!phase.getPhaseName().equals(phaseName)) continue;
            phase.removeHandler(handler);
            break;
        }
    }
}

