/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.ClientUtils;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.UUIDGenerator;

class OutOnlyAxisOperationClient
implements OperationClient {
    OutOnlyAxisOperation axisOp;
    ServiceContext sc;
    Options options;
    MessageContext mc;
    OperationContext oc;
    boolean completed;

    OutOnlyAxisOperationClient(OutOnlyAxisOperation axisOp, ServiceContext sc, Options options) {
        this.axisOp = axisOp;
        this.sc = sc;
        this.options = options;
        this.completed = false;
        this.oc = new OperationContext(axisOp, sc);
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public Options getOptions() {
        return this.options;
    }

    public void addMessageContext(MessageContext mc) throws AxisFault {
        if (this.mc != null) {
            throw new AxisFault(Messages.getMessage("cannotaddmsgctx"));
        }
        this.mc = mc;
        if (mc.getMessageID() == null) {
            this.setMessageID(mc);
        }
        mc.setServiceContext(this.sc);
        this.axisOp.registerOperationContext(mc, this.oc);
        this.completed = false;
    }

    public MessageContext getMessageContext(String messageLabel) throws AxisFault {
        if (messageLabel.equals("Out")) {
            return this.mc;
        }
        throw new AxisFault(Messages.getMessage("unknownMsgLabel", messageLabel));
    }

    public void setCallback(Callback callback) {
        throw new UnsupportedOperationException("This feature is not supported by this MEP");
    }

    private void setMessageID(MessageContext mc) {
        String messageId = this.options.getMessageId();
        if (messageId == null || "".equals(messageId)) {
            messageId = UUIDGenerator.getUUID();
        }
        mc.setMessageID(messageId);
    }

    private void addReferenceParameters(MessageContext msgctx) {
        EndpointReference tepr;
        EndpointReference to = msgctx.getTo();
        if (this.options.isManageSession() && (tepr = this.sc.getTargetEPR()) != null) {
            Map map = tepr.getAllReferenceParameters();
            Iterator valuse = map.values().iterator();
            while (valuse.hasNext()) {
                Object refparaelement = valuse.next();
                if (!(refparaelement instanceof OMElement)) continue;
                to.addReferenceParameter((OMElement)refparaelement);
            }
        }
    }

    public void execute(boolean block) throws AxisFault {
        if (this.completed) {
            throw new AxisFault(Messages.getMessage("mepiscomplted"));
        }
        ConfigurationContext cc = this.sc.getConfigurationContext();
        if (this.mc.getSoapAction() == null || "".equals(this.mc.getSoapAction())) {
            this.mc.setSoapAction(this.options.getAction());
        }
        this.mc.setOptions(this.options);
        this.mc.setAxisMessage(this.axisOp.getMessage("Out"));
        cc.getAxisConfiguration().getTargetResolverChain().resolveTarget(this.mc);
        TransportOutDescription senderTransport = this.options.getTransportOut();
        if (senderTransport == null) {
            EndpointReference toEPR = this.options.getTo() != null ? this.options.getTo() : this.mc.getTo();
            senderTransport = ClientUtils.inferOutTransport(cc.getAxisConfiguration(), toEPR, this.mc);
        }
        this.mc.setTransportOut(senderTransport);
        OperationContext oc = new OperationContext(this.axisOp, this.sc);
        oc.addMessageContext(this.mc);
        this.addReferenceParameters(this.mc);
        AxisEngine engine = new AxisEngine(cc);
        if (!block) {
            this.mc.setProperty("transportNonBlocking", Boolean.TRUE);
        }
        engine.send(this.mc);
        this.completed = true;
    }

    public void reset() throws AxisFault {
        if (!this.completed) {
            throw new AxisFault(Messages.getMessage("cannotreset"));
        }
        this.mc = null;
        this.completed = false;
    }

    public void complete(MessageContext msgCtxt) throws AxisFault {
        TransportOutDescription trsout = msgCtxt.getTransportOut();
        if (trsout != null) {
            trsout.getSender().cleanup(msgCtxt);
        }
    }

    public OperationContext getOperationContext() {
        return this.oc;
    }
}

