/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.ArchiveFileData;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.java2wsdl.SchemaGenerator;
import org.apache.ws.java2wsdl.utils.TypeTable;
import org.codehaus.jam.JMethod;

public class Utils {
    private static Log log = LogFactory.getLog((Class)Utils.class);

    public static void addFlowHandlers(Flow flow, ClassLoader clsLoader) throws AxisFault {
        int count = flow.getHandlerCount();
        for (int j = 0; j < count; ++j) {
            HandlerDescription handlermd = flow.getHandler(j);
            Class handlerClass = Utils.getHandlerClass(handlermd.getClassName(), clsLoader);
            try {
                Handler handler = (Handler)handlerClass.newInstance();
                handler.init(handlermd);
                handlermd.setHandler(handler);
                continue;
            }
            catch (InstantiationException e) {
                throw new AxisFault(e);
            }
            catch (IllegalAccessException e) {
                throw new AxisFault(e);
            }
        }
    }

    public static void loadHandler(ClassLoader loader1, HandlerDescription desc) throws DeploymentException {
        String handlername = desc.getClassName();
        try {
            Class handlerClass = Loader.loadClass(loader1, handlername);
            Handler handler = (Handler)handlerClass.newInstance();
            handler.init(desc);
            desc.setHandler(handler);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException(e);
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
    }

    public static URL[] getURLsForAllJars(URL url, boolean antiJARLocking) {
        try {
            ZipEntry entry;
            ZipInputStream zin;
            ArrayList<URL> array = new ArrayList<URL>();
            String urlString = url.toString();
            InputStream in = url.openStream();
            FileInputStream fin = null;
            if (antiJARLocking) {
                File inputFile = Utils.createTempFile(urlString.substring(urlString.length() - 4), in);
                in.close();
                array.add(inputFile.toURL());
                fin = new FileInputStream(inputFile);
                zin = new ZipInputStream(fin);
            } else {
                array.add(url);
                zin = new ZipInputStream(in);
            }
            while ((entry = zin.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (entryName == null || !entryName.toLowerCase().startsWith("lib/") || !entryName.toLowerCase().endsWith(".jar")) continue;
                String suffix = entryName.substring(4);
                File f = Utils.createTempFile(suffix, zin);
                array.add(f.toURL());
            }
            zin.close();
            if (!antiJARLocking) {
                in.close();
            }
            if (fin != null) {
                fin.close();
            }
            return array.toArray(new URL[array.size()]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static File createTempFile(String suffix, InputStream in) throws IOException {
        int count;
        byte[] data = new byte[2048];
        new File(System.getProperty("java.io.tmpdir")).mkdirs();
        File f = File.createTempFile("axis2", suffix);
        f.deleteOnExit();
        FileOutputStream out = new FileOutputStream(f);
        while ((count = in.read(data, 0, 2048)) != -1) {
            out.write(data, 0, count);
        }
        out.close();
        return f;
    }

    public static ClassLoader getClassLoader(ClassLoader parent, String path) throws DeploymentException {
        return Utils.getClassLoader(parent, new File(path));
    }

    public static ClassLoader getClassLoader(ClassLoader parent, File file) throws DeploymentException {
        if (file != null) {
            try {
                File jarfile;
                int i;
                File[] jarfiles;
                ArrayList<URL> urls = new ArrayList<URL>();
                urls.add(file.toURL());
                File libfiles = new File(file, "lib");
                if (libfiles.exists()) {
                    urls.add(libfiles.toURL());
                    jarfiles = libfiles.listFiles();
                    for (i = 0; i < jarfiles.length; ++i) {
                        jarfile = jarfiles[i];
                        if (!jarfile.getName().endsWith(".jar")) continue;
                        urls.add(jarfile.toURL());
                    }
                } else {
                    libfiles = new File(file, "Lib");
                    if (libfiles.exists()) {
                        urls.add(libfiles.toURL());
                        jarfiles = libfiles.listFiles();
                        for (i = 0; i < jarfiles.length; ++i) {
                            jarfile = jarfiles[i];
                            if (!jarfile.getName().endsWith(".jar")) continue;
                            urls.add(jarfile.toURL());
                        }
                    }
                }
                URL[] urllist = new URL[urls.size()];
                for (i = 0; i < urls.size(); ++i) {
                    urllist[i] = (URL)urls.get(i);
                }
                URLClassLoader classLoader = new URLClassLoader(urllist, parent);
                return classLoader;
            }
            catch (MalformedURLException e) {
                throw new DeploymentException(e);
            }
        }
        return null;
    }

    private static Class getHandlerClass(String className, ClassLoader loader1) throws AxisFault {
        Class handlerClass;
        try {
            handlerClass = Loader.loadClass(loader1, className);
        }
        catch (ClassNotFoundException e) {
            throw new AxisFault(e.getMessage());
        }
        return handlerClass;
    }

    /*
     * WARNING - void declaration
     */
    public static void fillAxisService(AxisService axisService, AxisConfiguration axisConfig, ArrayList excludeOperations) throws Exception {
        void var3_5;
        String serviceClass;
        Parameter implInfoParam = axisService.getParameter("ServiceClass");
        ClassLoader serviceClassLoader = axisService.getClassLoader();
        if (implInfoParam != null) {
            serviceClass = (String)implInfoParam.getValue();
        } else {
            implInfoParam = axisService.getParameter("ServiceObjectSupplier");
            if (implInfoParam != null) {
                Class serviceObjectMaker = Loader.loadClass(serviceClassLoader, ((String)implInfoParam.getValue()).trim());
                Method method = serviceObjectMaker.getMethod("getServiceObject", AxisService.class);
                Object obj = null;
                if (method != null) {
                    obj = method.invoke(serviceObjectMaker.newInstance(), axisService);
                }
                if (obj == null) {
                    log.warn((Object)"ServiceObjectSupplier implmentation Object could not be found");
                    throw new DeploymentException("ServiceClass or ServiceObjectSupplier implmentation Object could not be found");
                }
                serviceClass = obj.getClass().getName();
            } else {
                return;
            }
        }
        NamespaceMap map = new NamespaceMap();
        map.put((Object)"ns1", (Object)"http://org.apache.axis2/xsd");
        map.put((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema");
        axisService.setNameSpacesMap(map);
        SchemaGenerator schemaGenerator = new SchemaGenerator(serviceClassLoader, var3_5.trim(), axisService.getSchematargetNamespace(), axisService.getSchematargetNamespacePrefix());
        schemaGenerator.setExcludeMethods(excludeOperations);
        if (!axisService.isElementFormDefault()) {
            schemaGenerator.setElementFormDefault("unqualified");
        }
        schemaGenerator.setPkg2nsmap(axisService.getP2nMap());
        Collection schemas = schemaGenerator.generateSchema();
        axisService.addSchema(schemas);
        axisService.setSchematargetNamespace(schemaGenerator.getSchemaTargetNameSpace());
        axisService.setTypeTable(schemaGenerator.getTypeTable());
        if ("http://ws.apache.org/axis2".equals(axisService.getTargetNamespace())) {
            axisService.setTargetNamespace(schemaGenerator.getTargetNamespace());
        }
        JMethod[] method = schemaGenerator.getMethods();
        TypeTable table = schemaGenerator.getTypeTable();
        PhasesInfo pinfo = axisConfig.getPhasesInfo();
        for (int i = 0; i < method.length; ++i) {
            JMethod jmethod = method[i];
            if (!jmethod.isPublic() || excludeOperations.contains(jmethod.getSimpleName())) continue;
            String opName = jmethod.getSimpleName();
            AxisOperation operation = axisService.getOperation(new QName(opName));
            if (operation != null) {
                AxisMessage inMessage = operation.getMessage("In");
                if (inMessage != null) {
                    inMessage.setName(opName + "Message");
                    inMessage.setElementQName(table.getComplexSchemaType(jmethod.getSimpleName()));
                }
                if (!jmethod.getReturnType().isVoidType()) {
                    AxisMessage outMessage = operation.getMessage("Out");
                    outMessage.setElementQName(table.getQNamefortheType(jmethod.getSimpleName() + "Response"));
                    outMessage.setName(opName + "Response");
                }
                if (jmethod.getExceptionTypes().length > 0) {
                    AxisMessage faultMessage = new AxisMessage();
                    faultMessage.setName(jmethod.getSimpleName() + "Fault");
                    faultMessage.setElementQName(table.getComplexSchemaType(jmethod.getSimpleName() + "Fault"));
                    operation.setFaultMessages(faultMessage);
                }
            } else {
                operation = Utils.getAxisOperationforJmethod(jmethod, table);
                MessageReceiver mr = axisService.getMessageReceiver(operation.getMessageExchangePattern());
                if (mr != null) {
                    operation.setMessageReceiver(mr);
                } else {
                    mr = axisConfig.getMessageReceiver(operation.getMessageExchangePattern());
                    operation.setMessageReceiver(mr);
                }
                pinfo.setOperationPhases(operation);
                axisService.addOperation(operation);
            }
            operation.setSoapAction("urn:" + opName);
        }
    }

    public static AxisOperation getAxisOperationforJmethod(JMethod jmethod, TypeTable table) throws AxisFault {
        AxisOperation operation;
        String opName = jmethod.getSimpleName();
        if (jmethod.getReturnType().isVoidType()) {
            operation = AxisOperationFactory.getAxisOperation(10);
        } else {
            operation = AxisOperationFactory.getAxisOperation(12);
            AxisMessage outMessage = operation.getMessage("Out");
            outMessage.setElementQName(table.getQNamefortheType(jmethod.getSimpleName() + "Response"));
            outMessage.setName(opName + "Response");
        }
        if (jmethod.getExceptionTypes().length > 0) {
            AxisMessage faultMessage = new AxisMessage();
            faultMessage.setName(jmethod.getSimpleName() + "Fault");
            faultMessage.setElementQName(table.getComplexSchemaType(jmethod.getSimpleName() + "Fault"));
            operation.setFaultMessages(faultMessage);
        }
        operation.setName(new QName(opName));
        AxisMessage inMessage = operation.getMessage("In");
        if (inMessage != null) {
            inMessage.setElementQName(table.getComplexSchemaType(jmethod.getSimpleName()));
            inMessage.setName(opName + "Message");
        }
        return operation;
    }

    public static OMElement getParameter(String name, String value, boolean locked) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement parameter = fac.createOMElement("parameter", null);
        parameter.addAttribute("name", name, null);
        parameter.addAttribute("locked", Boolean.toString(locked), null);
        parameter.setText(value);
        return parameter;
    }

    public static void deployModuleServices(AxisModule module, ConfigurationContext configCtx) throws AxisFault {
        try {
            AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
            ArchiveReader archiveReader = new ArchiveReader();
            PhasesInfo phasesInfo = axisConfig.getPhasesInfo();
            ClassLoader moduleClassLoader = module.getModuleClassLoader();
            ArrayList<String> services = new ArrayList<String>();
            InputStream in = moduleClassLoader.getResourceAsStream("aars/aars.list");
            if (in != null) {
                try {
                    String line;
                    BufferedReader input = new BufferedReader(new InputStreamReader(in));
                    while ((line = input.readLine()) != null) {
                        services.add(line);
                    }
                    input.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (services.size() > 0) {
                for (int i = 0; i < services.size(); ++i) {
                    String servicename = (String)services.get(i);
                    if (servicename == null || "".equals(servicename)) continue;
                    InputStream fin = moduleClassLoader.getResourceAsStream("aars/" + servicename);
                    if (fin == null) {
                        throw new AxisFault("No service archiev found : " + servicename);
                    }
                    File inputFile = Utils.createTempFile(servicename, fin);
                    ArchiveFileData filedata = new ArchiveFileData(inputFile, 0, false);
                    filedata.setClassLoader(false, moduleClassLoader);
                    HashMap wsdlservice = archiveReader.processWSDLs(filedata);
                    if (wsdlservice != null && wsdlservice.size() > 0) {
                        Iterator servicesitr = wsdlservice.values().iterator();
                        while (servicesitr.hasNext()) {
                            AxisService service = (AxisService)servicesitr.next();
                            Iterator operations = service.getOperations();
                            while (operations.hasNext()) {
                                AxisOperation axisOperation = (AxisOperation)operations.next();
                                phasesInfo.setOperationPhases(axisOperation);
                            }
                        }
                    }
                    AxisServiceGroup serviceGroup = new AxisServiceGroup(axisConfig);
                    serviceGroup.setServiceGroupClassLoader(filedata.getClassLoader());
                    ArrayList serviceList = archiveReader.processServiceGroup(filedata.getAbsolutePath(), filedata, serviceGroup, false, wsdlservice, configCtx);
                    for (int j = 0; j < serviceList.size(); ++j) {
                        AxisService axisService = (AxisService)serviceList.get(j);
                        serviceGroup.addService(axisService);
                    }
                    axisConfig.addServiceGroup(serviceGroup);
                    fin.close();
                }
            }
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    public static String normalize(String uri) {
        if ("".equals(uri)) {
            return uri;
        }
        int leadingSlashes = 0;
        for (leadingSlashes = 0; leadingSlashes < uri.length() && uri.charAt(leadingSlashes) == '/'; ++leadingSlashes) {
        }
        boolean isDir = uri.charAt(uri.length() - 1) == '/';
        StringTokenizer st = new StringTokenizer(uri, "/");
        LinkedList<String> clean = new LinkedList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("..".equals(token)) {
                if (!clean.isEmpty() && !"..".equals(clean.getLast())) {
                    clean.removeLast();
                    if (st.hasMoreTokens()) continue;
                    isDir = true;
                    continue;
                }
                clean.add("..");
                continue;
            }
            if (".".equals(token) || "".equals(token)) continue;
            clean.add(token);
        }
        StringBuffer sb = new StringBuffer();
        while (leadingSlashes-- > 0) {
            sb.append('/');
        }
        Iterator it = clean.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append('/');
        }
        if (isDir && sb.length() > 0 && sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        return sb.toString();
    }

    public static String getPath(String parent, String childPath) {
        String value;
        int i;
        String[] values;
        Stack<String> parentStack = new Stack<String>();
        Stack<String> childStack = new Stack<String>();
        if (parent != null && (values = parent.split("/")).length > 0) {
            for (i = 0; i < values.length; ++i) {
                value = values[i];
                parentStack.push(value);
            }
        }
        if ((values = childPath.split("/")).length > 0) {
            for (i = 0; i < values.length; ++i) {
                value = values[i];
                childStack.push(value);
            }
        }
        String filepath = "";
        while (!childStack.isEmpty()) {
            value = (String)childStack.pop();
            if ("..".equals(value)) {
                parentStack.pop();
                continue;
            }
            if ("".equals(value)) continue;
            if ("".equals(filepath)) {
                filepath = value;
                continue;
            }
            filepath = value + "/" + filepath;
        }
        while (!parentStack.isEmpty()) {
            value = (String)parentStack.pop();
            if ("".equals(value)) continue;
            filepath = value + "/" + filepath;
        }
        return filepath;
    }
}

