/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportListener;

public class Options {
    public static final int DEFAULT_TIMEOUT_MILLISECONDS = 30000;
    private Options parent;
    private Map properties = new HashMap();
    private String soapVersionURI;
    private Boolean isExceptionToBeThrownOnSOAPFault;
    private long timeOutInMilliSeconds = -1L;
    private Boolean useSeparateListener;
    private String action;
    private EndpointReference faultTo;
    private EndpointReference from;
    private TransportListener listener;
    private TransportInDescription transportIn;
    private String transportInProtocol;
    private String messageId;
    private List relationships;
    private EndpointReference replyTo;
    private ArrayList referenceParameters;
    protected TransportOutDescription transportOut;
    private EndpointReference to;
    private boolean manageSession = false;

    public Options() {
    }

    public Options(Options parent) {
        this.parent = parent;
    }

    public String getAction() {
        if (this.action == null && this.parent != null) {
            return this.parent.getAction();
        }
        return this.action;
    }

    public EndpointReference getFaultTo() {
        if (this.faultTo == null && this.parent != null) {
            return this.parent.getFaultTo();
        }
        return this.faultTo;
    }

    public EndpointReference getFrom() {
        if (this.from == null && this.parent != null) {
            return this.parent.getFrom();
        }
        return this.from;
    }

    public TransportListener getListener() {
        if (this.listener == null && this.parent != null) {
            return this.parent.getListener();
        }
        return this.listener;
    }

    public TransportInDescription getTransportIn() {
        if (this.transportIn == null && this.parent != null) {
            return this.parent.getTransportIn();
        }
        return this.transportIn;
    }

    public String getTransportInProtocol() {
        if (this.transportInProtocol == null && this.parent != null) {
            return this.parent.getTransportInProtocol();
        }
        return this.transportInProtocol;
    }

    public String getMessageId() {
        if (this.messageId == null && this.parent != null) {
            return this.parent.getMessageId();
        }
        return this.messageId;
    }

    public Map getProperties() {
        if (this.parent == null) {
            return new HashMap(this.properties);
        }
        Map props = this.parent.getProperties();
        props.putAll(this.properties);
        return props;
    }

    public Object getProperty(String key) {
        Object myPropValue = this.properties.get(key);
        if (myPropValue == null && this.parent != null) {
            return this.parent.getProperty(key);
        }
        return myPropValue;
    }

    public RelatesTo getRelatesTo(String type) {
        if (this.relationships == null && this.parent != null) {
            return this.parent.getRelatesTo(type);
        }
        for (int i = 0; this.relationships != null && i < this.relationships.size(); ++i) {
            RelatesTo relatesTo = (RelatesTo)this.relationships.get(i);
            String relationshipType = relatesTo.getRelationshipType();
            if (!relationshipType.equals(type)) continue;
            return relatesTo;
        }
        return null;
    }

    public RelatesTo getRelatesTo() {
        if (this.relationships == null && this.parent != null) {
            return this.parent.getRelatesTo();
        }
        for (int i = 0; this.relationships != null && i < this.relationships.size(); ++i) {
            RelatesTo relatesTo = (RelatesTo)this.relationships.get(i);
            String relationshipType = relatesTo.getRelationshipType();
            if (!relationshipType.equals("http://www.w3.org/2005/08/addressing/reply") && !relationshipType.equals("wsa:Reply")) continue;
            return relatesTo;
        }
        return null;
    }

    public RelatesTo[] getRelationships() {
        if (this.relationships == null && this.parent != null) {
            return this.parent.getRelationships();
        }
        if (this.relationships == null) {
            return null;
        }
        return this.relationships.toArray(new RelatesTo[this.relationships.size()]);
    }

    public void setRelationships(RelatesTo[] list) {
        this.relationships = list == null ? null : Arrays.asList(list);
    }

    public EndpointReference getReplyTo() {
        if (this.replyTo == null && this.parent != null) {
            return this.parent.getReplyTo();
        }
        return this.replyTo;
    }

    public TransportOutDescription getTransportOut() {
        if (this.transportOut == null && this.parent != null) {
            return this.parent.getTransportOut();
        }
        return this.transportOut;
    }

    public String getSoapVersionURI() {
        if (this.soapVersionURI == null && this.parent != null) {
            return this.parent.getSoapVersionURI();
        }
        return this.soapVersionURI == null ? "http://schemas.xmlsoap.org/soap/envelope/" : this.soapVersionURI;
    }

    public long getTimeOutInMilliSeconds() {
        if (this.timeOutInMilliSeconds == -1L && this.parent != null) {
            return this.parent.getTimeOutInMilliSeconds();
        }
        return this.timeOutInMilliSeconds == -1L ? 30000L : this.timeOutInMilliSeconds;
    }

    public EndpointReference getTo() {
        if (this.to == null && this.parent != null) {
            return this.parent.getTo();
        }
        return this.to;
    }

    public boolean isExceptionToBeThrownOnSOAPFault() {
        if (this.isExceptionToBeThrownOnSOAPFault == null && this.parent != null) {
            this.isExceptionToBeThrownOnSOAPFault = this.parent.isExceptionToBeThrownOnSOAPFault;
        }
        return this.isExceptionToBeThrownOnSOAPFault == null || this.isExceptionToBeThrownOnSOAPFault != false;
    }

    public boolean isUseSeparateListener() {
        if (this.useSeparateListener == null && this.parent != null) {
            this.useSeparateListener = this.parent.useSeparateListener;
        }
        return this.useSeparateListener != null && this.useSeparateListener != false;
    }

    public Options getParent() {
        return this.parent;
    }

    public void setParent(Options parent) {
        this.parent = parent;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setExceptionToBeThrownOnSOAPFault(boolean exceptionToBeThrownOnSOAPFault) {
        this.isExceptionToBeThrownOnSOAPFault = exceptionToBeThrownOnSOAPFault;
    }

    public void setFaultTo(EndpointReference faultTo) {
        this.faultTo = faultTo;
    }

    public void setFrom(EndpointReference from) {
        this.from = from;
    }

    public void setListener(TransportListener listener) {
        this.listener = listener;
    }

    public void setTransportIn(TransportInDescription transportIn) {
        this.transportIn = transportIn;
    }

    public void setTransportInProtocol(String transportInProtocol) {
        this.transportInProtocol = transportInProtocol;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public void setProperty(String propertyKey, Object property) {
        this.properties.put(propertyKey, property);
    }

    public void addRelatesTo(RelatesTo relatesTo) {
        if (this.relationships == null) {
            this.relationships = new ArrayList(5);
        }
        this.relationships.add(relatesTo);
    }

    public void setReplyTo(EndpointReference replyTo) {
        this.replyTo = replyTo;
    }

    public void setTransportOut(TransportOutDescription transportOut) {
        this.transportOut = transportOut;
    }

    public void setSenderTransport(String senderTransport, AxisConfiguration axisConfiguration) throws AxisFault {
        this.transportOut = axisConfiguration.getTransportOut(new QName(senderTransport));
        if (senderTransport == null) {
            throw new AxisFault(Messages.getMessage("unknownTransport", senderTransport));
        }
    }

    public void setSoapVersionURI(String soapVersionURI) {
        this.soapVersionURI = soapVersionURI;
    }

    public void setTimeOutInMilliSeconds(long timeOutInMilliSeconds) {
        this.timeOutInMilliSeconds = timeOutInMilliSeconds;
    }

    public void setTo(EndpointReference to) {
        this.to = to;
    }

    public void setTransportInfo(String senderTransport, String listenerTransport, boolean useSeparateListener) throws AxisFault {
        if (!useSeparateListener) {
            boolean isATwoWaytransport;
            boolean isTransportsEqual = senderTransport.equals(listenerTransport);
            boolean bl = isATwoWaytransport = "http".equals(senderTransport) || "tcp".equals(senderTransport);
            if (!isTransportsEqual || !isATwoWaytransport) {
                throw new AxisFault(Messages.getMessage("useSeparateListenerLimited"));
            }
        } else {
            this.setUseSeparateListener(useSeparateListener);
        }
        this.setTransportInProtocol(listenerTransport);
    }

    public void setUseSeparateListener(boolean useSeparateListener) {
        this.useSeparateListener = useSeparateListener;
    }

    public void addReferenceParameter(OMElement referenceParameter) {
        if (this.referenceParameters == null) {
            this.referenceParameters = new ArrayList(5);
        }
        this.referenceParameters.add(referenceParameter);
    }

    public boolean isManageSession() {
        return this.manageSession;
    }

    public void setManageSession(boolean manageSession) {
        this.manageSession = manageSession;
    }
}

