/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.mail.PasswordAuthentication;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.AbstractTransportSender;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.axis2.transport.mail.EMailSender;
import org.apache.axis2.util.Utils;

public class MailTransportSender
extends AbstractTransportSender {
    private Properties smtpProperties = new Properties();
    private PasswordAuthentication passwordAuthentication;
    private ByteArrayOutputStream byteArrayOutputStream;
    private OMOutputFormat format = new OMOutputFormat();

    public void init(ConfigurationContext configurationContext, TransportOutDescription transportOut) throws AxisFault {
        ArrayList mailParameters = transportOut.getParameters();
        String password = "";
        String username = "";
        Iterator iterator = mailParameters.iterator();
        while (iterator.hasNext()) {
            Parameter param = (Parameter)iterator.next();
            String paramKey = param.getName();
            String paramValue = Utils.getParameterValue(param);
            if (paramKey == null || paramValue == null) {
                throw new AxisFault(Messages.getMessage("canNotBeNull", "Parameter name nor value should be null"));
            }
            this.smtpProperties.setProperty(paramKey, paramValue);
            if (paramKey.equals("mail.smtp.user")) {
                username = paramValue;
            }
            if (!paramKey.equals("transport.mail.smtp.password")) continue;
            password = paramValue;
        }
        this.passwordAuthentication = new PasswordAuthentication(username, password);
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    public void finalizeSendWithOutputStreamFromIncomingConnection(MessageContext msgContext, OutputStream out) throws AxisFault {
    }

    private void runtimeMailParameterSetting(MessageContext msgContext) {
        Object obj = msgContext.getProperty("_MAIL_SMTP_");
        if (obj != null && obj instanceof HttpTransportProperties.MailProperties) {
            HttpTransportProperties.MailProperties props = (HttpTransportProperties.MailProperties)obj;
            this.smtpProperties.clear();
            this.smtpProperties.putAll((Map<?, ?>)props.getProperties());
            String username = (String)this.smtpProperties.get("mail.smtp.user");
            String passwd = props.getPassword();
            this.passwordAuthentication = new PasswordAuthentication(username, passwd);
        }
    }

    public void finalizeSendWithToAddress(MessageContext msgContext, OutputStream out) throws AxisFault {
        try {
            String email;
            this.runtimeMailParameterSetting(msgContext);
            EMailSender sender = new EMailSender();
            sender.setMessageContext(msgContext);
            sender.setProperties(this.smtpProperties);
            sender.setPasswordAuthentication(this.passwordAuthentication);
            String eprAddress = msgContext.getTo().getAddress();
            String charSet = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
            if (charSet == null) {
                charSet = "UTF-8";
            }
            this.format.setSOAP11(msgContext.isSOAP11());
            this.format.setCharSetEncoding(charSet);
            int mailNameIndex = eprAddress.indexOf("mail:");
            if (mailNameIndex > -1) {
                eprAddress = eprAddress.substring(mailNameIndex + 5);
            }
            int index = eprAddress.indexOf(47);
            String subject = "";
            if (index >= 0) {
                subject = eprAddress.substring(index + 1);
                email = eprAddress.substring(0, index);
            } else {
                email = eprAddress;
            }
            int emailColon = email.indexOf(":");
            if (emailColon >= 0) {
                email = email.substring(emailColon + 1);
            }
            sender.send(subject, email, new String(this.byteArrayOutputStream.toByteArray()), this.format);
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    protected OutputStream openTheConnection(EndpointReference epr, MessageContext msgContext) throws AxisFault {
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        return this.byteArrayOutputStream;
    }

    public OutputStream startSendWithOutputStreamFromIncomingConnection(MessageContext msgContext, OutputStream out) throws AxisFault {
        throw new UnsupportedOperationException();
    }

    public OutputStream startSendWithToAddress(MessageContext msgContext, OutputStream out) throws AxisFault {
        return out;
    }

    public void writeMessage(MessageContext msgContext, OutputStream out) throws AxisFault {
        SOAPEnvelope envelope;
        SOAPEnvelope outputMessage = envelope = msgContext.getEnvelope();
        if (envelope != null && msgContext.isDoingREST()) {
            outputMessage = envelope.getBody().getFirstElement();
        }
        if (outputMessage != null) {
            try {
                OMOutputFormat format = new OMOutputFormat();
                format.setDoOptimize(msgContext.isDoingMTOM());
                format.setCharSetEncoding(null);
                outputMessage.serializeAndConsume(out, format);
                out.flush();
            }
            catch (Exception e) {
                throw new AxisFault(e);
            }
        } else {
            throw new AxisFault(Messages.getMessage("outMessageNull"));
        }
    }

    public void stop() {
    }
}

