/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.i18n.Messages;

public class InOutAxisOperation
extends AxisOperation {
    private AxisMessage inFaultMessage;
    private AxisMessage outFaultMessage;

    public InOutAxisOperation() {
        this.createMessages();
    }

    public InOutAxisOperation(QName name) {
        super(name);
        this.createMessages();
    }

    public void addMessage(AxisMessage message, String label) {
        if ("Out".equals(label)) {
            this.addChild("outMessage", message);
        } else if ("In".equals(label)) {
            this.addChild("inMessage", message);
        } else if ("Fault".equals(label)) {
            this.addChild("faultMessage", message);
        } else {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }

    public void addMessageContext(MessageContext msgContext, OperationContext opContext) throws AxisFault {
        HashMap mep = opContext.getMessageContexts();
        MessageContext inMsgContext = (MessageContext)mep.get("In");
        MessageContext outmsgContext = (MessageContext)mep.get("Out");
        if (inMsgContext != null && outmsgContext != null) {
            throw new AxisFault(Messages.getMessage("mepcompleted"));
        }
        if (inMsgContext == null) {
            mep.put("In", msgContext);
        } else {
            mep.put("Out", msgContext);
            opContext.setComplete(true);
            opContext.cleanup();
        }
    }

    public void addFaultMessageContext(MessageContext msgContext, OperationContext opContext) throws AxisFault {
        HashMap mep = opContext.getMessageContexts();
        MessageContext faultMessageCtxt = (MessageContext)mep.get("Fault");
        if (faultMessageCtxt != null) {
            throw new AxisFault(Messages.getMessage("mepcompleted"));
        }
        mep.put("Fault", msgContext);
        opContext.setComplete(true);
        opContext.cleanup();
    }

    private void createMessages() {
        AxisMessage inMessage = new AxisMessage();
        inMessage.setDirection("in");
        inMessage.setParent(this);
        this.addChild("inMessage", inMessage);
        this.inFaultMessage = new AxisMessage();
        this.inFaultMessage.setParent(this);
        this.outFaultMessage = new AxisMessage();
        this.outFaultMessage.setParent(this);
        AxisMessage outMessage = new AxisMessage();
        outMessage.setDirection("out");
        outMessage.setParent(this);
        this.addChild("outMessage", outMessage);
    }

    public AxisMessage getMessage(String label) {
        if ("Out".equals(label)) {
            return (AxisMessage)this.getChild("outMessage");
        }
        if ("In".equals(label)) {
            return (AxisMessage)this.getChild("inMessage");
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public ArrayList getPhasesInFaultFlow() {
        return this.inFaultMessage.getMessageFlow();
    }

    public ArrayList getPhasesOutFaultFlow() {
        return this.outFaultMessage.getMessageFlow();
    }

    public ArrayList getPhasesOutFlow() {
        return ((AxisMessage)this.getChild("outMessage")).getMessageFlow();
    }

    public ArrayList getRemainingPhasesInFlow() {
        return ((AxisMessage)this.getChild("inMessage")).getMessageFlow();
    }

    public void setPhasesInFaultFlow(ArrayList list) {
        this.inFaultMessage.setMessageFlow(list);
    }

    public void setPhasesOutFaultFlow(ArrayList list) {
        this.outFaultMessage.setMessageFlow(list);
    }

    public void setPhasesOutFlow(ArrayList list) {
        ((AxisMessage)this.getChild("outMessage")).setMessageFlow(list);
    }

    public void setRemainingPhasesInFlow(ArrayList list) {
        ((AxisMessage)this.getChild("inMessage")).setMessageFlow(list);
    }
}

