/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AxisConfigBuilder;
import org.apache.axis2.deployment.DeploymentClassLoader;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.ModuleBuilder;
import org.apache.axis2.deployment.RepositoryListener;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.deployment.ServiceGroupBuilder;
import org.apache.axis2.deployment.repository.util.ArchiveFileData;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.repository.util.WSInfo;
import org.apache.axis2.deployment.scheduler.DeploymentIterator;
import org.apache.axis2.deployment.scheduler.Scheduler;
import org.apache.axis2.deployment.scheduler.SchedulerTask;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeploymentEngine
implements DeploymentConstants {
    private static final Log log = LogFactory.getLog((Class)DeploymentEngine.class);
    private boolean hotUpdate = true;
    private boolean hotDeployment = true;
    private boolean antiJARLocking = false;
    private List wsToDeploy = new ArrayList();
    private List wsToUnDeploy = new ArrayList();
    private String webLocationString = null;
    protected AxisConfiguration axisConfig;
    protected ConfigurationContext configContext;
    private RepositoryListener repoListener;
    private String servicesPath = null;
    private File servicesDir = null;
    private String modulesPath = null;
    private File modulesDir = null;

    public void loadServices() {
        this.repoListener.checkServices();
        if (this.hotDeployment) {
            this.startSearch(this.repoListener);
        }
    }

    public void loadRepository(String repoDir) throws DeploymentException {
        File axisRepo = new File(repoDir);
        if (!axisRepo.exists()) {
            throw new DeploymentException(Messages.getMessage("cannotfindrepo", repoDir));
        }
        this.setDeploymentFeatures();
        this.prepareRepository(repoDir);
        this.setClassLoaders(repoDir);
        this.repoListener = new RepositoryListener(this, false);
        org.apache.axis2.util.Utils.calculateDefaultModuleVersion(this.axisConfig.getModules(), this.axisConfig);
        try {
            try {
                this.axisConfig.setRepository(axisRepo.toURL());
            }
            catch (MalformedURLException e) {
                log.info((Object)e.getMessage());
            }
            this.validateSystemPredefinedPhases();
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault);
        }
    }

    public void loadFromClassPath() throws DeploymentException {
        new RepositoryListener(this, true);
        org.apache.axis2.util.Utils.calculateDefaultModuleVersion(this.axisConfig.getModules(), this.axisConfig);
        this.validateSystemPredefinedPhases();
        try {
            this.engageModules();
        }
        catch (AxisFault axisFault) {
            log.info((Object)Messages.getMessage("modulevalfailed", axisFault.getMessage()));
            throw new DeploymentException(axisFault);
        }
    }

    public void loadServicesFromUrl(URL repoURL) {
        try {
            String path;
            String string = path = this.servicesPath == null ? "services" : this.servicesPath;
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            URL servicesDir = new URL(repoURL, path);
            URL filelisturl = new URL(servicesDir, "services.list");
            ArrayList files = this.getFileList(filelisturl);
            Iterator fileIterator = files.iterator();
            while (fileIterator.hasNext()) {
                String fileUrl = (String)fileIterator.next();
                if (!fileUrl.endsWith(".aar")) continue;
                AxisServiceGroup serviceGroup = new AxisServiceGroup();
                URL servicesURL = new URL(servicesDir, fileUrl);
                ArrayList servicelist = this.populateService(serviceGroup, servicesURL, fileUrl.substring(0, fileUrl.indexOf(".aar")));
                this.addServiceGroup(serviceGroup, servicelist, servicesURL, null);
            }
        }
        catch (MalformedURLException e) {
            log.info((Object)e.getMessage());
        }
        catch (IOException e) {
            log.info((Object)e.getMessage());
        }
    }

    public void loadRepositoryFromURL(URL repoURL) throws DeploymentException {
        try {
            String path;
            String string = path = this.modulesPath == null ? "modules" : this.modulesPath;
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            URL moduleDir = new URL(repoURL, path);
            URL filelisturl = new URL(moduleDir, "modules.list");
            ArrayList files = this.getFileList(filelisturl);
            Iterator fileIterator = files.iterator();
            while (fileIterator.hasNext()) {
                String fileUrl = (String)fileIterator.next();
                if (!fileUrl.endsWith(".mar")) continue;
                URL moduleurl = new URL(moduleDir, fileUrl);
                DeploymentClassLoader deploymentClassLoader = new DeploymentClassLoader(new URL[]{moduleurl}, this.axisConfig.getModuleClassLoader(), this.antiJARLocking);
                AxisModule module = new AxisModule();
                module.setModuleClassLoader(deploymentClassLoader);
                module.setParent(this.axisConfig);
                String moduleName = fileUrl.substring(0, fileUrl.indexOf(".mar"));
                module.setName(new QName(moduleName));
                this.populateModule(module, moduleurl);
                module.setFileName(moduleurl);
                this.addNewModule(module);
            }
            org.apache.axis2.util.Utils.calculateDefaultModuleVersion(this.axisConfig.getModules(), this.axisConfig);
            this.validateSystemPredefinedPhases();
        }
        catch (MalformedURLException e) {
            throw new DeploymentException(e);
        }
        catch (IOException e) {
            throw new DeploymentException(e);
        }
    }

    private void populateModule(AxisModule module, URL moduleUrl) throws DeploymentException {
        try {
            ClassLoader classLoadere = module.getModuleClassLoader();
            InputStream moduleStream = classLoadere.getResourceAsStream("META-INF/module.xml");
            if (moduleStream == null) {
                moduleStream = classLoadere.getResourceAsStream("meta-inf/module.xml");
            }
            if (moduleStream == null) {
                throw new DeploymentException(Messages.getMessage("modulexmlnotfound", moduleUrl.toString()));
            }
            ModuleBuilder moduleBuilder = new ModuleBuilder(moduleStream, module, this.axisConfig);
            moduleBuilder.populateModule();
        }
        catch (IOException e) {
            throw new DeploymentException(e);
        }
    }

    private ArrayList populateService(AxisServiceGroup serviceGroup, URL servicesURL, String serviceName) throws DeploymentException {
        try {
            serviceGroup.setServiceGroupName(serviceName);
            DeploymentClassLoader serviceClassLoader = new DeploymentClassLoader(new URL[]{servicesURL}, this.axisConfig.getServiceClassLoader(), this.antiJARLocking);
            String metainf = "meta-inf";
            serviceGroup.setServiceGroupClassLoader(serviceClassLoader);
            InputStream servicexmlStream = serviceClassLoader.getResourceAsStream("META-INF/services.xml");
            if (servicexmlStream == null) {
                servicexmlStream = serviceClassLoader.getResourceAsStream("meta-inf/services.xml");
            } else {
                metainf = "META-INF";
            }
            if (servicexmlStream == null) {
                throw new DeploymentException(Messages.getMessage("servicexmlnotfound", servicesURL.toString()));
            }
            DescriptionBuilder builder = new DescriptionBuilder(servicexmlStream, this.configContext);
            OMElement rootElement = builder.buildOM();
            String elementName = rootElement.getLocalName();
            if ("service".equals(elementName)) {
                AxisDescription axisService = null;
                InputStream wsdlStream = serviceClassLoader.getResourceAsStream(metainf + "/service.wsdl");
                if (wsdlStream == null) {
                    wsdlStream = serviceClassLoader.getResourceAsStream(metainf + "/" + serviceName + ".wsdl");
                }
                if (wsdlStream != null) {
                    WSDL11ToAxisServiceBuilder wsdl2AxisServiceBuilder = new WSDL11ToAxisServiceBuilder(wsdlStream, null, null);
                    axisService = wsdl2AxisServiceBuilder.populateService();
                    ((AxisService)axisService).setWsdlFound(true);
                    ((AxisService)axisService).setName(serviceName);
                }
                if (axisService == null) {
                    axisService = new AxisService(serviceName);
                }
                axisService.setParent(serviceGroup);
                ((AxisService)axisService).setClassLoader(serviceClassLoader);
                ServiceBuilder serviceBuilder = new ServiceBuilder(this.configContext, (AxisService)axisService);
                AxisService service = serviceBuilder.populateService(rootElement);
                ArrayList<AxisService> serviceList = new ArrayList<AxisService>();
                serviceList.add(service);
                return serviceList;
            }
            if ("serviceGroup".equals(elementName)) {
                ServiceGroupBuilder groupBuilder = new ServiceGroupBuilder(rootElement, new HashMap(), this.configContext);
                ArrayList servicList = groupBuilder.populateServiceGroup(serviceGroup);
                Iterator serviceIterator = servicList.iterator();
                while (serviceIterator.hasNext()) {
                    AxisService axisService = (AxisService)serviceIterator.next();
                    InputStream wsdlStream = serviceClassLoader.getResourceAsStream(metainf + "/service.wsdl");
                    if (wsdlStream != null || (wsdlStream = serviceClassLoader.getResourceAsStream(metainf + "/" + serviceName + ".wsdl")) == null) continue;
                    WSDL11ToAxisServiceBuilder wsdl2AxisServiceBuilder = new WSDL11ToAxisServiceBuilder(wsdlStream, axisService);
                    axisService = wsdl2AxisServiceBuilder.populateService();
                    axisService.setWsdlFound(true);
                    Iterator operations = axisService.getOperations();
                    while (operations.hasNext()) {
                        AxisOperation operation = (AxisOperation)operations.next();
                        if (operation.getMessageReceiver() != null) continue;
                        operation.setMessageReceiver(this.loadDefaultMessageReceiver(operation.getMessageExchangePattern(), axisService));
                    }
                }
                return servicList;
            }
        }
        catch (IOException e) {
            throw new DeploymentException(e);
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
        return null;
    }

    protected MessageReceiver loadDefaultMessageReceiver(String mepURL, AxisService service) {
        MessageReceiver messageReceiver;
        if (mepURL == null) {
            mepURL = "http://www.w3.org/2004/08/wsdl/in-out";
        }
        if (service != null && (messageReceiver = service.getMessageReceiver(mepURL)) != null) {
            return messageReceiver;
        }
        return this.axisConfig.getMessageReceiver(mepURL);
    }

    private void addNewModule(AxisModule modulemetadata) throws AxisFault {
        Flow faultOutFlow;
        Flow faultInFlow;
        Flow outFlow;
        Flow inflow = modulemetadata.getInFlow();
        ClassLoader moduleClassLoader = modulemetadata.getModuleClassLoader();
        if (inflow != null) {
            Utils.addFlowHandlers(inflow, moduleClassLoader);
        }
        if ((outFlow = modulemetadata.getOutFlow()) != null) {
            Utils.addFlowHandlers(outFlow, moduleClassLoader);
        }
        if ((faultInFlow = modulemetadata.getFaultInFlow()) != null) {
            Utils.addFlowHandlers(faultInFlow, moduleClassLoader);
        }
        if ((faultOutFlow = modulemetadata.getFaultOutFlow()) != null) {
            Utils.addFlowHandlers(faultOutFlow, moduleClassLoader);
        }
        this.axisConfig.addModule(modulemetadata);
        log.debug((Object)Messages.getMessage("addingnewmodule"));
    }

    private void addServiceGroup(AxisServiceGroup serviceGroup, ArrayList serviceList, URL serviceLocation, ArchiveFileData currentArchiveFile) throws AxisFault {
        DeploymentEngine.fillServiceGroup(serviceGroup, serviceList, serviceLocation, this.axisConfig);
        this.axisConfig.addServiceGroup(serviceGroup);
        if (currentArchiveFile != null) {
            this.addAsWebResources(currentArchiveFile.getFile(), serviceGroup.getServiceGroupName(), serviceGroup);
        }
    }

    private static void fillServiceGroup(AxisServiceGroup serviceGroup, ArrayList serviceList, URL serviceLocation, AxisConfiguration axisConfig) throws AxisFault {
        serviceGroup.setParent(axisConfig);
        ArrayList groupModules = serviceGroup.getModuleRefs();
        for (int i = 0; i < groupModules.size(); ++i) {
            QName moduleName = (QName)groupModules.get(i);
            AxisModule module = axisConfig.getModule(moduleName);
            if (module == null) {
                throw new DeploymentException(Messages.getMessage("badModuleFromService", serviceGroup.getServiceGroupName(), moduleName.getLocalPart()));
            }
            serviceGroup.engageModule(axisConfig.getModule(moduleName), axisConfig);
        }
        Iterator services = serviceList.iterator();
        while (services.hasNext()) {
            AxisService axisService = (AxisService)services.next();
            String scope = axisService.getScope();
            if ("transportsession".equals(scope) && !axisConfig.isManageTransportSession()) {
                throw new DeploymentException("You can not deploy the service in transport session , since transport session management disabled in axis2.xml change manageTransportSession parameter value to true");
            }
            axisService.setUseDefaultChains(false);
            axisService.setFileName(serviceLocation);
            serviceGroup.addService(axisService);
            ArrayList list = axisService.getModules();
            for (int i = 0; i < list.size(); ++i) {
                AxisModule module = axisConfig.getModule((QName)list.get(i));
                if (module == null) {
                    throw new DeploymentException(Messages.getMessage("badModuleFromService", axisService.getName(), ((QName)list.get(i)).getLocalPart()));
                }
                axisService.engageModule(module, axisConfig);
            }
            Iterator iterator = axisService.getOperations();
            while (iterator.hasNext()) {
                AxisOperation opDesc = (AxisOperation)iterator.next();
                ArrayList modules = opDesc.getModuleRefs();
                for (int i = 0; i < modules.size(); ++i) {
                    QName moduleName = (QName)modules.get(i);
                    AxisModule module = axisConfig.getModule(moduleName);
                    if (module == null) {
                        throw new DeploymentException(Messages.getMessage("badModuleFromOperation", opDesc.getName().getLocalPart(), moduleName.getLocalPart()));
                    }
                    opDesc.engageModule(module, axisConfig);
                }
            }
        }
    }

    private void addAsWebResources(File in, String serviceFileName, AxisServiceGroup serviceGroup) {
        try {
            ZipEntry entry;
            if (this.webLocationString == null) {
                return;
            }
            if (in.isDirectory()) {
                return;
            }
            File webLocation = new File(this.webLocationString);
            File out = new File(webLocation, serviceFileName);
            int BUFFER = 1024;
            byte[] data = new byte[BUFFER];
            FileInputStream fin = new FileInputStream(in);
            ZipInputStream zin = new ZipInputStream(fin);
            while ((entry = zin.getNextEntry()) != null) {
                ZipEntry zip = new ZipEntry(entry);
                if (!zip.getName().toUpperCase().startsWith("WWW")) continue;
                String fileName = zip.getName();
                fileName = fileName.substring("WWW/".length(), fileName.length());
                if (zip.isDirectory()) {
                    new File(out, fileName).mkdirs();
                } else {
                    int count;
                    FileOutputStream tempOut = new FileOutputStream(new File(out, fileName));
                    while ((count = zin.read(data, 0, BUFFER)) != -1) {
                        tempOut.write(data, 0, count);
                    }
                    tempOut.close();
                    tempOut.flush();
                }
                serviceGroup.setFoundWebResources(true);
            }
            zin.close();
            fin.close();
        }
        catch (IOException e) {
            log.info((Object)e.getMessage());
        }
    }

    public void addWSToDeploy(ArchiveFileData file) {
        this.wsToDeploy.add(file);
    }

    public void addWSToUndeploy(WSInfo file) {
        this.wsToUnDeploy.add(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doDeploy() {
        if (this.wsToDeploy.size() > 0) {
            for (int i = 0; i < this.wsToDeploy.size(); ++i) {
                ArchiveFileData currentArchiveFile = (ArchiveFileData)this.wsToDeploy.get(i);
                boolean explodedDir = currentArchiveFile.getFile().isDirectory();
                int type = currentArchiveFile.getType();
                try {
                    StringWriter errorWriter = new StringWriter();
                    switch (type) {
                        case 0: {
                            Object var14_22;
                            currentArchiveFile.setClassLoader(explodedDir, this.axisConfig.getServiceClassLoader());
                            ArchiveReader archiveReader = new ArchiveReader();
                            String serviceStatus = "";
                            try {
                                PrintWriter pw;
                                StringWriter sw;
                                PrintWriter error_ptintWriter;
                                try {
                                    HashMap wsdlservice = archiveReader.processWSDLs(currentArchiveFile);
                                    if (wsdlservice != null && wsdlservice.size() > 0) {
                                        Iterator services = wsdlservice.values().iterator();
                                        while (services.hasNext()) {
                                            AxisService service = (AxisService)services.next();
                                            Iterator operations = service.getOperations();
                                            while (operations.hasNext()) {
                                                AxisOperation axisOperation = (AxisOperation)operations.next();
                                                this.axisConfig.getPhasesInfo().setOperationPhases(axisOperation);
                                            }
                                        }
                                    }
                                    AxisServiceGroup sericeGroup = new AxisServiceGroup(this.axisConfig);
                                    sericeGroup.setServiceGroupClassLoader(currentArchiveFile.getClassLoader());
                                    ArrayList serviceList = archiveReader.processServiceGroup(currentArchiveFile.getAbsolutePath(), currentArchiveFile, sericeGroup, explodedDir, wsdlservice, this.configContext);
                                    this.addServiceGroup(sericeGroup, serviceList, currentArchiveFile.getFile().toURL(), currentArchiveFile);
                                    log.info((Object)Messages.getMessage("deployingws", currentArchiveFile.getName()));
                                }
                                catch (DeploymentException de) {
                                    de.printStackTrace();
                                    log.error((Object)Messages.getMessage("invalidservice", currentArchiveFile.getName(), de.getMessage()), (Throwable)de);
                                    error_ptintWriter = new PrintWriter(errorWriter);
                                    de.printStackTrace(error_ptintWriter);
                                    serviceStatus = "Error:\n" + errorWriter.toString();
                                    var14_22 = null;
                                    if (serviceStatus.startsWith("Error:")) {
                                        this.axisConfig.getFaultyServices().put(currentArchiveFile.getFile().getAbsolutePath(), serviceStatus);
                                    }
                                    currentArchiveFile = null;
                                    break;
                                }
                                catch (AxisFault axisFault) {
                                    log.error((Object)Messages.getMessage("invalidservice", currentArchiveFile.getName(), axisFault.getMessage()), (Throwable)axisFault);
                                    error_ptintWriter = new PrintWriter(errorWriter);
                                    axisFault.printStackTrace(error_ptintWriter);
                                    serviceStatus = "Error:\n" + errorWriter.toString();
                                    var14_22 = null;
                                    if (serviceStatus.startsWith("Error:")) {
                                        this.axisConfig.getFaultyServices().put(currentArchiveFile.getFile().getAbsolutePath(), serviceStatus);
                                    }
                                    currentArchiveFile = null;
                                    break;
                                }
                                catch (Exception e) {
                                    if (log.isInfoEnabled()) {
                                        sw = new StringWriter();
                                        pw = new PrintWriter(sw);
                                        e.printStackTrace(pw);
                                        log.info((Object)Messages.getMessage("invalidservice", currentArchiveFile.getName(), sw.getBuffer().toString()));
                                    }
                                    error_ptintWriter = new PrintWriter(errorWriter);
                                    e.printStackTrace(error_ptintWriter);
                                    serviceStatus = "Error:\n" + errorWriter.toString();
                                    var14_22 = null;
                                    if (serviceStatus.startsWith("Error:")) {
                                        this.axisConfig.getFaultyServices().put(currentArchiveFile.getFile().getAbsolutePath(), serviceStatus);
                                    }
                                    currentArchiveFile = null;
                                    break;
                                }
                                catch (Throwable t) {
                                    if (log.isInfoEnabled()) {
                                        sw = new StringWriter();
                                        pw = new PrintWriter(sw);
                                        t.printStackTrace(pw);
                                        log.info((Object)Messages.getMessage("invalidservice", currentArchiveFile.getName(), sw.getBuffer().toString()));
                                    }
                                    error_ptintWriter = new PrintWriter(errorWriter);
                                    t.printStackTrace(error_ptintWriter);
                                    serviceStatus = "Error:\n" + errorWriter.toString();
                                    var14_22 = null;
                                    if (serviceStatus.startsWith("Error:")) {
                                        this.axisConfig.getFaultyServices().put(currentArchiveFile.getFile().getAbsolutePath(), serviceStatus);
                                    }
                                    currentArchiveFile = null;
                                    break;
                                }
                                var14_22 = null;
                                if (serviceStatus.startsWith("Error:")) {
                                    this.axisConfig.getFaultyServices().put(currentArchiveFile.getFile().getAbsolutePath(), serviceStatus);
                                }
                                currentArchiveFile = null;
                                break;
                            }
                            catch (Throwable throwable) {
                                var14_22 = null;
                                if (serviceStatus.startsWith("Error:")) {
                                    this.axisConfig.getFaultyServices().put(currentArchiveFile.getFile().getAbsolutePath(), serviceStatus);
                                }
                                currentArchiveFile = null;
                                throw throwable;
                            }
                        }
                        case 1: {
                            Object var16_23;
                            currentArchiveFile.setClassLoader(explodedDir, this.axisConfig.getModuleClassLoader());
                            ArchiveReader archiveReader = new ArchiveReader();
                            String moduleStatus = "";
                            try {
                                PrintWriter error_ptintWriter;
                                try {
                                    AxisModule metaData = new AxisModule();
                                    metaData.setModuleClassLoader(currentArchiveFile.getClassLoader());
                                    metaData.setParent(this.axisConfig);
                                    archiveReader.readModuleArchive(currentArchiveFile, metaData, explodedDir, this.axisConfig);
                                    metaData.setFileName(currentArchiveFile.getFile().toURL());
                                    this.addNewModule(metaData);
                                    log.info((Object)Messages.getMessage("deployeingmodule", metaData.getName().getLocalPart()));
                                }
                                catch (DeploymentException e) {
                                    log.error((Object)Messages.getMessage("invalidmodule", currentArchiveFile.getName(), e.getMessage()), (Throwable)e);
                                    error_ptintWriter = new PrintWriter(errorWriter);
                                    e.printStackTrace(error_ptintWriter);
                                    moduleStatus = "Error:\n" + errorWriter.toString();
                                    var16_23 = null;
                                    if (moduleStatus.startsWith("Error:")) {
                                        this.axisConfig.getFaultyModules().put(this.getAxisServiceName(currentArchiveFile.getName()), moduleStatus);
                                    }
                                    currentArchiveFile = null;
                                    break;
                                }
                                catch (AxisFault axisFault) {
                                    log.error((Object)Messages.getMessage("invalidmodule", currentArchiveFile.getName(), axisFault.getMessage()), (Throwable)axisFault);
                                    error_ptintWriter = new PrintWriter(errorWriter);
                                    axisFault.printStackTrace(error_ptintWriter);
                                    moduleStatus = "Error:\n" + errorWriter.toString();
                                    var16_23 = null;
                                    if (moduleStatus.startsWith("Error:")) {
                                        this.axisConfig.getFaultyModules().put(this.getAxisServiceName(currentArchiveFile.getName()), moduleStatus);
                                    }
                                    currentArchiveFile = null;
                                    break;
                                }
                                catch (MalformedURLException e) {
                                    log.error((Object)Messages.getMessage("invalidmodule", currentArchiveFile.getName(), e.getMessage()), (Throwable)e);
                                    error_ptintWriter = new PrintWriter(errorWriter);
                                    e.printStackTrace(error_ptintWriter);
                                    moduleStatus = "Error:\n" + errorWriter.toString();
                                    var16_23 = null;
                                    if (moduleStatus.startsWith("Error:")) {
                                        this.axisConfig.getFaultyModules().put(this.getAxisServiceName(currentArchiveFile.getName()), moduleStatus);
                                    }
                                    currentArchiveFile = null;
                                    break;
                                }
                                catch (Throwable t) {
                                    if (log.isInfoEnabled()) {
                                        StringWriter sw = new StringWriter();
                                        PrintWriter pw = new PrintWriter(sw);
                                        t.printStackTrace(pw);
                                        log.error((Object)Messages.getMessage("invalidmodule", currentArchiveFile.getName(), t.getMessage()), t);
                                    }
                                    error_ptintWriter = new PrintWriter(errorWriter);
                                    t.printStackTrace(error_ptintWriter);
                                    moduleStatus = "Error:\n" + errorWriter.toString();
                                    var16_23 = null;
                                    if (moduleStatus.startsWith("Error:")) {
                                        this.axisConfig.getFaultyModules().put(this.getAxisServiceName(currentArchiveFile.getName()), moduleStatus);
                                    }
                                    currentArchiveFile = null;
                                    break;
                                }
                                var16_23 = null;
                                if (moduleStatus.startsWith("Error:")) {
                                    this.axisConfig.getFaultyModules().put(this.getAxisServiceName(currentArchiveFile.getName()), moduleStatus);
                                }
                                currentArchiveFile = null;
                                break;
                            }
                            catch (Throwable throwable) {
                                var16_23 = null;
                                if (moduleStatus.startsWith("Error:")) {
                                    this.axisConfig.getFaultyModules().put(this.getAxisServiceName(currentArchiveFile.getName()), moduleStatus);
                                }
                                currentArchiveFile = null;
                                throw throwable;
                            }
                        }
                    }
                    continue;
                }
                catch (AxisFault axisFault) {
                    log.info((Object)Messages.getMessage("settingcl", axisFault.getMessage()), (Throwable)axisFault);
                }
            }
        }
        this.wsToDeploy.clear();
    }

    public void engageModules() throws AxisFault {
        Iterator iterator = this.axisConfig.getGlobalModules().iterator();
        while (iterator.hasNext()) {
            QName name = (QName)iterator.next();
            this.axisConfig.engageModule(name);
        }
    }

    public AxisConfiguration populateAxisConfiguration(InputStream in) throws DeploymentException {
        this.axisConfig = new AxisConfiguration();
        AxisConfigBuilder builder = new AxisConfigBuilder(in, this.axisConfig);
        builder.populateConfig();
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            log.info((Object)"error in closing input stream");
        }
        return this.axisConfig;
    }

    private void startSearch(RepositoryListener listener) {
        Scheduler scheduler = new Scheduler();
        scheduler.schedule(new SchedulerTask(listener), new DeploymentIterator());
    }

    public void unDeploy() {
        try {
            if (this.wsToUnDeploy.size() > 0) {
                for (int i = 0; i < this.wsToUnDeploy.size(); ++i) {
                    WSInfo wsInfo = (WSInfo)this.wsToUnDeploy.get(i);
                    if (wsInfo.getType() != 0) continue;
                    if (this.isHotUpdate()) {
                        try {
                            String fileName = this.getAxisServiceName(wsInfo.getFileName());
                            this.axisConfig.removeServiceGroup(fileName);
                            log.info((Object)Messages.getMessage("serviceremoved", wsInfo.getFileName()));
                        }
                        catch (AxisFault axisFault) {
                            this.axisConfig.removeFaultyService(wsInfo.getFileName());
                        }
                        continue;
                    }
                    this.axisConfig.removeFaultyService(wsInfo.getFileName());
                }
            }
        }
        catch (Exception e) {
            log.info((Object)e);
        }
        this.wsToUnDeploy.clear();
    }

    private void validateSystemPredefinedPhases() throws DeploymentException {
        PhasesInfo phasesInfo = this.axisConfig.getPhasesInfo();
        this.axisConfig.setInPhasesUptoAndIncludingPostDispatch(phasesInfo.getGlobalInflow());
        this.axisConfig.setInFaultPhases(phasesInfo.getGlobalInFaultPhases());
        this.axisConfig.setGlobalOutPhase(phasesInfo.getGlobalOutPhaseList());
        this.axisConfig.setOutFaultPhases(phasesInfo.getOUT_FaultPhases());
    }

    public AxisConfiguration getAxisConfig() {
        return this.axisConfig;
    }

    private String getAxisServiceName(String fileName) {
        int seperator = 46;
        int index = fileName.indexOf(seperator);
        if (index > 0) {
            String value = fileName.substring(0, index);
            return value;
        }
        return fileName;
    }

    public AxisModule getModule(QName moduleName) throws AxisFault {
        return this.axisConfig.getModule(moduleName);
    }

    public boolean isHotUpdate() {
        return this.hotUpdate;
    }

    public boolean isAntiJARLocking() {
        return this.antiJARLocking;
    }

    private void setClassLoaders(String axis2repoURI) throws DeploymentException {
        ClassLoader sysClassLoader = Utils.getClassLoader(Thread.currentThread().getContextClassLoader(), axis2repoURI);
        this.axisConfig.setSystemClassLoader(sysClassLoader);
        if (this.servicesDir.exists()) {
            this.axisConfig.setServiceClassLoader(Utils.getClassLoader(this.axisConfig.getSystemClassLoader(), this.servicesDir));
        } else {
            this.axisConfig.setServiceClassLoader(this.axisConfig.getSystemClassLoader());
        }
        if (this.modulesDir.exists()) {
            this.axisConfig.setModuleClassLoader(Utils.getClassLoader(this.axisConfig.getSystemClassLoader(), this.modulesDir));
        } else {
            this.axisConfig.setModuleClassLoader(this.axisConfig.getSystemClassLoader());
        }
    }

    private void setDeploymentFeatures() {
        String moduleDirPara;
        String serviceDirPara;
        String value;
        Parameter parahotdeployment = this.axisConfig.getParameter("hotdeployment");
        Parameter parahotupdate = this.axisConfig.getParameter("hotupdate");
        if (parahotdeployment != null && "false".equalsIgnoreCase(value = (String)parahotdeployment.getValue())) {
            this.hotDeployment = false;
        }
        if (parahotupdate != null && "false".equalsIgnoreCase(value = (String)parahotupdate.getValue())) {
            this.hotUpdate = false;
        }
        if (parahotupdate != null && "true".equalsIgnoreCase(value = (String)parahotupdate.getValue())) {
            this.antiJARLocking = true;
        }
        if ((serviceDirPara = (String)this.axisConfig.getParameterValue("ServicesDirectory")) != null) {
            this.servicesPath = serviceDirPara;
        }
        if ((moduleDirPara = (String)this.axisConfig.getParameterValue("ModulesDirectory")) != null) {
            this.modulesPath = moduleDirPara;
        }
    }

    private void prepareRepository(String repositoryName) {
        File repository = new File(repositoryName);
        if (this.servicesPath != null) {
            this.servicesDir = new File(this.servicesPath);
            if (!this.servicesDir.exists()) {
                this.servicesDir = new File(repository, this.servicesPath);
            }
        } else {
            this.servicesDir = new File(repository, "services");
        }
        if (!this.servicesDir.exists()) {
            log.info((Object)Messages.getMessage("noservicedirfound", this.getRepositoryPath(repository)));
        }
        if (this.modulesPath != null) {
            this.modulesDir = new File(this.modulesPath);
            if (!this.modulesDir.exists()) {
                this.modulesDir = new File(repository, this.modulesPath);
            }
        } else {
            this.modulesDir = new File(repository, "modules");
        }
        if (!this.modulesDir.exists()) {
            log.info((Object)Messages.getMessage("nomoduledirfound", this.getRepositoryPath(repository)));
        }
    }

    private String getRepositoryPath(File repository) {
        try {
            return repository.getCanonicalPath();
        }
        catch (IOException e) {
            return repository.getAbsolutePath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ArrayList getFileList(URL fileListUrl) {
        ArrayList<String> fileList;
        block14: {
            String line;
            InputStream in;
            fileList = new ArrayList<String>();
            try {
                in = fileListUrl.openStream();
            }
            catch (IOException e) {
                return fileList;
            }
            BufferedReader input = null;
            input = new BufferedReader(new InputStreamReader(in));
            while ((line = input.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                fileList.add(line);
            }
            Object var7_8 = null;
            try {
                if (input != null) {
                    input.close();
                }
                break block14;
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
            }
            break block14;
            {
                catch (IOException ex) {
                    ex.printStackTrace();
                    Object var7_9 = null;
                    try {
                        if (input != null) {
                            input.close();
                        }
                        break block14;
                    }
                    catch (IOException ex2) {
                        ex2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
                throw throwable;
            }
        }
        return fileList;
    }

    public String getWebLocationString() {
        return this.webLocationString;
    }

    public void setWebLocationString(String webLocationString) {
        this.webLocationString = webLocationString;
    }

    public void setConfigContext(ConfigurationContext configContext) {
        this.configContext = configContext;
    }

    public static AxisModule buildModule(File modulearchive, AxisConfiguration config) throws DeploymentException {
        AxisModule axismodule;
        try {
            Flow faultOutFlow;
            Flow faultInFlow;
            Flow outFlow;
            ArchiveFileData currentArchiveFile = new ArchiveFileData(modulearchive, 1, false);
            axismodule = new AxisModule();
            ArchiveReader archiveReader = new ArchiveReader();
            currentArchiveFile.setClassLoader(false, config.getModuleClassLoader());
            axismodule.setModuleClassLoader(currentArchiveFile.getClassLoader());
            archiveReader.readModuleArchive(currentArchiveFile, axismodule, false, config);
            ClassLoader moduleClassLoader = axismodule.getModuleClassLoader();
            Flow inflow = axismodule.getInFlow();
            if (inflow != null) {
                Utils.addFlowHandlers(inflow, moduleClassLoader);
            }
            if ((outFlow = axismodule.getOutFlow()) != null) {
                Utils.addFlowHandlers(outFlow, moduleClassLoader);
            }
            if ((faultInFlow = axismodule.getFaultInFlow()) != null) {
                Utils.addFlowHandlers(faultInFlow, moduleClassLoader);
            }
            if ((faultOutFlow = axismodule.getFaultOutFlow()) != null) {
                Utils.addFlowHandlers(faultOutFlow, moduleClassLoader);
            }
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault);
        }
        return axismodule;
    }

    public static AxisService buildService(InputStream serviceInputStream, ClassLoader classLoader, ConfigurationContext configCtx) throws DeploymentException {
        AxisService axisService = new AxisService();
        try {
            String value;
            AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
            Parameter parahotupdate = axisConfig.getParameter("hotupdate");
            boolean antiJARLocking = true;
            if (parahotupdate != null && "false".equalsIgnoreCase(value = (String)parahotupdate.getValue())) {
                antiJARLocking = false;
            }
            ArchiveFileData currentArchiveFile = new ArchiveFileData(0, "", antiJARLocking);
            currentArchiveFile.setClassLoader(classLoader);
            ServiceBuilder builder = new ServiceBuilder(serviceInputStream, configCtx, axisService);
            builder.populateService(builder.buildOM());
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault);
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
        return axisService;
    }

    public static AxisServiceGroup buildServiceGroup(InputStream servicesxml, ClassLoader classLoader, String serviceGroupName, ConfigurationContext configCtx, ArchiveReader archiveReader, HashMap wsdlServices) throws AxisFault {
        ArchiveFileData currentArchiveFile = new ArchiveFileData(0, "", false);
        currentArchiveFile.setClassLoader(classLoader);
        AxisServiceGroup serviceGroup = new AxisServiceGroup();
        serviceGroup.setServiceGroupClassLoader(classLoader);
        serviceGroup.setServiceGroupName(serviceGroupName);
        AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
        try {
            ArrayList serviceList = archiveReader.buildServiceGroup(servicesxml, currentArchiveFile, serviceGroup, wsdlServices, configCtx);
            DeploymentEngine.fillServiceGroup(serviceGroup, serviceList, null, axisConfig);
            return serviceGroup;
        }
        catch (XMLStreamException e) {
            throw new AxisFault(e);
        }
    }

    public File getServicesDir() {
        return this.servicesDir;
    }

    public File getModulesDir() {
        return this.modulesDir;
    }
}

