/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.resource.properties.set.impl;

import javax.xml.namespace.QName;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.apache.muse.ws.resource.ext.faults.InvalidMessageFormatFault;
import org.apache.muse.ws.resource.properties.set.SetOperationFactory;
import org.apache.muse.ws.resource.properties.set.SetRequest;
import org.apache.muse.ws.resource.properties.set.impl.AbstractSetRequestComponent;
import org.apache.muse.ws.resource.properties.set.impl.DeleteRequest;
import org.apache.muse.ws.resource.properties.set.impl.InsertRequest;
import org.apache.muse.ws.resource.properties.set.impl.SimpleSetRequest;
import org.apache.muse.ws.resource.properties.set.impl.UpdateRequest;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleSetOperationFactory
implements SetOperationFactory {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$ws$resource$properties$set$impl$SimpleSetOperationFactory == null ? (class$org$apache$muse$ws$resource$properties$set$impl$SimpleSetOperationFactory = SimpleSetOperationFactory.class$("org.apache.muse.ws.resource.properties.set.impl.SimpleSetOperationFactory")) : class$org$apache$muse$ws$resource$properties$set$impl$SimpleSetOperationFactory));
    static /* synthetic */ Class class$org$apache$muse$ws$resource$properties$set$impl$SimpleSetOperationFactory;

    public SetRequest createDelete(QName qname) {
        SimpleSetRequest set = new SimpleSetRequest();
        set.addRequestComponent(new DeleteRequest(qname));
        return set;
    }

    public SetRequest createInsert(QName qname, Object[] values) {
        SimpleSetRequest set = new SimpleSetRequest();
        set.addRequestComponent(new InsertRequest(qname, values));
        return set;
    }

    public SetRequest createSet(Element request) throws BaseFault {
        if (request == null) {
            throw new NullPointerException(_MESSAGES.get("NullRequestElement"));
        }
        Element[] children = XmlUtils.getAllElements((Node)request, (String)"http://docs.oasis-open.org/wsrf/rp-2");
        if (children.length == 0) {
            throw new InvalidMessageFormatFault(_MESSAGES.get("EmptySetRequest"));
        }
        SimpleSetRequest set = new SimpleSetRequest();
        for (int n = 0; n < children.length; ++n) {
            String type = children[n].getLocalName();
            AbstractSetRequestComponent operation = null;
            if (type.equals("Delete")) {
                operation = new DeleteRequest(children[n]);
            } else if (type.equals("Insert")) {
                operation = new InsertRequest(children[n]);
            } else if (type.equals("Update")) {
                operation = new UpdateRequest(children[n]);
            } else {
                Object[] filler = new Object[]{type};
                throw new InvalidMessageFormatFault(_MESSAGES.get("InvalidSet", filler));
            }
            set.addRequestComponent(operation);
        }
        return set;
    }

    public SetRequest createUpdate(QName qname, Object[] values) {
        SimpleSetRequest set = new SimpleSetRequest();
        set.addRequestComponent(new UpdateRequest(qname, values));
        return set;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

