/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.resource.properties.schema.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.util.xml.XsdUtils;
import org.apache.muse.ws.resource.WsResourceCapability;
import org.apache.muse.ws.resource.properties.WsrpConstants;
import org.apache.muse.ws.resource.properties.schema.ResourcePropertiesSchema;
import org.apache.muse.ws.resource.properties.schema.impl.PropertySchemaDefinition;
import org.apache.muse.ws.wsdl.WsdlUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleResourcePropertiesSchema
implements ResourcePropertiesSchema {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$ws$resource$properties$schema$impl$SimpleResourcePropertiesSchema == null ? (class$org$apache$muse$ws$resource$properties$schema$impl$SimpleResourcePropertiesSchema = SimpleResourcePropertiesSchema.class$("org.apache.muse.ws.resource.properties.schema.impl.SimpleResourcePropertiesSchema")) : class$org$apache$muse$ws$resource$properties$schema$impl$SimpleResourcePropertiesSchema));
    private Map _definitionsByQName = new HashMap();
    private QName _wsrpName = WsrpConstants.DEFAULT_DOCUMENT_QNAME;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$properties$schema$impl$SimpleResourcePropertiesSchema;

    public SimpleResourcePropertiesSchema(QName wsrpName, Element wsrpElement) {
        if (wsrpName != null) {
            this._wsrpName = wsrpName;
        }
        if (wsrpElement == null) {
            throw new NullPointerException(_MESSAGES.get("NullPropertiesElement"));
        }
        QName qname = XmlUtils.getElementQName((Element)wsrpElement);
        if (!qname.equals(XsdUtils.ELEMENT_QNAME)) {
            throw new RuntimeException(_MESSAGES.get("NotAnElement"));
        }
        String name = wsrpElement.getAttribute("name");
        if (name == null || name.length() == 0) {
            throw new RuntimeException(_MESSAGES.get("NoPropertiesName"));
        }
        qname = XmlUtils.parseQName((String)name, (Element)wsrpElement);
        Element[] elements = this.getAllPropertyElements(wsrpElement);
        for (int n = 0; n < elements.length; ++n) {
            String ref = elements[n].getAttribute("ref");
            qname = XmlUtils.parseQName((String)ref, (Element)elements[n]);
            PropertySchemaDefinition definition = new PropertySchemaDefinition(qname, elements[n]);
            this._definitionsByQName.put(qname, definition);
        }
    }

    private Element[] getAllPropertyElements(Element wsrpElement) {
        Element sequence;
        Element complexType = XmlUtils.getElement((Node)wsrpElement, (QName)XsdUtils.COMPLEX_TYPE_QNAME);
        if (complexType == null) {
            Element wsdl = XmlUtils.getDocumentRoot((Node)wsrpElement);
            String typeName = wsrpElement.getAttribute("type");
            QName typeQName = XmlUtils.parseQName((String)typeName, (Element)wsrpElement);
            complexType = WsdlUtils.getComplexTypeDeclaration((Node)wsdl, (QName)typeQName);
        }
        if ((sequence = XmlUtils.getElement((Node)complexType, (QName)XsdUtils.SEQUENCE_QNAME)) != null) {
            return XmlUtils.getElements((Node)sequence, (QName)XsdUtils.ELEMENT_QNAME);
        }
        return this.getBasePropertyElements(complexType);
    }

    private Element[] getBasePropertyElements(Element complexType) {
        Element sequence = XmlUtils.getElement((Node)complexType, (QName)XsdUtils.SEQUENCE_QNAME);
        if (sequence != null) {
            return XmlUtils.getElements((Node)sequence, (QName)XsdUtils.ELEMENT_QNAME);
        }
        Element wsdl = XmlUtils.getDocumentRoot((Node)complexType);
        Element complexContent = XmlUtils.getElement((Node)complexType, (QName)XsdUtils.COMPLEX_CONTENT_QNAME);
        Element extension = XmlUtils.getElement((Node)complexContent, (QName)XsdUtils.EXTENSION_QNAME);
        String base = extension.getAttribute("base");
        QName baseName = XmlUtils.parseQName((String)base, (Element)extension);
        Element baseType = WsdlUtils.getComplexTypeDeclaration((Node)wsdl, (QName)baseName);
        Element[] baseProperties = this.getBasePropertyElements(baseType);
        sequence = XmlUtils.getElement((Node)extension, (QName)XsdUtils.SEQUENCE_QNAME);
        Element[] childProperties = XmlUtils.getElements((Node)sequence, (QName)XsdUtils.ELEMENT_QNAME);
        Element[] allProperties = new Element[baseProperties.length + childProperties.length];
        System.arraycopy(baseProperties, 0, allProperties, 0, baseProperties.length);
        System.arraycopy(childProperties, 0, allProperties, baseProperties.length, childProperties.length);
        return allProperties;
    }

    public WsResourceCapability getCapability(QName property) {
        return this.getProperty(property).getCapability();
    }

    public final synchronized QName getElementName() {
        return this._wsrpName;
    }

    public int getMaxOccurs(QName property) {
        return this.getProperty(property).getMaxOccurs();
    }

    public int getMinOccurs(QName property) {
        return this.getProperty(property).getMinOccurs();
    }

    protected PropertySchemaDefinition getProperty(QName property) {
        PropertySchemaDefinition definition = (PropertySchemaDefinition)this._definitionsByQName.get(property);
        if (definition == null) {
            Object[] filler = new Object[]{property};
            throw new RuntimeException(_MESSAGES.get("PropertyNotFound", filler));
        }
        return definition;
    }

    public Collection getPropertyNames() {
        return Collections.unmodifiableSet(this._definitionsByQName.keySet());
    }

    public QName getPropertyTypeName(QName property) {
        return this.getProperty(property).getPropertyTypeName();
    }

    public boolean hasCapability(QName property) {
        return this.getCapability(property) != null;
    }

    public boolean hasProperty(QName property) {
        return this._definitionsByQName.containsKey(property);
    }

    public boolean isMaxUnbounded(QName property) {
        return this.getProperty(property).isMaxUnbounded();
    }

    public boolean isNillable(QName property) {
        return this.getProperty(property).isNillable();
    }

    public void setCapability(QName property, WsResourceCapability capability) {
        this.getProperty(property).setCapability(capability);
    }

    public synchronized void setElementName(QName wsrpName) {
        if (wsrpName == null) {
            throw new NullPointerException(_MESSAGES.get("NullWSRPElementName"));
        }
        this._wsrpName = wsrpName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

