/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.resource.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.muse.core.AbstractCapability;
import org.apache.muse.core.Resource;
import org.apache.muse.core.serializer.Serializer;
import org.apache.muse.core.serializer.SerializerRegistry;
import org.apache.muse.util.ReflectUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.WsResourceCapability;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.apache.muse.ws.resource.basefaults.WsbfUtils;
import org.apache.muse.ws.resource.properties.ResourcePropertyCollection;
import org.w3c.dom.Element;

public abstract class AbstractWsResourceCapability
extends AbstractCapability
implements WsResourceCapability {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$ws$resource$impl$AbstractWsResourceCapability == null ? (class$org$apache$muse$ws$resource$impl$AbstractWsResourceCapability = AbstractWsResourceCapability.class$("org.apache.muse.ws.resource.impl.AbstractWsResourceCapability")) : class$org$apache$muse$ws$resource$impl$AbstractWsResourceCapability));
    private static final QName[] _NO_PROPERTIES = new QName[0];
    private static final Element[] _NO_VALUES = new Element[0];
    private Map _gettersByQName = new HashMap();
    private Map _settersByQName = new HashMap();
    static /* synthetic */ Class class$org$apache$muse$ws$resource$impl$AbstractWsResourceCapability;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$WsResource;

    protected void createGettersAndSetters(QName propertyName) {
        Class<?> theClass = ((Object)((Object)this)).getClass();
        String name = propertyName.getLocalPart();
        name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        String getName = "get" + name;
        String setName = "set" + name;
        Method getMethod = null;
        try {
            getMethod = theClass.getMethod(getName, new Class[0]);
        }
        catch (Throwable error) {
            Object[] filler = new Object[]{theClass.getName(), getName, propertyName};
            throw new RuntimeException(_MESSAGES.get("NoGetter", filler));
        }
        if (getMethod.getReturnType() == Void.TYPE) {
            Object[] filler = new Object[]{theClass.getName(), getName, propertyName};
            throw new RuntimeException(_MESSAGES.get("NoVoidGetters", filler));
        }
        this._gettersByQName.put(propertyName, getMethod);
        Method setMethod = ReflectUtils.getFirstMethod(theClass, (String)setName);
        if (setMethod != null) {
            Class<?>[] paramTypes = setMethod.getParameterTypes();
            if (paramTypes.length != 1) {
                Object[] filler = new Object[]{theClass.getName(), setName, propertyName};
                throw new RuntimeException(_MESSAGES.get("SettersOneParam", filler));
            }
            this._settersByQName.put(propertyName, setMethod);
        }
    }

    public void deleteProperty(QName propertyQName) throws BaseFault {
        Method method = this.getSetter(propertyQName);
        this.invokeMethod(method, new Object[]{null});
    }

    private Object deserializeValue(Serializer ser, Element value) throws BaseFault {
        try {
            return ser.fromXML(value);
        }
        catch (SoapFault error) {
            throw WsbfUtils.convertToFault((Throwable)error);
        }
    }

    protected Method getGetter(QName propertyQName) {
        return (Method)this._gettersByQName.get(propertyQName);
    }

    public Element[] getProperty(QName propertyQName) throws BaseFault {
        Method method = this.getGetter(propertyQName);
        Object result = this.invokeMethod(method, null);
        return this.getPropertyElements(propertyQName, result);
    }

    protected Element[] getPropertyElements(QName name, Object value) throws BaseFault {
        if (value == null) {
            ResourcePropertyCollection props = this.getWsResource().getPropertyCollection();
            if (props.getSchema().isNillable(name)) {
                return new Element[]{XmlUtils.createElement((QName)name)};
            }
            return _NO_VALUES;
        }
        Object[] valuesArray = null;
        Class<?> type = null;
        if (value.getClass().isArray()) {
            valuesArray = value;
            type = ReflectUtils.getClassFromArrayClass(value.getClass());
        } else {
            valuesArray = new Object[]{value};
            type = value.getClass();
        }
        int length = Array.getLength(valuesArray);
        Element[] properties = new Element[length];
        SerializerRegistry registry = SerializerRegistry.getInstance();
        Serializer ser = registry.getSerializer(type);
        for (int n = 0; n < length; ++n) {
            properties[n] = this.serializeValue(ser, Array.get(valuesArray, n), name);
        }
        return properties;
    }

    public QName[] getPropertyNames() {
        return _NO_PROPERTIES;
    }

    protected Method getSetter(QName propertyQName) {
        return (Method)this._settersByQName.get(propertyQName);
    }

    public WsResource getWsResource() {
        return (WsResource)this.getResource();
    }

    public void initialize() throws SoapFault {
        super.initialize();
        QName[] propertyNames = this.getPropertyNames();
        for (int n = 0; n < propertyNames.length; ++n) {
            this.createGettersAndSetters(propertyNames[n]);
        }
        ResourcePropertyCollection props = this.getWsResource().getPropertyCollection();
        props.addCapability((WsResourceCapability)this);
    }

    public void insertProperty(QName propertyQName, Element[] values) throws BaseFault {
        Element[] current = this.getProperty(propertyQName);
        Element[] all = new Element[current.length + values.length];
        System.arraycopy(current, 0, all, 0, current.length);
        System.arraycopy(values, 0, all, current.length, values.length);
        this.updateProperty(propertyQName, all);
    }

    protected Object invokeMethod(Method method, Object[] params) throws BaseFault {
        Object result = null;
        try {
            result = method.invoke((Object)this, params);
        }
        catch (Throwable error) {
            Throwable cause = error.getCause();
            if (cause != null) {
                error = cause;
            }
            throw WsbfUtils.convertToFault((Throwable)error);
        }
        return result;
    }

    private Element serializeValue(Serializer ser, Object value, QName name) throws BaseFault {
        try {
            return ser.toXML(value, name);
        }
        catch (SoapFault error) {
            throw WsbfUtils.convertToFault((Throwable)error);
        }
    }

    public void setResource(Resource resource) {
        Class<?> theClass;
        if (!(class$org$apache$muse$ws$resource$WsResource == null ? (class$org$apache$muse$ws$resource$WsResource = AbstractWsResourceCapability.class$("org.apache.muse.ws.resource.WsResource")) : class$org$apache$muse$ws$resource$WsResource).isAssignableFrom(theClass = resource.getClass())) {
            Object[] filler = new Object[]{theClass, class$org$apache$muse$ws$resource$WsResource == null ? (class$org$apache$muse$ws$resource$WsResource = AbstractWsResourceCapability.class$("org.apache.muse.ws.resource.WsResource")) : class$org$apache$muse$ws$resource$WsResource};
            throw new RuntimeException(_MESSAGES.get("NotWSRF", filler));
        }
        super.setResource(resource);
    }

    public void updateProperty(QName propertyQName, Element[] values) throws BaseFault {
        Method method = this.getSetter(propertyQName);
        if (method == null) {
            Object[] filler = new Object[]{((Object)((Object)this)).getClass(), propertyQName};
            throw new RuntimeException(_MESSAGES.get("NoSetter", filler));
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        boolean isArray = paramTypes[0].isArray();
        Object[] params = new Object[1];
        SerializerRegistry registry = SerializerRegistry.getInstance();
        if (isArray) {
            Class theClass = ReflectUtils.getClassFromArrayClass(paramTypes[0]);
            Serializer ser = registry.getSerializer(theClass);
            params[0] = Array.newInstance(theClass, values.length);
            for (int n = 0; n < values.length; ++n) {
                Array.set(params[0], n, this.deserializeValue(ser, values[n]));
            }
        } else {
            Serializer ser = registry.getSerializer(paramTypes[0]);
            params[0] = this.deserializeValue(ser, values[0]);
        }
        this.invokeMethod(method, params);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

