/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.resource.lifetime.impl;

import java.text.ParseException;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlSerializable;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.util.xml.XsdUtils;
import org.apache.muse.ws.resource.lifetime.WsrlConstants;
import org.apache.muse.ws.resource.lifetime.faults.UnableToSetTerminationTimeFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SetTerminationTime
implements XmlSerializable {
    private Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$ws$resource$lifetime$impl$SetTerminationTime == null ? (class$org$apache$muse$ws$resource$lifetime$impl$SetTerminationTime = SetTerminationTime.class$("org.apache.muse.ws.resource.lifetime.impl.SetTerminationTime")) : class$org$apache$muse$ws$resource$lifetime$impl$SetTerminationTime));
    private Date _time = null;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$lifetime$impl$SetTerminationTime;

    public SetTerminationTime(Date time) {
        this._time = time;
    }

    public SetTerminationTime(Element request) throws UnableToSetTerminationTimeFault {
        if (request == null) {
            throw new NullPointerException(this._MESSAGES.get("NullRequestElement"));
        }
        boolean isDuration = true;
        String timeString = XmlUtils.getElementText((Node)request, (QName)WsrlConstants.REQUESTED_DURATION_QNAME);
        if (timeString == null) {
            isDuration = false;
            timeString = XmlUtils.getElementText((Node)request, (QName)WsrlConstants.REQUESTED_TIME_QNAME);
        }
        if (timeString != null) {
            try {
                if (isDuration) {
                    Date rightNow = new Date();
                    long duration = XsdUtils.getDuration((String)timeString);
                    long theFuture = rightNow.getTime() + duration;
                    this._time = new Date(theFuture);
                } else {
                    this._time = XsdUtils.getLocalTime((String)timeString);
                }
            }
            catch (ParseException error) {
                Object[] filler = new Object[]{timeString, error.getMessage()};
                throw new UnableToSetTerminationTimeFault(this._MESSAGES.get("InvalidTimeValue", filler));
            }
        }
    }

    public Date getTerminationTime() {
        return this._time;
    }

    public String toString() {
        return XmlUtils.toString((Node)this.toXML(), (boolean)false);
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        if (doc == null) {
            throw new NullPointerException(this._MESSAGES.get("NullDocument"));
        }
        Element root = XmlUtils.createElement((Document)doc, (QName)WsrlConstants.SET_TERMINATION_QNAME);
        XmlUtils.setElement((Element)root, (QName)WsrlConstants.REQUESTED_TIME_QNAME, (Object)this.getTerminationTime());
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

