/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.muse.core.Capability;
import org.apache.muse.core.Environment;
import org.apache.muse.core.Resource;
import org.apache.muse.core.ResourceManager;
import org.apache.muse.core.routing.MessageHandler;
import org.apache.muse.util.LoggingUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.MessageHeaders;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.addressing.soap.SoapConstants;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.addressing.soap.SoapUtils;
import org.w3c.dom.Element;

public class SimpleResource
implements Resource {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$core$SimpleResource == null ? (class$org$apache$muse$core$SimpleResource = SimpleResource.class$("org.apache.muse.core.SimpleResource")) : class$org$apache$muse$core$SimpleResource));
    private Map _capabilitiesByAction = new HashMap();
    private Map _capabilitiesByURI = new LinkedHashMap();
    private String _contextPath = null;
    private Environment _environment = null;
    private EndpointReference _epr = null;
    private boolean _hasBeenInitialized = false;
    private boolean _hasBeenShutdown = false;
    private Logger _log = null;
    private ResourceManager _manager = null;
    private Map _parameters = Collections.EMPTY_MAP;
    private String _wsdlPath = null;
    private QName _wsdlPortType = null;
    static /* synthetic */ Class class$org$apache$muse$core$SimpleResource;

    public void addCapability(Capability capability) {
        if (capability == null) {
            throw new RuntimeException(_MESSAGES.get("NullCapability"));
        }
        capability.setResource(this);
        capability.setLog(this.getLog());
        capability.setEnvironment(this.getEnvironment());
        String uri = capability.getCapabilityURI();
        if (this._capabilitiesByURI.containsKey(uri)) {
            Object[] filler = new Object[]{this.getContextPath(), uri};
            throw new RuntimeException(_MESSAGES.get("DuplicateCapabilityURI", filler));
        }
        this._capabilitiesByURI.put(uri, capability);
        Iterator i = capability.getActions().iterator();
        while (i.hasNext()) {
            String action = (String)i.next();
            if (this._capabilitiesByAction.containsKey(action)) {
                Capability duplicate = (Capability)this._capabilitiesByAction.get(action);
                Object[] filler = new Object[]{this.getContextPath(), action, duplicate.getCapabilityURI()};
                throw new RuntimeException(_MESSAGES.get("DuplicateAction", filler));
            }
            this._capabilitiesByAction.put(action, capability);
        }
    }

    public final Capability getCapability(String capabilityURI) {
        return (Capability)this._capabilitiesByURI.get(capabilityURI);
    }

    protected Collection getCapabilityActions() {
        return Collections.unmodifiableSet(this._capabilitiesByAction.keySet());
    }

    protected Capability getCapabilityForAction(String action) {
        return (Capability)this._capabilitiesByAction.get(action);
    }

    public final Collection getCapabilityURIs() {
        return Collections.unmodifiableSet(this._capabilitiesByURI.keySet());
    }

    public final String getContextPath() {
        return this._contextPath;
    }

    public EndpointReference getEndpointReference() {
        return this._epr;
    }

    public final Environment getEnvironment() {
        return this._environment;
    }

    public final String getInitializationParameter(String name) {
        return (String)this.getInitializationParameters().get(name);
    }

    public final Map getInitializationParameters() {
        return this._parameters;
    }

    public final Logger getLog() {
        return this._log;
    }

    public ResourceManager getResourceManager() {
        return this._manager;
    }

    public final String getWsdlPath() {
        return this._wsdlPath;
    }

    public final QName getWsdlPortType() {
        return this._wsdlPortType;
    }

    public final boolean hasBeenInitialized() {
        return this._hasBeenInitialized;
    }

    public final boolean hasBeenShutdown() {
        return this._hasBeenShutdown;
    }

    public final boolean hasCapability(String capabilityURI) {
        return this.getCapability(capabilityURI) != null;
    }

    public void initialize() throws SoapFault {
        if (this.getLog() == null) {
            throw new IllegalStateException(_MESSAGES.get("NoLogger"));
        }
        if (this.getEnvironment() == null) {
            throw new IllegalStateException(_MESSAGES.get("NoEnvironment"));
        }
        if (this.getResourceManager() == null) {
            throw new IllegalStateException(_MESSAGES.get("NoResourceManager"));
        }
        if (this.getContextPath() == null) {
            throw new IllegalStateException(_MESSAGES.get("NoContextPath"));
        }
        if (this.getWsdlPath() == null) {
            throw new IllegalStateException(_MESSAGES.get("NoWSDLPath"));
        }
        if (this.getWsdlPortType() == null) {
            throw new IllegalStateException(_MESSAGES.get("NoWSDLPortType"));
        }
        this.initializeCapabilities();
        Object[] filler = new Object[]{this.getContextPath()};
        String message = _MESSAGES.get("ResourceInitialized", filler);
        this.getLog().info(message);
        this._hasBeenInitialized = true;
    }

    protected void initializeCapabilities() throws SoapFault {
        Object[] filler;
        Capability next;
        String nextURI;
        String contextPath = this.getContextPath();
        Logger log = this.getLog();
        Iterator i = this.getCapabilityURIs().iterator();
        while (i.hasNext()) {
            nextURI = (String)i.next();
            next = this.getCapability(nextURI);
            next.initialize();
            filler = new Object[]{contextPath, nextURI};
            log.fine(_MESSAGES.get("CapabilityInitialized", filler));
        }
        i = this.getCapabilityURIs().iterator();
        while (i.hasNext()) {
            nextURI = (String)i.next();
            next = this.getCapability(nextURI);
            next.initializeCompleted();
            filler = new Object[]{contextPath, nextURI};
            log.fine(_MESSAGES.get("CapabilityInitializationComplete", filler));
        }
    }

    public Element invoke(Element soapBody) {
        MessageHeaders wsa = this.getEnvironment().getAddressingContext();
        String action = wsa.getAction();
        Capability capability = this.getCapabilityForAction(action);
        if (capability == null) {
            Object[] filler = new Object[]{this.getContextPath(), action};
            SoapFault wsaFault = new SoapFault(_MESSAGES.get("ActionNotSupported", filler));
            wsaFault.setCode(SoapConstants.SENDER_QNAME);
            wsaFault.setSubCode(WsaConstants.ACTION_NOT_SUPPORTED_FAULT_QNAME);
            Element detail = XmlUtils.createElement((QName)WsaConstants.PROBLEM_ACTION_QNAME);
            XmlUtils.setElement((Element)detail, (QName)WsaConstants.ACTION_QNAME, (Object)action);
            wsaFault.setDetail(detail);
            return wsaFault.toXML();
        }
        MessageHandler handler = capability.getMessageHandler(action);
        Method method = handler.getMethod();
        Object[] parameters = null;
        try {
            parameters = handler.fromXML(soapBody);
            Object result = method.invoke((Object)capability, parameters);
            return handler.toXML(result);
        }
        catch (Throwable error) {
            Throwable cause = error.getCause();
            if (cause != null) {
                error = cause;
            }
            Logger log = this.getLog();
            if (parameters != null) {
                LoggingUtils.logCall((Logger)log, (Method)method, (Object[])parameters);
            }
            LoggingUtils.logError((Logger)log, (Throwable)error);
            SoapFault response = SoapUtils.convertToFault((Throwable)error);
            return response.toXML();
        }
    }

    public final void setContextPath(String contextPath) {
        if (contextPath == null) {
            throw new NullPointerException(_MESSAGES.get("NullContextPath"));
        }
        this._contextPath = contextPath;
    }

    public final void setEndpointReference(EndpointReference epr) {
        if (this._epr != null && this.hasBeenInitialized()) {
            throw new RuntimeException(_MESSAGES.get("ExistingResourceEPR"));
        }
        this._epr = epr;
    }

    public final void setEnvironment(Environment environment) {
        if (environment == null) {
            throw new NullPointerException(_MESSAGES.get("NullEnvironment"));
        }
        this._environment = environment;
    }

    public final void setInitializationParameters(Map parameters) {
        if (parameters == null) {
            parameters = Collections.EMPTY_MAP;
        }
        this._parameters = parameters;
    }

    public final void setLog(Logger log) {
        if (log == null) {
            throw new NullPointerException(_MESSAGES.get("NullLogger"));
        }
        this._log = log;
    }

    public void setResourceManager(ResourceManager manager) {
        if (manager == null) {
            throw new NullPointerException(_MESSAGES.get("NullResourceManager"));
        }
        this._manager = manager;
    }

    public final void setWsdlPath(String wsdlPath) {
        if (wsdlPath == null) {
            throw new NullPointerException(_MESSAGES.get("NullWsdlPath"));
        }
        this._wsdlPath = wsdlPath;
    }

    public final void setWsdlPortType(QName wsdlPortType) {
        if (wsdlPortType == null) {
            throw new NullPointerException(_MESSAGES.get("NullWsdlPortType"));
        }
        this._wsdlPortType = wsdlPortType;
    }

    public synchronized void shutdown() throws SoapFault {
        if (this.hasBeenShutdown()) {
            throw new SoapFault(_MESSAGES.get("ResourceAlreadyDestroyed"));
        }
        if (!this.hasBeenInitialized()) {
            throw new SoapFault(_MESSAGES.get("ResourceNotInitialized"));
        }
        this._hasBeenShutdown = true;
        this.shutdownCapabilities();
        ResourceManager manager = this.getResourceManager();
        if (manager.getResource(this._epr) != null) {
            manager.removeResource(this._epr);
        }
        this._epr = null;
        this._environment = null;
        this._log.info(_MESSAGES.get("ResourceDestroyed", new Object[]{this._contextPath}));
        this._contextPath = null;
        this._log = null;
    }

    protected void shutdownCapabilities() throws SoapFault {
        Object[] filler;
        Capability next;
        String nextURI;
        String contextPath = this.getContextPath();
        Logger log = this.getLog();
        Iterator i = this.getCapabilityURIs().iterator();
        while (i.hasNext()) {
            nextURI = (String)i.next();
            next = this.getCapability(nextURI);
            next.prepareShutdown();
            filler = new Object[]{contextPath, nextURI};
            log.fine(_MESSAGES.get("CapabilityPreparedForShutdown", filler));
        }
        i = this.getCapabilityURIs().iterator();
        while (i.hasNext()) {
            nextURI = (String)i.next();
            next = this.getCapability(nextURI);
            next.shutdown();
            filler = new Object[]{contextPath, nextURI};
            log.fine(_MESSAGES.get("CapabilityShutdown", filler));
        }
    }

    public String toString() {
        return this.getEndpointReference().toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

