/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.muse.core.Capability;
import org.apache.muse.core.Environment;
import org.apache.muse.core.Persistence;
import org.apache.muse.core.Resource;
import org.apache.muse.core.ResourceManager;
import org.apache.muse.core.routing.MessageHandler;
import org.apache.muse.ws.addressing.soap.SoapFault;

public abstract class AbstractCapability
implements Capability {
    private String _capabilityURI = null;
    private Environment _environment = null;
    private Map _handlersByAction = new HashMap();
    private boolean _hasBeenInitialized = false;
    private boolean _hasBeenShutdown = false;
    private Logger _log = null;
    private Map _parameters = null;
    private Persistence _persistence = null;
    private Resource _resource = null;

    public Collection getActions() {
        return Collections.unmodifiableSet(this._handlersByAction.keySet());
    }

    public String getCapabilityURI() {
        return this._capabilityURI;
    }

    public Environment getEnvironment() {
        return this._environment;
    }

    public String getInitializationParameter(String name) {
        return (String)this.getInitializationParameters().get(name);
    }

    public Map getInitializationParameters() {
        return this._parameters;
    }

    public Logger getLog() {
        return this._log;
    }

    public MessageHandler getMessageHandler(String action) {
        return (MessageHandler)this._handlersByAction.get(action);
    }

    public Persistence getPersistence() {
        return this._persistence;
    }

    public Resource getResource() {
        return this._resource;
    }

    public boolean hasBeenInitialized() {
        return this._hasBeenInitialized;
    }

    public boolean hasBeenShutdown() {
        return this._hasBeenShutdown;
    }

    public void initialize() throws SoapFault {
        this._hasBeenInitialized = true;
    }

    public void initializeCompleted() throws SoapFault {
        Persistence persistence = this.getPersistence();
        if (persistence != null) {
            ResourceManager manager = this.getResource().getResourceManager();
            persistence.setResourceManager(manager);
            persistence.reload();
        }
    }

    public void prepareShutdown() throws SoapFault {
    }

    public void setCapabilityURI(String capabilityURI) {
        this._capabilityURI = capabilityURI;
    }

    public void setEnvironment(Environment environment) {
        this._environment = environment;
    }

    public void setInitializationParameters(Map parameters) {
        this._parameters = parameters;
    }

    public void setLog(Logger log) {
        this._log = log;
    }

    protected void setMessageHandler(MessageHandler handler) {
        this._handlersByAction.put(handler.getAction(), handler);
    }

    public void setMessageHandlers(Collection handlers) {
        Iterator i = handlers.iterator();
        while (i.hasNext()) {
            this.setMessageHandler((MessageHandler)i.next());
        }
    }

    public void setPersistence(Persistence persistence) {
        this._persistence = persistence;
    }

    public void setResource(Resource resource) {
        this._resource = resource;
    }

    public void shutdown() throws SoapFault {
        this._hasBeenShutdown = true;
    }
}

