/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.platform.osgi.mini.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.muse.core.platform.mini.MiniEnvironment;
import org.apache.muse.core.platform.osgi.OSGiEnvironment;
import org.apache.muse.core.platform.osgi.util.BundleRootHelper;
import org.apache.muse.core.platform.osgi.util.OSGiReflectUtilHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OSGiMiniEnvironment
extends MiniEnvironment
implements OSGiEnvironment {
    private static BundleContext bundleContext;
    private InheritableThreadLocal localEnvironmentContext = new InheritableThreadLocal();

    public File getRealDirectory() {
        File root;
        Bundle bundle = this.getThreadLocalBundle();
        if (bundle != null && (root = BundleRootHelper.getRootForBundle((Bundle)bundle)) != null) {
            return root;
        }
        return super.getRealDirectory();
    }

    public Bundle getThreadLocalBundle() {
        return (Bundle)this.localEnvironmentContext.get();
    }

    public void setThreadLocalBundle(Bundle bundle) {
        this.localEnvironmentContext.set(bundle);
        OSGiReflectUtilHelper.getDefault().setThreadLocalBundle(bundle);
    }

    public InputStream getDataResourceStream(String path) {
        URL url;
        if (path == null) {
            throw new NullPointerException("Resource path is null.");
        }
        InputStream input = null;
        Bundle bundle = this.getThreadLocalBundle();
        if (bundle != null && (url = bundle.getResource(path)) != null) {
            try {
                input = url.openStream();
            }
            catch (IOException ioe) {
                input = null;
            }
        }
        if (input == null) {
            input = ((Object)((Object)this)).getClass().getResourceAsStream(path);
        }
        if (input == null) {
            input = ((Object)((Object)this)).getClass().getResourceAsStream("/OSGI-INF/" + path);
        }
        if (input == null) {
            input = OSGiReflectUtilHelper.getDefault().getResource(path);
        }
        if (input == null && bundle != null) {
            try {
                File file = BundleRootHelper.getRootForBundle((Bundle)bundle);
                File lastTry = new File(file.getAbsolutePath() + "/" + path);
                input = new FileInputStream(lastTry);
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getMessage(), t);
            }
        }
        return input;
    }

    public OSGiMiniEnvironment(HttpServletRequest httpRequest, ServletContext servletContext) {
        super(httpRequest, servletContext);
    }
}

