/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.platform.osgi.mini;

import java.util.Hashtable;
import org.apache.muse.core.platform.osgi.mini.internal.ResourceManagementAdminServiceImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class Activator
implements BundleActivator,
ServiceListener {
    private BundleContext context;
    private ServiceReference httpServiceReference = null;
    private ResourceManagementAdminServiceImpl adminService;
    private boolean enabled = false;
    private static final String HTTP_SERVICE_FILTER = "(objectclass=org.osgi.service.http.HttpService)";

    public void start(BundleContext context) throws Exception {
        this.context = context;
        try {
            this.httpServiceReference = context.getServiceReference("org.osgi.service.http.HttpService");
            if (this.httpServiceReference != null) {
                this.adminService = new ResourceManagementAdminServiceImpl(context, this.httpServiceReference);
                context.registerService("org.apache.muse.core.platform.osgi.ResourceManagementProvider", (Object)this.adminService, new Hashtable());
                this.enabled = true;
            }
            context.addServiceListener((ServiceListener)this, HTTP_SERVICE_FILTER);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BundleException("Failed to start server");
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.httpServiceReference != null) {
            context.ungetService(this.httpServiceReference);
            this.httpServiceReference = null;
        }
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference ref = event.getServiceReference();
        switch (event.getType()) {
            case 1: {
                if (this.enabled) break;
                try {
                    this.httpServiceReference = this.context.getServiceReference("org.osgi.service.http.HttpService");
                    if (this.httpServiceReference == null) break;
                    this.adminService = new ResourceManagementAdminServiceImpl(this.context, this.httpServiceReference);
                    this.context.registerService("org.apache.muse.core.platform.osgi.ResourceManagementProvider", (Object)this.adminService, new Hashtable());
                    this.enabled = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                if (ref != this.httpServiceReference) break;
                this.enabled = false;
            }
        }
    }
}

