/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.platform.mini;

import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.muse.core.Environment;
import org.apache.muse.core.platform.AbstractIsolationLayer;
import org.apache.muse.core.platform.mini.MiniEnvironment;
import org.apache.muse.core.routing.ResourceRouter;
import org.apache.muse.util.LoggingUtils;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.MessageHeaders;
import org.apache.muse.ws.addressing.soap.SoapConstants;
import org.apache.muse.ws.addressing.soap.SoapUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MiniIsolationLayer
extends AbstractIsolationLayer {
    private ServletContext _initialContext = null;
    private HttpServletRequest _initialRequest = null;

    public MiniIsolationLayer(HttpServletRequest initialRequest, ServletContext initialContext) {
        this._initialRequest = initialRequest;
        this._initialContext = initialContext;
    }

    protected Environment createEnvironment() {
        return new MiniEnvironment(this.getInitialRequest(), this.getInitialContext());
    }

    protected ServletContext getInitialContext() {
        return this._initialContext;
    }

    protected HttpServletRequest getInitialRequest() {
        return this._initialRequest;
    }

    public Document handleRequest(Document request) {
        Element soap = XmlUtils.getFirstElement((Node)request);
        Element header = XmlUtils.getElement((Node)soap, (QName)SoapConstants.HEADER_QNAME);
        Element body = XmlUtils.getElement((Node)soap, (QName)SoapConstants.BODY_QNAME);
        if (header == null) {
            throw new RuntimeException("Invalid SOAP envelope: no header element.");
        }
        if (body == null) {
            throw new RuntimeException("Invalid SOAP envelope: no body element.");
        }
        Element requestData = XmlUtils.getFirstElement((Node)body);
        ResourceRouter router = this.getRouter();
        Environment env = router.getEnvironment();
        MessageHeaders addressing = null;
        try {
            addressing = new MessageHeaders(header);
            env.addAddressingContext(addressing);
        }
        catch (Throwable error) {
            LoggingUtils.logError((Logger)router.getLog(), (Throwable)error);
        }
        if (!this.hasFailedToInitialize()) {
            LoggingUtils.logMessage((Logger)router.getLog(), (Node)request, (boolean)true);
        }
        Element result = router.invoke(requestData);
        MessageHeaders replyAddressing = null;
        replyAddressing = SoapUtils.isFault((Element)result) ? addressing.createFaultHeaders() : addressing.createReplyHeaders();
        env.removeAddressingContext();
        Element replyXML = replyAddressing.toXML();
        Element[] children = XmlUtils.getAllElements((Node)replyXML);
        Document response = XmlUtils.createDocument();
        soap = XmlUtils.createElement((Document)response, (QName)SoapConstants.ENVELOPE_QNAME);
        response.appendChild(soap);
        header = XmlUtils.createElement((Document)response, (QName)SoapConstants.HEADER_QNAME);
        soap.appendChild(header);
        for (int n = 0; n < children.length; ++n) {
            Node next = response.importNode(children[n], true);
            header.appendChild(next);
        }
        body = XmlUtils.createElement((Document)response, (QName)SoapConstants.BODY_QNAME);
        soap.appendChild(body);
        result = (Element)response.importNode(result, true);
        body.appendChild(result);
        if (!this.hasFailedToInitialize()) {
            LoggingUtils.logMessage((Logger)router.getLog(), (Node)response, (boolean)false);
        }
        return response;
    }
}

