/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.platform.osgi.axis2.internal;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.soap.SOAPException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.muse.core.platform.osgi.ResourceManagementProvider;
import org.apache.muse.core.platform.osgi.axis2.internal.Axis2ResourceManagementService;
import org.apache.muse.osgi.soa.core.SOAPProvider;
import org.apache.muse.osgi.soa.core.web.WebApp;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ResourceManagementAdminServiceImpl
implements ResourceManagementProvider {
    public static final String DEFAULT_CONTEXT = "management";
    private BundleContext context;
    private Bundle bundle;
    private SOAPProvider provider;

    public ResourceManagementAdminServiceImpl(BundleContext context, SOAPProvider provider) {
        this.context = context;
        this.provider = provider;
    }

    public void intializeContext(Bundle bundle, String contextPath) throws Exception {
        WebApp webApp = null;
        if (contextPath != null) {
            webApp = this.provider.getWebApp(bundle, contextPath, true);
        }
    }

    public void deployManagementService(Bundle bundle, String homeName, String wsdlPath) throws SOAPException {
        this.deployManagementService(bundle, DEFAULT_CONTEXT, homeName);
    }

    public void deployManagementService(Bundle bundle, String contextPath, String srvName, String wsdlPath) throws SOAPException {
        WebApp webApp = null;
        if (contextPath != null) {
            try {
                webApp = this.provider.getWebApp(bundle, contextPath, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            ConfigurationContext context = (ConfigurationContext)this.provider.getProviderDeployer(webApp);
            AxisConfiguration axisConfig = context.getAxisConfiguration();
            Axis2ResourceManagementService service = new Axis2ResourceManagementService(axisConfig);
            service.setName(srvName);
            service.setWSDLPath(wsdlPath);
            service.setBundle(bundle);
            service.setScope("application");
            try {
                service.setFileName(new URL("file", contextPath, srvName));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            axisConfig.addService((AxisService)service);
        }
        catch (AxisFault se) {
            se.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

