/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.platform.osgi.axis2.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.muse.core.platform.osgi.axis2.internal.OSGiRawXMLInOutMessageReceiver;
import org.osgi.framework.Bundle;

public class Axis2ResourceManagementService
extends AxisService {
    private AxisOperation isolationLayerOperation = new InOutAxisOperation();
    private String wsdlPath;
    private Bundle bundle;

    public Axis2ResourceManagementService(AxisConfiguration axisConfig) {
        this.isolationLayerOperation.setName(new QName("handleRequest"));
        this.isolationLayerOperation.setMessageReceiver((MessageReceiver)new OSGiRawXMLInOutMessageReceiver());
        Parameter sendStackTrace = axisConfig.getParameter("sendStacktraceDetailsWithFaults");
        if (sendStackTrace == null) {
            sendStackTrace = new Parameter("sendStacktraceDetailsWithFaults", (Object)new Boolean(false));
        }
        try {
            this.isolationLayerOperation.addParameter(sendStackTrace);
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
    }

    public AxisOperation getOperation(QName operationName) {
        AxisOperation axisOperation = super.getOperation(operationName);
        if (axisOperation == null) {
            axisOperation = this.isolationLayerOperation;
        }
        return axisOperation;
    }

    public void setWSDLPath(String wsdlPath) {
        this.wsdlPath = wsdlPath;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void printWSDL(OutputStream out, String requestIP, String servicePath) throws AxisFault {
        if (this.wsdlPath == null || this.bundle == null) throw new AxisFault("Wsdl not found for " + servicePath);
        try {
            URL wsdlURL = this.bundle.getResource(this.wsdlPath);
            if (wsdlURL == null) return;
            InputStream stream = wsdlURL.openStream();
            byte[] buffer = new byte[512];
            int read = 0;
            while ((read = stream.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            return;
        }
        catch (Throwable t) {
            throw new AxisFault("Wsdl not found for " + servicePath);
        }
    }
}

