/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.platform.osgi.axis2;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.context.MessageContext;
import org.apache.muse.core.platform.axis2.AxisEnvironment;
import org.apache.muse.core.platform.osgi.OSGiEnvironment;
import org.apache.muse.core.platform.osgi.util.BundleRootHelper;
import org.apache.muse.core.platform.osgi.util.OSGiReflectUtilHelper;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.MessageHeaders;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Axis2Environment
extends AxisEnvironment
implements OSGiEnvironment {
    private static Messages _MESSAGES = MessagesFactory.get((Object)(class$org$apache$muse$core$platform$osgi$axis2$Axis2Environment == null ? (class$org$apache$muse$core$platform$osgi$axis2$Axis2Environment = Axis2Environment.class$("org.apache.muse.core.platform.osgi.axis2.Axis2Environment")) : class$org$apache$muse$core$platform$osgi$axis2$Axis2Environment));
    private static final String _REQUEST_PROPERTY = "transport.http.servletRequest";
    private static final String _SEC_PROPERTY = "servletEndpointContext";
    private File _realDirectory = null;
    private boolean backLevelServletAPI = false;
    private static BundleContext bundleContext;
    private InheritableThreadLocal localEnvironmentContext = new InheritableThreadLocal();
    static /* synthetic */ Class class$org$apache$muse$core$platform$osgi$axis2$Axis2Environment;

    public static void setBundleContext(BundleContext context) {
        bundleContext = context;
    }

    public Bundle getThreadLocalBundle() {
        return (Bundle)this.localEnvironmentContext.get();
    }

    public void setThreadLocalBundle(Bundle bundle) {
        this.localEnvironmentContext.set(bundle);
        OSGiReflectUtilHelper.getDefault().setThreadLocalBundle(bundle);
    }

    public Axis2Environment() {
        MessageHeaders wsa = this.convertContext();
        this.addAddressingContext(wsa);
        String address = wsa.getToAddress().getAddress().toString();
        this.setDefaultURI(this.getDeploymentURI(address));
        this.backLevelServletAPI = true;
        MessageContext message = MessageContext.getCurrentMessageContext();
        this._realDirectory = message.getConfigurationContext().getRealPath("/");
    }

    public EndpointReference getDeploymentEPR() {
        return super.getDeploymentEPR();
    }

    public String getDefaultURI() {
        String defaultURI = super.getDefaultURI();
        OSGiReflectUtilHelper helper = OSGiReflectUtilHelper.getDefault();
        Bundle bundle = helper.getThreadLocalBundle();
        String context = BundleRootHelper.getContextForBundle((Bundle)bundle);
        if (context != null && defaultURI != null) {
            int first = defaultURI.indexOf("/", 8);
            defaultURI = defaultURI.substring(0, first + 1);
            defaultURI = defaultURI + context + "/services/blah";
        }
        return defaultURI;
    }

    protected URI getDeploymentURI(HttpServletRequest request) {
        String urlWithHostName = null;
        String ip = null;
        String eprContext = null;
        Bundle bundle = this.getThreadLocalBundle();
        if (bundle != null) {
            eprContext = (String)bundle.getHeaders().get("MUSE-CONTEXT");
        }
        String portString = "";
        int serverPort = request.getServerPort();
        if (serverPort != 80) {
            portString = ":" + Integer.toString(serverPort, 10);
        }
        if (!this.backLevelServletAPI) {
            urlWithHostName = request.getRequestURL().toString();
        } else {
            urlWithHostName = request.getRequestURI().toString();
            String pathInfo = request.getPathInfo();
            String reqURI = request.getRequestURI();
            urlWithHostName = "http://blah" + portString + urlWithHostName;
        }
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
            if (portString.length() > 0) {
                ip = ip.concat(portString);
            }
        }
        catch (UnknownHostException error) {
            throw new RuntimeException(error);
        }
        int start = urlWithHostName.indexOf("://") + 3;
        int end = urlWithHostName.indexOf(47, start);
        int port = urlWithHostName.indexOf(58, start);
        if (port >= 0 && port < end) {
            end = port;
        }
        StringBuffer urlWithIP = new StringBuffer(urlWithHostName.length());
        urlWithIP.append(urlWithHostName.substring(0, start));
        urlWithIP.append(ip);
        if (eprContext == null) {
            urlWithIP.append(urlWithHostName.substring(end));
        } else {
            urlWithIP.append("/" + eprContext);
            int servicesStart = urlWithHostName.indexOf("/services/");
            urlWithIP.append(urlWithHostName.substring(servicesStart));
        }
        return URI.create(urlWithIP.toString());
    }

    public File getRealDirectory() {
        File root;
        Bundle bundle = this.getThreadLocalBundle();
        if (bundle != null && (root = BundleRootHelper.getRootForBundle((Bundle)bundle)) != null) {
            return root;
        }
        return this._realDirectory;
    }

    public URL getDataResource(String path) {
        if (path == null) {
            throw new NullPointerException(_MESSAGES.get("NullResourcePath"));
        }
        File file = new File(this._realDirectory, path);
        try {
            return file.toURL();
        }
        catch (MalformedURLException error) {
            throw new RuntimeException(error);
        }
    }

    public InputStream getDataResourceStream(String path) {
        URL url;
        if (path == null) {
            throw new NullPointerException("NullResourcePath");
        }
        InputStream input = null;
        Bundle bundle = this.getThreadLocalBundle();
        if (bundle != null && (url = bundle.getResource(path)) != null) {
            try {
                input = url.openStream();
            }
            catch (IOException ioe) {
                input = null;
            }
        }
        if (input == null) {
            input = ((Object)((Object)this)).getClass().getResourceAsStream(path);
        }
        if (input == null) {
            input = ((Object)((Object)this)).getClass().getResourceAsStream("/OSGI-INF/" + path);
        }
        if (input == null) {
            input = OSGiReflectUtilHelper.getDefault().getResource(path);
        }
        if (input == null && bundle != null) {
            try {
                File file = BundleRootHelper.getRootForBundle((Bundle)bundle);
                File lastTry = new File(file.getAbsolutePath() + "/" + path);
                input = new FileInputStream(lastTry);
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getMessage(), t);
            }
        }
        return input;
    }

    protected File createRealDirectoryFromContext() {
        return null;
    }

    protected File createRealDirectory() {
        return bundleContext.getDataFile("");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

