/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.platform.axis2;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.muse.core.Environment;
import org.apache.muse.core.platform.AbstractIsolationLayer;
import org.apache.muse.core.platform.axis2.AxisEnvironment;
import org.apache.muse.core.routing.ResourceRouter;
import org.apache.muse.util.LoggingUtils;
import org.apache.muse.ws.addressing.MessageHeaders;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AxisIsolationLayer
extends AbstractIsolationLayer {
    protected Environment createEnvironment() {
        return new AxisEnvironment();
    }

    public final OMElement handleRequest(OMElement request) {
        if (!this.hasBeenInitialized()) {
            this.initialize();
        }
        Element soapResponse = null;
        soapResponse = this.hasFailedToInitialize() ? this.getCauseOfFailure().toXML() : this.invoke(request);
        if (soapResponse == null) {
            return null;
        }
        AxisEnvironment env = (AxisEnvironment)this.getRouter().getEnvironment();
        return env.convertToAxiom(soapResponse);
    }

    public Element invoke(OMElement request) {
        ResourceRouter router = this.getRouter();
        AxisEnvironment env = (AxisEnvironment)router.getEnvironment();
        if (router.getLog().getLevel() == Level.FINE) {
            SOAPEnvelope soap = MessageContext.getCurrentMessageContext().getEnvelope();
            Element soapAsDOM = env.convertToDOM((OMElement)soap);
            LoggingUtils.logMessage((Logger)router.getLog(), (Node)soapAsDOM, (boolean)true);
        }
        MessageHeaders wsa = env.convertContext();
        env.addAddressingContext(wsa);
        Element soapBody = null;
        if (request != null) {
            soapBody = env.convertToDOM(request);
        }
        Element soapResponse = this.getRouter().invoke(soapBody);
        env.removeAddressingContext();
        return soapResponse;
    }
}

