/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.platform.axis2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.context.MessageContext;
import org.apache.muse.core.AbstractEnvironment;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.MessageHeaders;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AxisEnvironment
extends AbstractEnvironment {
    private static final String _CLASSES = "classes";
    private File _realDirectory = null;

    public MessageHeaders convertContext() {
        MessageContext context = MessageContext.getCurrentMessageContext();
        SOAPHeader axiom = context.getEnvelope().getHeader();
        Element dom = this.convertToDOM((OMElement)axiom);
        try {
            return new MessageHeaders(dom);
        }
        catch (SoapFault error) {
            throw new RuntimeException(error.getMessage(), error);
        }
    }

    public EndpointReference convertEPR(org.apache.axis2.addressing.EndpointReference axisEPR) {
        URI address = URI.create(axisEPR.getAddress());
        EndpointReference epr = new EndpointReference(address);
        Map parameters = axisEPR.getAllReferenceParameters();
        Iterator i = parameters.keySet().iterator();
        while (i.hasNext()) {
            QName name = (QName)i.next();
            OMElement axiomValue = (OMElement)parameters.get(name);
            Element domValue = this.convertToDOM(axiomValue);
            epr.addParameter(domValue);
        }
        return epr;
    }

    public OMElement convertToAxiom(Element xml) {
        String xmlString = XmlUtils.toString((Node)xml, (boolean)false);
        byte[] xmlBytes = xmlString.getBytes();
        StAXOMBuilder builder = null;
        try {
            builder = new StAXOMBuilder((InputStream)new ByteArrayInputStream(xmlBytes));
        }
        catch (XMLStreamException error) {
            throw new RuntimeException(error.getMessage(), error);
        }
        return builder.getDocumentElement();
    }

    public Element convertToDOM(OMElement axiom) {
        Element dom = XmlUtils.createElement((QName)axiom.getQName());
        String text = axiom.getText();
        if (text != null && text.length() > 0) {
            XmlUtils.setElementText((Element)dom, (String)axiom.getText());
        }
        Iterator i = axiom.getAllAttributes();
        while (i.hasNext()) {
            OMAttribute attr = (OMAttribute)i.next();
            QName qname = attr.getQName();
            String value = attr.getAttributeValue();
            dom.setAttributeNS(qname.getNamespaceURI(), qname.getLocalPart(), value);
        }
        i = axiom.getAllDeclaredNamespaces();
        String domURI = dom.getNamespaceURI();
        while (i.hasNext()) {
            OMNamespace ns = (OMNamespace)i.next();
            String prefix = ns.getPrefix();
            String uri = ns.getNamespaceURI();
            if (uri.equals(domURI)) continue;
            XmlUtils.setNamespaceAttribute((Element)dom, (String)prefix, (String)uri);
        }
        i = axiom.getChildElements();
        while (i.hasNext()) {
            Element child = this.convertToDOM((OMElement)i.next());
            dom.appendChild(child);
        }
        return dom;
    }

    protected File createRealDirectory() {
        MessageContext context = MessageContext.getCurrentMessageContext();
        String axisServicePath = context.getAxisService().getFileName().getFile();
        File axisServiceDir = new File(axisServicePath);
        File webInfDir = axisServiceDir.getParentFile().getParentFile();
        return new File(webInfDir, _CLASSES);
    }

    public AxisEnvironment() {
        MessageHeaders wsa = this.convertContext();
        this.addAddressingContext(wsa);
        MessageContext context = MessageContext.getCurrentMessageContext();
        String address = context.getTo().getAddress();
        this.setDefaultURI(this.getDeploymentURI(address));
        this._realDirectory = this.createRealDirectory();
    }

    public EndpointReference getDeploymentEPR() {
        return this.getDefaultEPR();
    }

    public File getRealDirectory() {
        return this._realDirectory;
    }
}

