/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.apache.muse.util.ReflectUtilHelper;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;

public class ReflectUtils {
    private static final ClassLoader _DEFAULT_CLASS_LOADER;
    private static ReflectUtilHelper _helper;
    private static Messages _MESSAGES;
    static /* synthetic */ Class class$org$apache$muse$util$ReflectUtils;

    public static boolean exists(String className) {
        if (_helper != null) {
            return _helper.exists(className);
        }
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException error) {
            return false;
        }
    }

    public static boolean exists(String className, ClassLoader classLoader) {
        try {
            classLoader.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException error) {
            return false;
        }
    }

    public static Class getArrayClassFromClass(Class theClass) {
        if (theClass.isArray()) {
            return theClass;
        }
        return Array.newInstance(theClass, 0).getClass();
    }

    public static Class getClass(String className) {
        Class clazz;
        if (_helper != null && (clazz = _helper.getClass(className)) != null) {
            return clazz;
        }
        return ReflectUtils.getClass(className, _DEFAULT_CLASS_LOADER);
    }

    public static Class getClass(String className, ClassLoader classLoader) {
        try {
            return classLoader.loadClass(className);
        }
        catch (Throwable error) {
            Class clzz;
            if (_helper != null && (clzz = _helper.getClass(className)) != null) {
                return clzz;
            }
            if (classLoader != _DEFAULT_CLASS_LOADER) {
                try {
                    return _DEFAULT_CLASS_LOADER.loadClass(className);
                }
                catch (Throwable error2) {
                    // empty catch block
                }
            }
            Object[] filler = new Object[]{className};
            String message = _MESSAGES.get("JavaClassNotFound", filler);
            throw new RuntimeException(message);
        }
    }

    public static Class getClassFromArrayClass(Class arrayClass) {
        if (arrayClass == null) {
            throw new NullPointerException(_MESSAGES.get("NullClass"));
        }
        String name = arrayClass.getName();
        if (name.charAt(0) != '[') {
            Object[] filler = new Object[]{name};
            throw new RuntimeException(_MESSAGES.get("NotArrayClass", filler));
        }
        if (name.charAt(1) == '[') {
            Object[] filler = new Object[]{name};
            throw new RuntimeException(_MESSAGES.get("NoMultiArrays", filler));
        }
        char type = name.charAt(1);
        switch (type) {
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'L': {
                return ReflectUtils.getClass(name.substring(2, name.length() - 1));
            }
        }
        Object[] filler = new Object[]{name, new Character(type)};
        String message = _MESSAGES.get("UnsupportedType", filler);
        throw new RuntimeException(message);
    }

    public static Method getFirstMethod(Class theClass, String name) {
        Method[] methods = theClass.getMethods();
        for (int n = 0; n < methods.length; ++n) {
            if (!name.equals(methods[n].getName())) continue;
            return methods[n];
        }
        return null;
    }

    public static String getPackageName(Class theClass) {
        if (theClass.isArray()) {
            theClass = ReflectUtils.getClassFromArrayClass(theClass);
        }
        return ReflectUtils.getPackageName(theClass.getName());
    }

    public static String getPackageName(String qualifiedName) {
        int dot = qualifiedName.lastIndexOf(46);
        return dot >= 0 ? qualifiedName.substring(0, dot) : null;
    }

    public static String getShortName(Class type) {
        if (type.isArray()) {
            Class base = ReflectUtils.getClassFromArrayClass(type);
            String name = ReflectUtils.getShortName(base);
            return name + "[]";
        }
        return ReflectUtils.getShortName(type.getName());
    }

    public static String getShortName(String qualifiedName) {
        int dot = qualifiedName.lastIndexOf(46);
        return qualifiedName.substring(dot + 1);
    }

    public static Object newInstance(Class theClass) {
        try {
            return theClass.newInstance();
        }
        catch (InstantiationException error) {
            Object[] filler = new Object[]{theClass};
            String message = _MESSAGES.get("ObjectCreationFailed", filler);
            throw new RuntimeException(message);
        }
        catch (IllegalAccessException error) {
            Object[] filler = new Object[]{theClass};
            String message = _MESSAGES.get("DefaultConstructorHidden", filler);
            throw new RuntimeException(message);
        }
    }

    public static Object newInstance(String className) {
        return ReflectUtils.newInstance(ReflectUtils.getClass(className));
    }

    public static Object newInstance(String className, ClassLoader classLoader) {
        return ReflectUtils.newInstance(ReflectUtils.getClass(className, classLoader));
    }

    public static void setHelper(ReflectUtilHelper helper) {
        _helper = helper;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _helper = null;
        _MESSAGES = MessagesFactory.get(class$org$apache$muse$util$ReflectUtils == null ? (class$org$apache$muse$util$ReflectUtils = ReflectUtils.class$("org.apache.muse.util.ReflectUtils")) : class$org$apache$muse$util$ReflectUtils);
        ReflectUtils instance = new ReflectUtils();
        _DEFAULT_CLASS_LOADER = instance.getClass().getClassLoader();
        _helper = null;
    }
}

