/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.util;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.w3c.dom.Node;

public class LoggingUtils {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$util$FileUtils == null ? (class$org$apache$muse$util$FileUtils = LoggingUtils.class$("org.apache.muse.util.FileUtils")) : class$org$apache$muse$util$FileUtils);
    private static final int BACK_TRACE_LEVEL = 15;
    static /* synthetic */ Class class$org$apache$muse$util$FileUtils;

    public static void logCall(Logger log, Method method, Object[] parameters) {
        int n;
        if (log == null) {
            throw new NullPointerException(_MESSAGES.get("NullLogger"));
        }
        if (method == null) {
            throw new NullPointerException(_MESSAGES.get("NullMethod"));
        }
        if (parameters == null) {
            throw new NullPointerException(_MESSAGES.get("NullParameters"));
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SERVER TRACE] Mapping SOAP request to Java method '");
        buffer.append(method.getName());
        buffer.append("'.\n\n");
        buffer.append("Parameter types expected by Java method:\n\n");
        buffer.append("\t[");
        Class<?>[] paramTypes = method.getParameterTypes();
        for (n = 0; n < paramTypes.length; ++n) {
            buffer.append(paramTypes[n].getName());
            if (n == paramTypes.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append("]\n\n");
        buffer.append("Parameter types received by the MessageHandler:\n\n");
        buffer.append("\t[");
        for (n = 0; n < parameters.length; ++n) {
            String type = null;
            type = parameters[n] == null ? "null (no type)" : parameters[n].getClass().getName();
            buffer.append(type);
            if (n == parameters.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append("]\n\n");
        buffer.append("Messages about this call will appear below...\n");
        log.fine(buffer.toString());
    }

    public static void logError(Logger log, Throwable error) {
        if (log == null) {
            throw new NullPointerException(_MESSAGES.get("NullLogger"));
        }
        if (error == null) {
            throw new NullPointerException(_MESSAGES.get("NullError"));
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("There was an error while processing a request:\n\n");
        buffer.append(error.getMessage());
        buffer.append("\n\n\t");
        StackTraceElement[] stackTrace = error.getStackTrace();
        for (int n = 0; n < stackTrace.length && n < 15; ++n) {
            buffer.append(stackTrace[n]);
            buffer.append("\n\t");
        }
        if (stackTrace.length > 15) {
            buffer.append(stackTrace.length - 15 + " more...");
        }
        buffer.append("\n------------------------------------------\n");
        log.info(buffer.toString());
    }

    public static void logMessage(Logger log, Node soap, boolean incoming) {
        if (log == null) {
            throw new NullPointerException(_MESSAGES.get("NullLogger"));
        }
        if (soap == null) {
            throw new NullPointerException(_MESSAGES.get("NullMessageElement"));
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SERVER TRACE] SOAP envelope contents (");
        buffer.append(incoming ? "incoming" : "outgoing");
        buffer.append("):\n\n");
        buffer.append(XmlUtils.toString((Node)soap, (boolean)false));
        buffer.append('\n');
        log.fine(buffer.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

