/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.apache.http.RequestLine;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.params.HttpProtocolParams;

public class BasicHttpRequest
extends AbstractHttpMessage
implements HttpRequest {
    private final RequestLine requestline;
    private final String method;
    private final String uri;

    public BasicHttpRequest(String method, String uri) {
        if (method == null) {
            throw new IllegalArgumentException("Method name may not be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Request URI may not be null");
        }
        this.method = method;
        this.uri = uri;
        this.requestline = null;
    }

    public BasicHttpRequest(RequestLine requestline) {
        if (requestline == null) {
            throw new IllegalArgumentException("Request line may not be null");
        }
        this.requestline = requestline;
        this.method = requestline.getMethod();
        this.uri = requestline.getUri();
    }

    public HttpVersion getHttpVersion() {
        if (this.requestline != null) {
            return this.requestline.getHttpVersion();
        }
        return HttpProtocolParams.getVersion(this.getParams());
    }

    public RequestLine getRequestLine() {
        if (this.requestline != null) {
            return this.requestline;
        }
        HttpVersion ver = HttpProtocolParams.getVersion(this.getParams());
        return new RequestLine(this.method, this.uri, ver);
    }
}

