/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.io.ByteArrayBuffer;
import org.apache.http.io.CharArrayBuffer;
import org.apache.http.io.HttpDataTransmitter;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public abstract class AbstractHttpDataTransmitter
implements HttpDataTransmitter {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static int MAX_CHUNK = 256;
    private OutputStream outstream;
    private ByteArrayBuffer buffer;
    private String charset = "US-ASCII";
    private boolean ascii = true;

    protected void init(OutputStream outstream, int buffersize) {
        if (outstream == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        if (buffersize <= 0) {
            throw new IllegalArgumentException("Buffer size may not be negative or zero");
        }
        this.outstream = outstream;
        this.buffer = new ByteArrayBuffer(buffersize);
    }

    protected void flushBuffer() throws IOException {
        if (this.buffer.length() > 0) {
            this.outstream.write(this.buffer.buffer(), 0, this.buffer.length());
            this.buffer.clear();
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.outstream.flush();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            return;
        }
        if (len > MAX_CHUNK || len > this.buffer.capacity()) {
            this.flushBuffer();
            this.outstream.write(b, off, len);
        } else {
            int freecapacity = this.buffer.capacity() - this.buffer.length();
            if (len > freecapacity) {
                this.flushBuffer();
            }
            this.buffer.append(b, off, len);
        }
    }

    public void write(byte[] b) throws IOException {
        if (b == null) {
            return;
        }
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        if (this.buffer.isFull()) {
            this.flushBuffer();
        }
        this.buffer.append(b);
    }

    public void writeLine(String s) throws IOException {
        if (s == null) {
            return;
        }
        if (s.length() > 0) {
            this.write(s.getBytes(this.charset));
        }
        this.write(CRLF);
    }

    public void writeLine(CharArrayBuffer s) throws IOException {
        if (s == null) {
            return;
        }
        if (this.ascii) {
            int chunk;
            int off = 0;
            for (int remaining = s.length(); remaining > 0; remaining -= chunk) {
                chunk = this.buffer.capacity() - this.buffer.length();
                if ((chunk = Math.min(chunk, remaining)) > 0) {
                    this.buffer.append(s, off, chunk);
                }
                if (this.buffer.isFull()) {
                    this.flushBuffer();
                }
                off += chunk;
            }
        } else {
            byte[] tmp = s.toString().getBytes(this.charset);
            this.write(tmp);
        }
        this.write(CRLF);
    }

    public void reset(HttpParams params) {
        this.charset = HttpProtocolParams.getHttpElementCharset(params);
        this.ascii = this.charset.equalsIgnoreCase("US-ASCII") || this.charset.equalsIgnoreCase("ASCII");
    }
}

