/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http;

import org.apache.http.HttpStatus;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.io.CharArrayBuffer;
import org.apache.http.protocol.HTTP;

public class StatusLine {
    private final HttpVersion httpVersion;
    private final int statusCode;
    private final String reasonPhrase;

    public StatusLine(HttpVersion httpVersion, int statusCode, String reasonPhrase) {
        if (httpVersion == null) {
            throw new IllegalArgumentException("HTTP version may not be null");
        }
        if (statusCode < 0) {
            throw new IllegalArgumentException("Status code may not be negative");
        }
        this.httpVersion = httpVersion;
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
    }

    public StatusLine(HttpVersion httpVersion, int statusCode) {
        this(httpVersion, statusCode, HttpStatus.getStatusText(statusCode));
    }

    public static StatusLine parse(CharArrayBuffer buffer, int indexFrom, int indexTo) throws ProtocolException {
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (indexFrom < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (indexTo > buffer.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (indexFrom > indexTo) {
            throw new IndexOutOfBoundsException();
        }
        try {
            int i = indexFrom;
            while (HTTP.isWhitespace(buffer.charAt(i))) {
                ++i;
            }
            int blank = buffer.indexOf(32, i, indexTo);
            if (blank <= 0) {
                throw new ProtocolException("Unable to parse HTTP-Version from the status line: " + buffer.substring(indexFrom, indexTo));
            }
            HttpVersion ver = HttpVersion.parse(buffer, i, blank);
            i = blank;
            while (HTTP.isWhitespace(buffer.charAt(i))) {
                ++i;
            }
            blank = buffer.indexOf(32, i, indexTo);
            if (blank < 0) {
                blank = indexTo;
            }
            int statusCode = 0;
            try {
                statusCode = Integer.parseInt(buffer.substringTrimmed(i, blank));
            }
            catch (NumberFormatException e) {
                throw new ProtocolException("Unable to parse status code from status line: " + buffer.substring(indexFrom, indexTo));
            }
            i = blank;
            String reasonPhrase = null;
            reasonPhrase = i < indexTo ? buffer.substringTrimmed(i, indexTo) : "";
            return new StatusLine(ver, statusCode, reasonPhrase);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ProtocolException("Invalid status line: " + buffer.substring(indexFrom, indexTo));
        }
    }

    public static final StatusLine parse(String s) throws ProtocolException {
        if (s == null) {
            throw new IllegalArgumentException("String may not be null");
        }
        CharArrayBuffer buffer = new CharArrayBuffer(s.length());
        buffer.append(s);
        return StatusLine.parse(buffer, 0, buffer.length());
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    public final String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public final String toString() {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append(this.httpVersion);
        buffer.append(' ');
        buffer.append(Integer.toString(this.statusCode));
        if (this.reasonPhrase != null && !this.reasonPhrase.equals("")) {
            buffer.append(' ');
            buffer.append(this.reasonPhrase);
        }
        return buffer.toString();
    }

    public static void format(CharArrayBuffer buffer, StatusLine statusline) {
        if (buffer == null) {
            throw new IllegalArgumentException("String buffer may not be null");
        }
        if (statusline == null) {
            throw new IllegalArgumentException("Status line may not be null");
        }
        HttpVersion.format(buffer, statusline.getHttpVersion());
        buffer.append(' ');
        buffer.append(Integer.toString(statusline.getStatusCode()));
        if (statusline.getReasonPhrase() != null) {
            buffer.append(' ');
            buffer.append(statusline.getReasonPhrase());
        }
    }

    public static String format(StatusLine statusline) {
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        StatusLine.format(buffer, statusline);
        return buffer.toString();
    }
}

