/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.IXMLReaderFactory;
import org.jibx.runtime.impl.InputStreamWrapper;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XMLPullReaderFactory
implements IXMLReaderFactory {
    private static final String DEFAULT_PARSER_NAME = "org.xmlpull.mxp1.MXParserFactory";
    private static final XMLPullReaderFactory s_instance;
    private final XmlPullParserFactory m_factory;
    static /* synthetic */ Class class$org$jibx$runtime$impl$XMLPullReaderFactory;

    private XMLPullReaderFactory(XmlPullParserFactory xmlPullParserFactory) {
        this.m_factory = xmlPullParserFactory;
    }

    public static XMLPullReaderFactory getInstance() {
        return s_instance;
    }

    private XmlPullParser createParser(boolean bl) throws XmlPullParserException {
        XmlPullParser xmlPullParser = this.m_factory.newPullParser();
        if (bl) {
            xmlPullParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        }
        return xmlPullParser;
    }

    public IXMLReader createReader(InputStream inputStream, String string, String string2, boolean bl) throws JiBXException {
        try {
            return this.recycleReader(new XMLPullReader(this.createParser(bl)), inputStream, string, string2);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new JiBXException("Error creating parser", xmlPullParserException);
        }
    }

    public IXMLReader createReader(Reader reader, String string, boolean bl) throws JiBXException {
        try {
            return this.recycleReader(new XMLPullReader(this.createParser(bl)), reader, string);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new JiBXException("Error creating parser", xmlPullParserException);
        }
    }

    public IXMLReader recycleReader(IXMLReader iXMLReader, InputStream inputStream, String string, String string2) throws JiBXException {
        ((XMLPullReader)iXMLReader).setDocument(inputStream, string, string2);
        return iXMLReader;
    }

    public IXMLReader recycleReader(IXMLReader iXMLReader, Reader reader, String string) throws JiBXException {
        ((XMLPullReader)iXMLReader).setDocument(reader, string);
        return iXMLReader;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        XmlPullParserFactory xmlPullParserFactory = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = (class$org$jibx$runtime$impl$XMLPullReaderFactory == null ? (class$org$jibx$runtime$impl$XMLPullReaderFactory = XMLPullReaderFactory.class$("org.jibx.runtime.impl.XMLPullReaderFactory")) : class$org$jibx$runtime$impl$XMLPullReaderFactory).getClassLoader();
        }
        try {
            String string = System.getProperty("org.xmlpull.v1.XmlPullParserFactory");
            if (string != null && (string = string.trim()).length() > 0) {
                xmlPullParserFactory = XmlPullParserFactory.newInstance((String)string, classLoader.getClass());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (xmlPullParserFactory == null) {
            try {
                xmlPullParserFactory = XmlPullParserFactory.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (xmlPullParserFactory == null) {
                throw new RuntimeException("Unable to create XMLPull parser");
            }
        }
        s_instance = new XMLPullReaderFactory(xmlPullParserFactory);
    }

    private static class XMLPullReader
    implements IXMLReader {
        private final XmlPullParser m_parser;
        private String m_docName;
        private InputStreamWrapper m_streamWrapper;
        private String m_encoding;

        private XMLPullReader(XmlPullParser xmlPullParser) {
            this.m_parser = xmlPullParser;
        }

        private void setDocument(InputStream inputStream, String string, String string2) throws JiBXException {
            try {
                if (string2 == null) {
                    if (this.m_streamWrapper == null) {
                        this.m_streamWrapper = new InputStreamWrapper();
                    }
                    this.m_streamWrapper.setInput(inputStream, string2);
                    this.setDocument(this.m_streamWrapper.getReader(), string);
                    this.m_encoding = this.m_streamWrapper.getEncoding();
                } else {
                    this.m_docName = string;
                    this.m_encoding = string2;
                    this.m_parser.setInput(inputStream, string2);
                }
            }
            catch (XmlPullParserException xmlPullParserException) {
                throw new JiBXException("Error initializing parser", xmlPullParserException);
            }
            catch (IOException iOException) {
                throw new JiBXException("Error reading from stream", iOException);
            }
        }

        private void setDocument(Reader reader, String string) throws JiBXException {
            try {
                this.m_docName = string;
                this.m_encoding = null;
                this.m_parser.setInput(reader);
            }
            catch (XmlPullParserException xmlPullParserException) {
                throw new JiBXException("Error initializing parser", xmlPullParserException);
            }
        }

        private String describeException(Exception exception) {
            return "Error parsing document " + this.buildPositionString() + ": " + exception.getMessage();
        }

        public String buildPositionString() {
            String string = "(line " + this.m_parser.getLineNumber() + ", col " + this.m_parser.getColumnNumber();
            if (this.m_docName != null) {
                string = string + ", in " + this.m_docName;
            }
            return string + ')';
        }

        public int nextToken() throws JiBXException {
            try {
                return this.m_parser.nextToken();
            }
            catch (IOException iOException) {
                throw new JiBXException("Error accessing document", iOException);
            }
            catch (XmlPullParserException xmlPullParserException) {
                throw new JiBXException("Error parsing document " + this.buildPositionString(), xmlPullParserException);
            }
        }

        public int next() throws JiBXException {
            try {
                return this.m_parser.next();
            }
            catch (IOException iOException) {
                throw new JiBXException("Error accessing document", iOException);
            }
            catch (XmlPullParserException xmlPullParserException) {
                throw new JiBXException("Error parsing document " + this.buildPositionString(), xmlPullParserException);
            }
        }

        public int getEventType() throws JiBXException {
            try {
                return this.m_parser.getEventType();
            }
            catch (XmlPullParserException xmlPullParserException) {
                throw new JiBXException("Error parsing document " + this.buildPositionString(), xmlPullParserException);
            }
        }

        public String getName() {
            String string = this.m_parser.getName();
            if (string == null) {
                throw new IllegalStateException("Internal state error: not at start or end tag");
            }
            return string;
        }

        public String getNamespace() {
            String string = this.m_parser.getNamespace();
            if (string == null) {
                throw new IllegalStateException("Internal state error: not at start or end tag");
            }
            return string;
        }

        public String getPrefix() {
            return this.m_parser.getPrefix();
        }

        public int getAttributeCount() {
            int n = this.m_parser.getAttributeCount();
            if (n < 0) {
                throw new IllegalStateException("Internal state error: not at start tag");
            }
            return n;
        }

        public String getAttributeName(int n) {
            try {
                return this.m_parser.getAttributeName(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalStateException(this.describeException(arrayIndexOutOfBoundsException));
            }
        }

        public String getAttributeNamespace(int n) {
            try {
                return this.m_parser.getAttributeNamespace(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalStateException(this.describeException(arrayIndexOutOfBoundsException));
            }
        }

        public String getAttributePrefix(int n) {
            try {
                return this.m_parser.getAttributePrefix(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalStateException(this.describeException(arrayIndexOutOfBoundsException));
            }
        }

        public String getAttributeValue(int n) {
            try {
                return this.m_parser.getAttributeValue(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalStateException(this.describeException(arrayIndexOutOfBoundsException));
            }
        }

        public String getAttributeValue(String string, String string2) {
            try {
                return this.m_parser.getAttributeValue(string, string2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalStateException(this.describeException(arrayIndexOutOfBoundsException));
            }
        }

        public String getText() {
            return this.m_parser.getText();
        }

        public int getNestingDepth() {
            return this.m_parser.getDepth();
        }

        public int getNamespaceCount(int n) {
            try {
                return this.m_parser.getNamespaceCount(n);
            }
            catch (XmlPullParserException xmlPullParserException) {
                throw new IllegalArgumentException(this.describeException((Exception)((Object)xmlPullParserException)));
            }
        }

        public String getNamespaceUri(int n) {
            try {
                return this.m_parser.getNamespaceUri(n);
            }
            catch (XmlPullParserException xmlPullParserException) {
                throw new IllegalArgumentException(this.describeException((Exception)((Object)xmlPullParserException)));
            }
        }

        public String getNamespacePrefix(int n) {
            try {
                return this.m_parser.getNamespacePrefix(n);
            }
            catch (XmlPullParserException xmlPullParserException) {
                throw new IllegalArgumentException(this.describeException((Exception)((Object)xmlPullParserException)));
            }
        }

        public String getDocumentName() {
            return this.m_docName;
        }

        public int getLineNumber() {
            return this.m_parser.getLineNumber();
        }

        public int getColumnNumber() {
            return this.m_parser.getColumnNumber();
        }

        public String getNamespace(String string) {
            return this.m_parser.getNamespace(string);
        }

        public String getInputEncoding() {
            return this.m_encoding;
        }

        public boolean isNamespaceAware() {
            return this.m_parser.getFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces");
        }
    }
}

