/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.IntStack;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.StringArray;

public class StAXReaderWrapper
implements IXMLReader {
    static final byte[] s_eventTranslations = new byte[256];
    private final XMLStreamReader m_parser;
    final boolean m_isNamespaceAware;
    private final String m_docName;
    int m_nestingDepth;
    private IntStack m_inScopeCounts;
    private StringArray m_inScopeUris;
    private StringArray m_inScopePrefixes;
    private String m_accumulatedText;
    private boolean m_isProcessingInstruction;
    private String m_encoding;

    public StAXReaderWrapper(XMLStreamReader xMLStreamReader, String string, boolean bl) {
        this.m_parser = xMLStreamReader;
        this.m_docName = string;
        this.m_isNamespaceAware = bl;
        this.m_inScopeCounts = new IntStack();
        this.m_inScopeCounts.push(0);
        this.m_inScopeUris = new StringArray();
        this.m_inScopePrefixes = new StringArray();
    }

    public String buildPositionString() {
        Location location = this.m_parser.getLocation();
        String string = "(line " + location.getLineNumber() + ", col " + location.getColumnNumber();
        if (this.m_docName != null) {
            string = string + ", in " + this.m_docName;
        }
        return string + ')';
    }

    private void startTag() {
        if (this.m_nestingDepth == 0) {
            this.m_encoding = this.m_parser.getEncoding();
            if (this.m_encoding == null) {
                this.m_encoding = this.m_parser.getCharacterEncodingScheme();
                if (this.m_encoding == null) {
                    this.m_encoding = "UTF-8";
                }
            }
        }
        ++this.m_nestingDepth;
        int n = this.m_parser.getNamespaceCount();
        for (int i = 0; i < n; ++i) {
            this.m_inScopeUris.add(this.m_parser.getNamespaceURI(i));
            this.m_inScopePrefixes.add(this.m_parser.getNamespacePrefix(i));
        }
        this.m_inScopeCounts.push(this.m_inScopeUris.size());
    }

    private void endTag() {
        --this.m_nestingDepth;
        int n = this.m_inScopeCounts.pop() - this.m_inScopeCounts.peek();
        if (n > 0) {
            this.m_inScopeUris.remove(n);
            this.m_inScopePrefixes.remove(n);
        }
    }

    public int nextToken() throws JiBXException {
        if (this.m_accumulatedText == null) {
            try {
                byte by;
                block8: while (true) {
                    by = s_eventTranslations[this.m_parser.next()];
                    switch (by) {
                        case 2: {
                            this.startTag();
                            break block8;
                        }
                        case 3: {
                            this.endTag();
                            break block8;
                        }
                        case 8: {
                            this.m_accumulatedText = this.m_parser.getPITarget() + ' ' + this.m_parser.getPIData();
                            this.m_isProcessingInstruction = true;
                            while (s_eventTranslations[this.m_parser.next()] == 0) {
                            }
                            break block8;
                        }
                        case 0: {
                            continue block8;
                        }
                    }
                    break;
                }
                return by;
            }
            catch (XMLStreamException xMLStreamException) {
                throw new JiBXException("Error parsing document " + this.buildPositionString(), xMLStreamException);
            }
        }
        this.m_accumulatedText = null;
        this.m_isProcessingInstruction = false;
        byte by = s_eventTranslations[this.m_parser.getEventType()];
        if (by == 2) {
            this.startTag();
        } else if (by == 3) {
            this.endTag();
        }
        return by;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int next() throws JiBXException {
        String string = null;
        StringBuffer stringBuffer = null;
        try {
            if (this.m_accumulatedText == null) {
                this.m_parser.next();
            } else {
                this.m_accumulatedText = null;
                this.m_isProcessingInstruction = false;
            }
            block9: while (true) {
                byte by = s_eventTranslations[this.m_parser.getEventType()];
                switch (by) {
                    case 6: {
                        if (this.m_parser.getText() == null) {
                            throw new JiBXException("Unexpanded entity reference in text at " + this.buildPositionString());
                        }
                    }
                    case 4: 
                    case 5: {
                        if (string == null) {
                            string = this.m_parser.getText();
                            break;
                        }
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer(string);
                        }
                        stringBuffer.append(this.m_parser.getTextCharacters());
                        break;
                    }
                    case 3: {
                        if (string != null) break block9;
                        this.endTag();
                        return by;
                    }
                    case 2: {
                        if (string != null) break block9;
                        this.startTag();
                        return by;
                    }
                    case 1: {
                        if (string != null) break block9;
                        return by;
                    }
                }
                this.m_parser.next();
            }
            if (stringBuffer == null) {
                this.m_accumulatedText = string;
                return 4;
            }
            this.m_accumulatedText = stringBuffer.toString();
            return 4;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), xMLStreamException);
        }
    }

    public int getEventType() throws JiBXException {
        if (this.m_accumulatedText == null) {
            return s_eventTranslations[this.m_parser.getEventType()];
        }
        if (this.m_isProcessingInstruction) {
            return 8;
        }
        return 4;
    }

    public String getName() {
        return this.m_parser.getLocalName();
    }

    public String getNamespace() {
        String string = this.m_parser.getNamespaceURI();
        if (string == null) {
            return "";
        }
        return string;
    }

    public String getPrefix() {
        String string = this.m_parser.getPrefix();
        if (string != null && string.length() == 0) {
            return null;
        }
        return string;
    }

    public int getAttributeCount() {
        return this.m_parser.getAttributeCount();
    }

    public String getAttributeName(int n) {
        try {
            return this.m_parser.getAttributeLocalName(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalStateException(arrayIndexOutOfBoundsException.getMessage());
        }
    }

    public String getAttributeNamespace(int n) {
        try {
            String string = this.m_parser.getAttributeNamespace(n);
            if (string == null) {
                return "";
            }
            return string;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalStateException(arrayIndexOutOfBoundsException.getMessage());
        }
    }

    public String getAttributePrefix(int n) {
        try {
            String string = this.m_parser.getAttributePrefix(n);
            if (string != null && string.length() == 0) {
                return null;
            }
            return string;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalStateException(arrayIndexOutOfBoundsException.getMessage());
        }
    }

    public String getAttributeValue(int n) {
        try {
            return this.m_parser.getAttributeValue(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalStateException(arrayIndexOutOfBoundsException.getMessage());
        }
    }

    public String getAttributeValue(String string, String string2) {
        try {
            return this.m_parser.getAttributeValue(string, string2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalStateException(arrayIndexOutOfBoundsException.getMessage());
        }
    }

    public String getText() {
        if (this.m_accumulatedText == null) {
            return this.m_parser.getText();
        }
        return this.m_accumulatedText;
    }

    public int getNestingDepth() {
        return this.m_nestingDepth;
    }

    public int getNamespaceCount(int n) {
        return this.m_inScopeCounts.peek(this.m_nestingDepth - n);
    }

    public String getNamespaceUri(int n) {
        return this.m_inScopeUris.get(n);
    }

    public String getNamespacePrefix(int n) {
        String string = this.m_inScopePrefixes.get(n);
        if (string != null && string.length() == 0) {
            return null;
        }
        return string;
    }

    public String getDocumentName() {
        return this.m_docName;
    }

    public int getLineNumber() {
        return this.m_parser.getLocation().getLineNumber();
    }

    public int getColumnNumber() {
        return this.m_parser.getLocation().getColumnNumber();
    }

    public String getNamespace(String string) {
        int n = this.m_inScopePrefixes.size();
        while (--n >= 0) {
            if (!string.equals(this.m_inScopePrefixes.get(n))) continue;
            return this.m_inScopeUris.get(n);
        }
        return null;
    }

    public String getInputEncoding() {
        return this.m_encoding;
    }

    public boolean isNamespaceAware() {
        return this.m_isNamespaceAware;
    }

    static {
        StAXReaderWrapper.s_eventTranslations[12] = 5;
        StAXReaderWrapper.s_eventTranslations[4] = 4;
        StAXReaderWrapper.s_eventTranslations[5] = 9;
        StAXReaderWrapper.s_eventTranslations[11] = 10;
        StAXReaderWrapper.s_eventTranslations[8] = 1;
        StAXReaderWrapper.s_eventTranslations[2] = 3;
        StAXReaderWrapper.s_eventTranslations[9] = 6;
        StAXReaderWrapper.s_eventTranslations[3] = 8;
        StAXReaderWrapper.s_eventTranslations[6] = 7;
        StAXReaderWrapper.s_eventTranslations[7] = 0;
        StAXReaderWrapper.s_eventTranslations[1] = 2;
    }
}

