/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime;

import java.util.Arrays;
import java.util.Comparator;

public class EnumSet {
    public static final int VALUE_LIMIT = 512;
    private final EnumItem[] m_items;
    private final String[] m_indexedNames;
    private final String[] m_orderedNames;
    private final int[] m_orderedIndexes;

    public EnumSet(EnumItem[] enumItemArray) {
        this.m_items = enumItemArray;
        if (enumItemArray.length > 0) {
            EnumItem enumItem;
            int n;
            Arrays.sort(enumItemArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((EnumItem)object).m_name.compareTo(((EnumItem)object2).m_name);
                }
            });
            this.m_orderedNames = new String[enumItemArray.length];
            this.m_orderedIndexes = new int[enumItemArray.length];
            int n2 = -1;
            for (n = 0; n < enumItemArray.length; ++n) {
                enumItem = enumItemArray[n];
                if (enumItem.m_value < 0) {
                    throw new IllegalArgumentException("Negative item value " + enumItem.m_value + " not allowed");
                }
                if (enumItem.m_value > n2 && (n2 = enumItem.m_value) >= 512) {
                    throw new IllegalArgumentException("Enumeration with value " + n2 + " too large to be used.");
                }
                this.m_orderedNames[n] = enumItem.m_name;
                this.m_orderedIndexes[n] = enumItem.m_value;
            }
            this.m_indexedNames = new String[n2 + 1];
            for (n = 0; n < enumItemArray.length; ++n) {
                enumItem = enumItemArray[n];
                if (this.m_indexedNames[enumItem.m_value] != null) {
                    throw new IllegalArgumentException("Duplicate index value " + enumItem.m_value);
                }
                this.m_indexedNames[enumItem.m_value] = enumItem.m_name;
            }
        } else {
            this.m_indexedNames = new String[0];
            this.m_orderedNames = new String[0];
            this.m_orderedIndexes = new int[0];
        }
    }

    public EnumSet(int n, String[] stringArray) {
        this(EnumSet.buildItems(n, stringArray));
    }

    public EnumSet(EnumSet enumSet, int n, String[] stringArray) {
        this(EnumSet.mergeItems(enumSet, n, stringArray));
    }

    private static EnumItem[] buildItems(int n, String[] stringArray) {
        EnumItem[] enumItemArray = new EnumItem[stringArray.length];
        for (int i = 0; i < enumItemArray.length; ++i) {
            enumItemArray[i] = new EnumItem(n + i, stringArray[i]);
        }
        return enumItemArray;
    }

    private static EnumItem[] mergeItems(EnumSet enumSet, int n, String[] stringArray) {
        int n2 = enumSet.m_items.length;
        EnumItem[] enumItemArray = new EnumItem[n2 + stringArray.length];
        System.arraycopy(enumSet.m_items, 0, enumItemArray, 0, n2);
        for (int i = 0; i < stringArray.length; ++i) {
            enumItemArray[n2 + i] = new EnumItem(n + i, stringArray[i]);
        }
        return enumItemArray;
    }

    public String getName(int n) {
        if (n >= 0 && n < this.m_indexedNames.length) {
            return this.m_indexedNames[n];
        }
        return null;
    }

    public String getNameChecked(int n) {
        String string;
        if (n >= 0 && n < this.m_indexedNames.length && (string = this.m_indexedNames[n]) != null) {
            return string;
        }
        throw new IllegalArgumentException("Value " + n + " not defined");
    }

    public int getValue(String string) {
        int n = 0;
        int n2 = this.m_orderedNames.length - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            int n4 = string.compareTo(this.m_orderedNames[n3]);
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            if (this.m_orderedIndexes != null) {
                return this.m_orderedIndexes[n3];
            }
            return n3;
        }
        return -1;
    }

    public int getValueChecked(String string) {
        int n = this.getValue(string);
        if (n >= 0) {
            return n;
        }
        throw new IllegalArgumentException("Name " + string + " not defined");
    }

    public void checkValue(int n) {
        if (n < 0 || n >= this.m_indexedNames.length || this.m_indexedNames[n] == null) {
            throw new IllegalArgumentException("Value " + n + " not defined");
        }
    }

    public int maxIndex() {
        return this.m_indexedNames.length - 1;
    }

    public static class EnumItem {
        public final int m_value;
        public final String m_name;

        public EnumItem(int n, String string) {
            this.m_value = n;
            this.m_name = string;
        }
    }
}

