/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.resource.sg.impl;

import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.muse.util.StringUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.resource.remote.WsResourceClient;
import org.apache.muse.ws.resource.sg.MembershipContentRule;
import org.apache.muse.ws.resource.sg.WssgConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleMembershipContentRule
implements MembershipContentRule {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$ws$resource$sg$impl$SimpleMembershipContentRule == null ? (class$org$apache$muse$ws$resource$sg$impl$SimpleMembershipContentRule = SimpleMembershipContentRule.class$("org.apache.muse.ws.resource.sg.impl.SimpleMembershipContentRule")) : class$org$apache$muse$ws$resource$sg$impl$SimpleMembershipContentRule);
    private static final QName[] _EMPTY_CONTENT = new QName[0];
    private QName[] _content = _EMPTY_CONTENT;
    private QName _portType = null;
    private EndpointReference _serviceGroupEPR = null;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$sg$impl$SimpleMembershipContentRule;

    public SimpleMembershipContentRule() {
    }

    public SimpleMembershipContentRule(Element xml) {
        String contentList;
        if (xml == null) {
            throw new NullPointerException(_MESSAGES.get("NullElement"));
        }
        String portTypeName = xml.getAttribute("MembershipInterface");
        if (portTypeName.length() > 0) {
            this._portType = XmlUtils.parseQName(portTypeName, xml);
        }
        if ((contentList = xml.getAttribute("ContentElements")).length() > 0) {
            String[] contentNames = StringUtils.split(contentList);
            this._content = new QName[contentNames.length];
            for (int n = 0; n < contentNames.length; ++n) {
                this._content[n] = XmlUtils.parseQName(contentNames[n], xml);
            }
        }
    }

    public QName[] getContentElements() {
        return this._content;
    }

    public QName getMemberInterface() {
        return this._portType;
    }

    public EndpointReference getServiceGroupEPR() {
        return this._serviceGroupEPR;
    }

    public boolean isMatch(EndpointReference epr) {
        if (epr == null) {
            throw new NullPointerException(_MESSAGES.get("NullResource"));
        }
        EndpointReference sgEPR = this.getServiceGroupEPR();
        WsResourceClient resource = new WsResourceClient(epr, sgEPR);
        QName[] content = this.getContentElements();
        try {
            if (content.length > 0) {
                resource.getMultipleResourceProperties(content);
            }
        }
        catch (SoapFault error) {
            return false;
        }
        return true;
    }

    public void setContentElements(QName[] content) {
        if (content == null) {
            content = _EMPTY_CONTENT;
        }
        this._content = content;
    }

    public void setMemberInterface(QName portType) {
        this._portType = portType;
    }

    public void setServiceGroupEPR(EndpointReference serviceGroupEPR) {
        this._serviceGroupEPR = serviceGroupEPR;
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document factory) {
        Element root = XmlUtils.createElement(factory, WssgConstants.CONTENT_RULE_QNAME);
        QName interfaceName = this.getMemberInterface();
        if (interfaceName != null) {
            root.setAttribute("MembershipInterface", XmlUtils.toString(interfaceName));
            String prefix = interfaceName.getPrefix();
            String namespace = interfaceName.getNamespaceURI();
            XmlUtils.setNamespaceAttribute(root, prefix, namespace);
        }
        QName[] content = this.getContentElements();
        StringBuffer contentAttr = new StringBuffer();
        HashMap<String, String> prefixes = new HashMap<String, String>();
        for (int n = 0; n < content.length; ++n) {
            contentAttr.append(XmlUtils.toString(content[n]));
            if (n < content.length - 1) {
                contentAttr.append(' ');
            }
            prefixes.put(content[n].getPrefix(), content[n].getNamespaceURI());
        }
        root.setAttribute("ContentElements", contentAttr.toString());
        Iterator i = prefixes.keySet().iterator();
        while (i.hasNext()) {
            String next = (String)i.next();
            XmlUtils.setNamespaceAttribute(root, next, (String)prefixes.get(next));
        }
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

