/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.resource.sg.impl;

import java.text.ParseException;
import java.util.Date;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlSerializable;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.resource.ext.faults.InvalidMessageFormatFault;
import org.apache.muse.ws.resource.remote.WsResourceClient;
import org.apache.muse.ws.resource.sg.WssgConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AddRequest
implements XmlSerializable {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$ws$resource$sg$impl$AddRequest == null ? (class$org$apache$muse$ws$resource$sg$impl$AddRequest = AddRequest.class$("org.apache.muse.ws.resource.sg.impl.AddRequest")) : class$org$apache$muse$ws$resource$sg$impl$AddRequest);
    private Element _content = null;
    private EndpointReference _memberEPR = null;
    private Date _termination = null;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$sg$impl$AddRequest;

    public AddRequest(Element xml) throws InvalidMessageFormatFault {
        if (xml == null) {
            throw new NullPointerException(_MESSAGES.get("NullElement"));
        }
        Element eprXML = XmlUtils.getElement(xml, WssgConstants.MEMBER_EPR_QNAME);
        if (eprXML == null) {
            throw new InvalidMessageFormatFault(_MESSAGES.get("NoMemberEPR"));
        }
        try {
            this._memberEPR = new EndpointReference(eprXML);
        }
        catch (SoapFault error) {
            throw new InvalidMessageFormatFault(error);
        }
        this._content = XmlUtils.getElement(xml, WssgConstants.CONTENT_QNAME);
        Element timeXML = XmlUtils.getElement(xml, WssgConstants.INIT_TERMINATION_QNAME);
        try {
            if (timeXML != null) {
                this._termination = XmlUtils.getDate(timeXML);
            }
        }
        catch (ParseException error) {
            throw new InvalidMessageFormatFault(error);
        }
    }

    public AddRequest(EndpointReference memberEPR, Date termination) {
        this(memberEPR, termination, null);
    }

    public AddRequest(EndpointReference memberEPR, Date termination, Element content) {
        if (memberEPR == null) {
            throw new NullPointerException(_MESSAGES.get("NullMemberEPR"));
        }
        this._memberEPR = memberEPR;
        this._termination = termination;
        this._content = content;
    }

    public Element getContent() {
        return this._content;
    }

    public EndpointReference getMemberEPR() {
        return this._memberEPR;
    }

    public Date getTerminationTime() {
        return this._termination;
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document factory) {
        if (factory == null) {
            throw new NullPointerException(_MESSAGES.get("NullDocument"));
        }
        Element root = XmlUtils.createElement(factory, WssgConstants.ADD_QNAME);
        EndpointReference epr = this.getMemberEPR();
        XmlUtils.setElement(root, WssgConstants.MEMBER_EPR_QNAME, epr.toXML());
        WsResourceClient member = new WsResourceClient(epr);
        Element content = this.getContent();
        try {
            if (content == null) {
                Element[] results = member.getResourceProperty(WssgConstants.CONTENT_QNAME);
                content = results[0];
            }
        }
        catch (SoapFault error) {
            throw new RuntimeException(error.getMessage(), error);
        }
        content = (Element)factory.importNode(content, true);
        root.appendChild(content);
        Date time = this.getTerminationTime();
        if (time != null) {
            XmlUtils.setElement(root, WssgConstants.INIT_TERMINATION_QNAME, time);
        }
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

