/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.resource.properties.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.muse.util.MultiMap;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.util.xml.XsdUtils;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.resource.WsResourceCapability;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.apache.muse.ws.resource.ext.faults.SerializationErrorFault;
import org.apache.muse.ws.resource.metadata.MetadataDescriptor;
import org.apache.muse.ws.resource.metadata.faults.MetadataValidationFault;
import org.apache.muse.ws.resource.metadata.impl.ExternalChangeApprover;
import org.apache.muse.ws.resource.metadata.impl.InsertOnlyApprover;
import org.apache.muse.ws.resource.metadata.impl.ReadOnlyApprover;
import org.apache.muse.ws.resource.metadata.impl.StaticValuesApprover;
import org.apache.muse.ws.resource.metadata.impl.ValidValuesApprover;
import org.apache.muse.ws.resource.properties.ResourcePropertyCollection;
import org.apache.muse.ws.resource.properties.get.faults.InvalidResourcePropertyQNameFault;
import org.apache.muse.ws.resource.properties.impl.WsrpUtils;
import org.apache.muse.ws.resource.properties.listeners.AbstractChangeApprover;
import org.apache.muse.ws.resource.properties.listeners.PropertyChangeApprover;
import org.apache.muse.ws.resource.properties.listeners.PropertyChangeListener;
import org.apache.muse.ws.resource.properties.listeners.PropertyReadListener;
import org.apache.muse.ws.resource.properties.schema.ResourcePropertiesSchema;
import org.apache.muse.ws.resource.properties.schema.faults.SchemaValidationFault;
import org.apache.muse.ws.resource.properties.set.SetRequest;
import org.apache.muse.ws.resource.properties.set.SetRequestComponent;
import org.apache.muse.ws.resource.properties.set.faults.UnableToModifyResourcePropertyFault;
import org.apache.muse.ws.resource.properties.set.faults.UnableToPutResourcePropertyDocumentFault;
import org.apache.muse.ws.resource.properties.set.impl.InsertRequest;
import org.apache.muse.ws.resource.properties.set.impl.SimpleSetRequest;
import org.apache.muse.ws.resource.properties.set.impl.UpdateRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleResourcePropertyCollection
implements ResourcePropertyCollection {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$ws$resource$properties$impl$SimpleResourcePropertyCollection == null ? (class$org$apache$muse$ws$resource$properties$impl$SimpleResourcePropertyCollection = SimpleResourcePropertyCollection.class$("org.apache.muse.ws.resource.properties.impl.SimpleResourcePropertyCollection")) : class$org$apache$muse$ws$resource$properties$impl$SimpleResourcePropertyCollection);
    private MultiMap _approversByQName = new MultiMap();
    private MultiMap _listenersByQName = new MultiMap();
    private MetadataDescriptor _metadata = null;
    private MultiMap _readersByQName = new MultiMap();
    private ResourcePropertiesSchema _schema = null;
    private Object _securityToken = new Object();
    static /* synthetic */ Class class$org$apache$muse$ws$resource$properties$impl$SimpleResourcePropertyCollection;

    public synchronized void addCapability(WsResourceCapability capability) {
        QName[] names = capability.getPropertyNames();
        ResourcePropertiesSchema schema = this.getSchema();
        for (int n = 0; n < names.length; ++n) {
            schema.setCapability(names[n], capability);
        }
    }

    public final synchronized void addChangeApprover(PropertyChangeApprover approver) {
        if (approver == null) {
            throw new NullPointerException(_MESSAGES.get("NullPCA"));
        }
        QName qname = approver.getPropertyName();
        if (!this.hasPropertyDefinition(qname)) {
            Object[] filler = new Object[]{qname};
            throw new IllegalArgumentException(_MESSAGES.get("PropertyNotInSchema", filler));
        }
        this._approversByQName.put(qname, approver);
    }

    public final synchronized void addChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException(_MESSAGES.get("NullPCL"));
        }
        QName qname = listener.getPropertyName();
        if (!this.hasPropertyDefinition(qname)) {
            Object[] filler = new Object[]{qname};
            throw new IllegalArgumentException(_MESSAGES.get("PropertyNotInSchema", filler));
        }
        this._listenersByQName.put(qname, listener);
    }

    protected void addInitialValues(QName qname) {
        Collection initialValues = this.getMetadata().getInitialValues(qname);
        Iterator i = initialValues.iterator();
        try {
            while (i.hasNext()) {
                this.insertResourceProperty(qname, new Object[]{i.next()});
            }
        }
        catch (BaseFault fault) {
            throw new RuntimeException(fault.getMessage(), fault);
        }
    }

    protected void addPermissions(QName qname) {
        MetadataDescriptor metadata = this.getMetadata();
        boolean readOnly = metadata.isReadOnlyExternal(qname);
        ExternalChangeApprover security = new ExternalChangeApprover(qname, readOnly);
        security.setSecurityToken(this.getSecurityToken());
        this.addChangeApprover(security);
        if (!metadata.canUpdate(qname)) {
            AbstractChangeApprover approver = null;
            approver = metadata.canInsert(qname) ? new InsertOnlyApprover(qname) : new ReadOnlyApprover(qname);
            this.addChangeApprover(approver);
        }
    }

    public final synchronized void addReadListener(PropertyReadListener listener) {
        if (listener == null) {
            throw new NullPointerException(_MESSAGES.get("NullPRL"));
        }
        QName qname = listener.getPropertyName();
        if (!this.hasPropertyDefinition(qname)) {
            Object[] filler = new Object[]{qname};
            throw new IllegalArgumentException(_MESSAGES.get("PropertyNotInSchema", filler));
        }
        this._readersByQName.put(qname, listener);
    }

    protected void addStaticValues(QName qname) {
        Collection staticValues = this.getMetadata().getStaticValues(qname);
        if (!staticValues.isEmpty()) {
            StaticValuesApprover staticValuesListener = new StaticValuesApprover(qname, this._metadata);
            this.addChangeApprover(staticValuesListener);
            Iterator i = staticValues.iterator();
            try {
                while (i.hasNext()) {
                    this.insertResourceProperty(qname, new Object[]{i.next()});
                }
            }
            catch (BaseFault fault) {
                throw new RuntimeException(fault.getMessage(), fault);
            }
        }
    }

    protected void addValidValues(QName qname) {
        this.addChangeApprover(new ValidValuesApprover(qname, this.getMetadata()));
    }

    public synchronized void applyMetadata() {
        if (this.getMetadata() == null) {
            throw new IllegalStateException(_MESSAGES.get("NoMetadata"));
        }
        Iterator i = this.getMetadata().getPropertyNames().iterator();
        while (i.hasNext()) {
            QName qname = (QName)i.next();
            this.addInitialValues(qname);
            this.addStaticValues(qname);
            this.addValidValues(qname);
            this.addPermissions(qname);
        }
    }

    protected final void changeCompleted(QName qname, Element oldValue, Element newValue) throws BaseFault {
        if (qname == null) {
            throw new NullPointerException(_MESSAGES.get("NullQName"));
        }
        Collection listeners = (Collection)this._listenersByQName.get(qname);
        if (listeners != null) {
            Iterator i = listeners.iterator();
            while (i.hasNext()) {
                PropertyChangeListener listener = (PropertyChangeListener)i.next();
                listener.propertyChanged(oldValue, newValue);
            }
        }
    }

    protected final void changeRequested(QName qname, Element oldValue, Element newValue, Object securityToken) throws BaseFault {
        if (qname == null) {
            throw new NullPointerException(_MESSAGES.get("NullQName"));
        }
        Collection approvers = (Collection)this._approversByQName.get(qname);
        if (approvers != null) {
            Iterator i = approvers.iterator();
            while (i.hasNext()) {
                PropertyChangeApprover approver = (PropertyChangeApprover)i.next();
                approver.validateChange(oldValue, newValue, securityToken);
            }
        }
    }

    protected SetRequest createInsertRequests(Element newDoc) throws UnableToPutResourcePropertyDocumentFault, BaseFault {
        Element[] properties = XmlUtils.getAllElements(newDoc);
        SimpleSetRequest set = new SimpleSetRequest();
        for (int i = 0; i < properties.length; ++i) {
            QName propQName = XmlUtils.getElementQName(properties[i]);
            if (this.getMetadata().isReadOnlyExternal(propQName)) {
                Object[] filler = new Object[]{propQName};
                throw new UnableToPutResourcePropertyDocumentFault(_MESSAGES.get("PutRPDocReadOnlyError", filler));
            }
            InsertRequest insertComp = new InsertRequest(propQName, properties[i]);
            set.addRequestComponent(insertComp);
        }
        return set;
    }

    protected void deleteMutableProperties() throws BaseFault {
        Iterator i = this.getPropertyNames().iterator();
        MetadataDescriptor metadata = this.getMetadata();
        while (i.hasNext()) {
            Element[] instances;
            QName propName = (QName)i.next();
            if (!metadata.canDelete(propName) || metadata.isReadOnlyExternal(propName) || (instances = this.getResourceProperty(propName)).length <= 0) continue;
            this.deleteResourceProperty(propName, this.getSecurityToken());
        }
    }

    public void deleteResourceProperty(QName qname) throws BaseFault {
        this.deleteResourceProperty(qname, this.getSecurityToken());
    }

    public synchronized void deleteResourceProperty(QName qname, Object securityToken) throws BaseFault {
        if (qname == null) {
            throw new NullPointerException(_MESSAGES.get("NullQName"));
        }
        Element[] results = this.getResourceProperty(qname);
        if (results.length == 0) {
            Object[] filler = new Object[]{qname};
            throw new UnableToModifyResourcePropertyFault(_MESSAGES.get("NoInstancesToDelete", filler));
        }
        this.validateDelete(qname, results.length, results.length);
        for (int n = 0; n < results.length; ++n) {
            this.changeRequested(qname, results[n], null, securityToken);
        }
        WsResourceCapability capability = this.getCapability(qname);
        capability.deleteProperty(qname);
        for (int n = 0; n < results.length; ++n) {
            this.changeCompleted(qname, results[n], null);
        }
    }

    public WsResourceCapability getCapability(QName qname) {
        return this.getSchema().getCapability(qname);
    }

    public final synchronized Iterator getChangeApprovers(QName property) {
        Collection approvers = (Collection)this._approversByQName.get(property);
        return approvers.iterator();
    }

    public final synchronized Iterator getChangeListeners(QName property) {
        Collection listeners = (Collection)this._listenersByQName.get(property);
        return listeners.iterator();
    }

    public final synchronized MetadataDescriptor getMetadata() {
        return this._metadata;
    }

    public synchronized Element[] getMultipleResourceProperties(QName[] qnames) throws InvalidResourcePropertyQNameFault, BaseFault {
        if (qnames == null) {
            throw new NullPointerException(_MESSAGES.get("NullQNameArray"));
        }
        Element[][] results = new Element[qnames.length][];
        int total = 0;
        for (int n = 0; n < qnames.length; ++n) {
            results[n] = this.getResourceProperty(qnames[n]);
            total += results[n].length;
        }
        Element[] oneBigArray = new Element[total];
        int current = 0;
        for (int n = 0; n < results.length; ++n) {
            System.arraycopy(results[n], 0, oneBigArray, current, results[n].length);
            current += results[n].length;
        }
        return oneBigArray;
    }

    public synchronized Object getPropertyAsObject(QName qname, Class type) throws BaseFault {
        Element[] properties = this.getResourceProperty(qname);
        try {
            return WsrpUtils.convertToObjects(properties, type);
        }
        catch (SoapFault fault) {
            throw new SerializationErrorFault(fault);
        }
    }

    public synchronized Collection getPropertyNames() {
        return this.getSchema().getPropertyNames();
    }

    public final synchronized Iterator getReadListeners(QName property) {
        Collection readers = (Collection)this._readersByQName.get(property);
        return readers.iterator();
    }

    public synchronized Element[] getResourceProperty(QName qname) throws InvalidResourcePropertyQNameFault, BaseFault {
        if (qname == null) {
            throw new NullPointerException(_MESSAGES.get("NullQName"));
        }
        if (!this.hasPropertyDefinition(qname)) {
            Object[] filler = new Object[]{qname};
            throw new InvalidResourcePropertyQNameFault(_MESSAGES.get("PropertyNotInSchema", filler));
        }
        WsResourceCapability capability = this.getCapability(qname);
        Element[] results = capability.getProperty(qname);
        return this.readRequested(qname, results);
    }

    public synchronized Element getResourcePropertyDocument() throws BaseFault {
        Document doc = XmlUtils.createDocument();
        QName rootName = this.getSchema().getElementName();
        Element root = XmlUtils.createElement(doc, rootName);
        doc.appendChild(root);
        Collection names = this.getPropertyNames();
        QName[] namesAsArray = new QName[names.size()];
        namesAsArray = names.toArray(namesAsArray);
        Element[] values = this.getMultipleResourceProperties(namesAsArray);
        for (int n = 0; n < values.length; ++n) {
            values[n] = (Element)doc.importNode(values[n], true);
            root.appendChild(values[n]);
        }
        return root;
    }

    public final synchronized ResourcePropertiesSchema getSchema() {
        return this._schema;
    }

    public Object getSecurityToken() {
        return this._securityToken;
    }

    public boolean hasPropertyDefinition(QName qname) {
        if (this._schema == null) {
            throw new IllegalStateException(_MESSAGES.get("NoSchema"));
        }
        return this._schema.hasProperty(qname);
    }

    public synchronized void insertOrUpdate(QName property, Object value) throws BaseFault {
        this.insertOrUpdate(property, new Object[]{value});
    }

    public synchronized void insertOrUpdate(QName property, Object[] values) throws BaseFault {
        if (this.getResourceProperty(property).length == 0) {
            this.insertResourceProperty(property, values);
        } else {
            this.updateResourceProperty(property, values);
        }
    }

    public synchronized void insertResourceProperty(QName qname, Object[] values) throws BaseFault {
        this.insertResourceProperty(qname, values, this.getSecurityToken());
    }

    public synchronized void insertResourceProperty(QName qname, Object[] values, Object securityToken) throws BaseFault {
        if (qname == null) {
            throw new NullPointerException(_MESSAGES.get("NullQName"));
        }
        if (values == null) {
            throw new NullPointerException(_MESSAGES.get("NullValuesArray"));
        }
        if (values.length == 0) {
            throw new IllegalArgumentException(_MESSAGES.get("EmptyValuesArray"));
        }
        Element[] current = this.getResourceProperty(qname);
        InsertRequest request = new InsertRequest(qname, values);
        Element[] valuesXML = request.getValues();
        this.validateInsert(qname, current.length, valuesXML);
        for (int n = 0; n < valuesXML.length; ++n) {
            this.changeRequested(qname, null, valuesXML[n], securityToken);
        }
        WsResourceCapability capability = this.getCapability(qname);
        capability.insertProperty(qname, valuesXML);
        for (int n = 0; n < valuesXML.length; ++n) {
            this.changeCompleted(qname, null, valuesXML[n]);
        }
    }

    public synchronized Element putResourcePropertyDocument(Element newDoc) throws UnableToPutResourcePropertyDocumentFault, BaseFault {
        if (newDoc == null) {
            throw new NullPointerException(_MESSAGES.get("NullRPDoc"));
        }
        try {
            this.deleteMutableProperties();
            SetRequest insertRequests = this.createInsertRequests(newDoc);
            this.setResourceProperties(insertRequests);
        }
        catch (BaseFault fault) {
            throw new UnableToPutResourcePropertyDocumentFault(_MESSAGES.get("PutRPDocError", new Object[]{fault.getMessage()}));
        }
        Element finalDoc = this.getResourcePropertyDocument();
        Element wsFreeNewDoc = this.stripWhiteSpaceChildren(newDoc);
        return XmlUtils.equals(wsFreeNewDoc, finalDoc) ? null : finalDoc;
    }

    protected final Element[] readRequested(QName qname, Element[] properties) throws BaseFault {
        if (qname == null) {
            throw new NullPointerException(_MESSAGES.get("NullQName"));
        }
        Collection readers = (Collection)this._readersByQName.get(qname);
        if (readers != null) {
            Iterator i = readers.iterator();
            while (i.hasNext()) {
                PropertyReadListener reader = (PropertyReadListener)i.next();
                properties = reader.readRequested(properties);
            }
        }
        return properties;
    }

    public final synchronized void removeChangeApprover(PropertyChangeApprover approver) {
        if (approver == null) {
            throw new NullPointerException(_MESSAGES.get("NullPCA"));
        }
        this.removeItem(this._approversByQName, approver.getPropertyName(), approver);
    }

    public final synchronized void removeChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException(_MESSAGES.get("NullPCL"));
        }
        this.removeItem(this._listenersByQName, listener.getPropertyName(), listener);
    }

    private void removeItem(MultiMap map, Object key, Object value) {
        Collection all = (Collection)map.get(key);
        all.remove(value);
        if (all.isEmpty()) {
            map.remove(key);
        }
    }

    public final synchronized void removeReadListener(PropertyReadListener listener) {
        if (listener == null) {
            throw new NullPointerException(_MESSAGES.get("NullPRL"));
        }
        this.removeItem(this._readersByQName, listener.getPropertyName(), listener);
    }

    public synchronized void setMetadata(MetadataDescriptor metadata) {
        if (metadata == null) {
            throw new NullPointerException(_MESSAGES.get("NullMetadataDescriptor"));
        }
        this._metadata = metadata;
    }

    public synchronized void setResourceProperties(SetRequest request) throws BaseFault {
        List ops = request.getRequestComponents();
        if (ops.isEmpty()) {
            throw new IllegalArgumentException(_MESSAGES.get("EmptySetRequest"));
        }
        Iterator i = ops.iterator();
        while (i.hasNext()) {
            SetRequestComponent next = (SetRequestComponent)i.next();
            next.execute(this);
        }
    }

    public synchronized void setSchema(ResourcePropertiesSchema schema) {
        if (schema == null) {
            throw new NullPointerException(_MESSAGES.get("NullSchema"));
        }
        this._schema = schema;
    }

    private Element stripWhiteSpaceChildren(Element root) {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3 || !child.getNodeValue().trim().equals("")) continue;
            child.getParentNode().removeChild(child);
        }
        return root;
    }

    public synchronized String toString() {
        return XmlUtils.toString(this.toXML(), false);
    }

    public synchronized Element toXML() {
        try {
            return this.getResourcePropertyDocument();
        }
        catch (BaseFault error) {
            throw new RuntimeException(error.getMessage(), error);
        }
    }

    public synchronized Element toXML(Document factory) {
        try {
            Element wsrp = this.getResourcePropertyDocument();
            return (Element)factory.importNode(wsrp, true);
        }
        catch (BaseFault error) {
            throw new RuntimeException(error.getMessage(), error);
        }
    }

    public synchronized void updateResourceProperty(QName qname, Object[] values) throws BaseFault {
        this.updateResourceProperty(qname, values, this.getSecurityToken());
    }

    public synchronized void updateResourceProperty(QName qname, Object[] values, Object securityToken) throws BaseFault {
        int n;
        if (qname == null) {
            throw new NullPointerException(_MESSAGES.get("NullQName"));
        }
        if (values == null) {
            throw new NullPointerException(_MESSAGES.get("NullValuesArray"));
        }
        Element[] current = this.getResourceProperty(qname);
        if (current.length == 0) {
            Object[] filler = new Object[]{qname};
            throw new UnableToModifyResourcePropertyFault(_MESSAGES.get("PropertyNotFound", filler));
        }
        UpdateRequest request = new UpdateRequest(qname, values);
        Element[] valuesXML = request.getValues();
        this.validateInsert(qname, 0, valuesXML);
        int lcd = Math.min(current.length, valuesXML.length);
        for (int n2 = 0; n2 < lcd; ++n2) {
            this.changeRequested(qname, current[n2], valuesXML[n2], securityToken);
        }
        WsResourceCapability capability = this.getCapability(qname);
        capability.updateProperty(qname, valuesXML);
        for (n = 0; n < lcd; ++n) {
            this.changeCompleted(qname, current[n], valuesXML[n]);
        }
        for (n = lcd; n < current.length; ++n) {
            this.changeCompleted(qname, current[n], null);
        }
        for (n = lcd; n < valuesXML.length; ++n) {
            this.changeCompleted(qname, null, valuesXML[n]);
        }
    }

    protected void validateDelete(QName qname, int currentSize, int toDelete) throws BaseFault {
        int min = this._schema.getMinOccurs(qname);
        if (currentSize - toDelete < min) {
            Object[] filler = new Object[]{qname, new Integer(min), new Integer(currentSize - toDelete)};
            throw new SchemaValidationFault(_MESSAGES.get("BelowMinimumPotential", filler));
        }
    }

    protected void validateInsert(QName qname, int currentSize, Element[] values) throws BaseFault {
        ResourcePropertiesSchema schema = this.getSchema();
        int max = schema.getMaxOccurs(qname);
        int total = currentSize + values.length;
        if (!this._schema.isMaxUnbounded(qname) && total > max) {
            Object[] filler = new Object[]{qname, new Integer(max), new Integer(total)};
            throw new SchemaValidationFault(_MESSAGES.get("AboveMaximumPotential", filler));
        }
        this.validateNillable(qname, values, schema.isNillable(qname));
    }

    public synchronized void validateMetadata() throws BaseFault {
        if (this._metadata == null) {
            throw new IllegalStateException(_MESSAGES.get("NoMetadata"));
        }
        Iterator i = this._metadata.getPropertyNames().iterator();
        while (i.hasNext()) {
            QName qname = (QName)i.next();
            Element[] current = this.getResourceProperty(qname);
            if (current.length == 0 || !this._metadata.hasProperty(qname)) continue;
            for (int n = 0; n < current.length; ++n) {
                if (this._metadata.isValidValue(qname, current[n])) continue;
                Object[] filler = new Object[]{qname, XmlUtils.toString(current[n], false)};
                throw new MetadataValidationFault(_MESSAGES.get("InvalidValue", filler));
            }
        }
    }

    protected void validateNillable(QName qname, Element[] instances, boolean isNillable) throws SchemaValidationFault {
        if (isNillable) {
            return;
        }
        for (int n = 0; n < instances.length; ++n) {
            boolean isNil;
            String nil = XmlUtils.getAttribute(instances[n], XsdUtils.NIL_QNAME);
            boolean nilExists = nil != null && nil.length() > 0;
            boolean bl = isNil = nilExists ? Boolean.valueOf(nil) : false;
            if (!isNil) continue;
            throw new SchemaValidationFault(_MESSAGES.get("NotNillable", new Object[]{qname}));
        }
    }

    public synchronized void validateSchema() throws BaseFault {
        ResourcePropertiesSchema schema = this.getSchema();
        Iterator i = schema.getPropertyNames().iterator();
        while (i.hasNext()) {
            QName qname = (QName)i.next();
            if (!schema.hasCapability(qname)) {
                Object[] filler = new Object[]{qname};
                throw new IllegalStateException(_MESSAGES.get("NoCapabilityForProperty", filler));
            }
            int max = schema.getMaxOccurs(qname);
            boolean maxUnbounded = schema.isMaxUnbounded(qname);
            int min = schema.getMinOccurs(qname);
            boolean isNillable = schema.isNillable(qname);
            Element[] instances = this.getResourceProperty(qname);
            if (instances.length < min) {
                Object[] filler = new Object[]{qname, new Integer(min), new Integer(instances.length)};
                throw new SchemaValidationFault(_MESSAGES.get("BelowMinimum", filler));
            }
            if (!maxUnbounded && instances.length > max) {
                Object[] filler = new Object[]{qname, new Integer(min), new Integer(instances.length)};
                throw new SchemaValidationFault(_MESSAGES.get("AboveMaximum", filler));
            }
            this.validateNillable(qname, instances, isNillable);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

