/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.notification.topics.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.muse.util.StringUtils;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.notification.NotificationMessage;
import org.apache.muse.ws.notification.faults.InvalidTopicExpressionFault;
import org.apache.muse.ws.notification.topics.Topic;
import org.apache.muse.ws.notification.topics.TopicNamespace;
import org.apache.muse.ws.notification.topics.WstConstants;
import org.apache.muse.ws.notification.topics.impl.ConcretePathExpression;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleTopic
implements Topic {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$ws$notification$topics$impl$SimpleTopic == null ? (class$org$apache$muse$ws$notification$topics$impl$SimpleTopic = SimpleTopic.class$("org.apache.muse.ws.notification.topics.impl.SimpleTopic")) : class$org$apache$muse$ws$notification$topics$impl$SimpleTopic);
    private Map _childTopics = new LinkedHashMap();
    private NotificationMessage _currentMessage = null;
    private boolean _isFinal = false;
    private String _messagePattern = null;
    private Set _messageTypes = new HashSet();
    private String _name = null;
    private Topic _parentTopic = null;
    private TopicNamespace _topicSpace = null;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$topics$impl$SimpleTopic;

    public SimpleTopic(Element root, TopicNamespace topicSpace) throws InvalidTopicExpressionFault, BaseFault {
        int n;
        String messageTypesValue;
        if (root == null) {
            throw new NullPointerException(_MESSAGES.get("NullTopicElement"));
        }
        if (topicSpace == null) {
            throw new NullPointerException(_MESSAGES.get("NullTopicSpace"));
        }
        this._topicSpace = topicSpace;
        this._name = root.getAttribute("name");
        if (this._name == null || this._name.length() == 0) {
            throw new InvalidTopicExpressionFault(_MESSAGES.get("NoTopicName"));
        }
        String finalValue = root.getAttribute("final");
        if (finalValue != null && finalValue.length() > 0) {
            this._isFinal = Boolean.valueOf(finalValue);
        }
        if ((messageTypesValue = root.getAttribute("messageTypes")) != null && messageTypesValue.length() > 0) {
            String[] values = StringUtils.split(messageTypesValue);
            for (n = 0; n < values.length; ++n) {
                QName qname = XmlUtils.parseQName(values[n], root);
                this._messageTypes.add(qname);
            }
        }
        this._messagePattern = XmlUtils.getElementText(root, WstConstants.PATTERN_QNAME);
        Element[] children = XmlUtils.getElements(root, WstConstants.TOPIC_QNAME);
        for (n = 0; n < children.length; ++n) {
            SimpleTopic topic = new SimpleTopic(children[n], topicSpace);
            this.addTopicEvenIfFinal(topic);
        }
    }

    public SimpleTopic(String name, TopicNamespace topicSpace) throws BaseFault {
        if (name == null) {
            throw new NullPointerException(_MESSAGES.get("NullTopicName"));
        }
        if (topicSpace == null) {
            throw new NullPointerException(_MESSAGES.get("NullTopicSpace"));
        }
        this._topicSpace = topicSpace;
        int slash = name.indexOf(47);
        int end = slash >= 0 ? slash : name.length();
        this._name = name.substring(0, end);
        if (end < name.length()) {
            String childName = name.substring(end + 1);
            this.addTopic(new SimpleTopic(childName, topicSpace));
        }
    }

    public final synchronized void addMessageType(QName messageType) {
        if (messageType == null) {
            throw new NullPointerException(_MESSAGES.get("NullMessageType"));
        }
        this._messageTypes.add(messageType);
    }

    public final synchronized void addTopic(Topic childTopic) throws InvalidTopicExpressionFault, BaseFault {
        if (childTopic == null) {
            throw new NullPointerException(_MESSAGES.get("NullTopic"));
        }
        if (this.isFinal()) {
            Object[] filler = new Object[]{this.getConcretePath()};
            throw new InvalidTopicExpressionFault(_MESSAGES.get("NoNewTopics", filler));
        }
        this.addTopicEvenIfFinal(childTopic);
    }

    private void addTopicEvenIfFinal(Topic childTopic) throws InvalidTopicExpressionFault, BaseFault {
        String name = childTopic.getName();
        if (this._childTopics.containsKey(name)) {
            Object[] filler = new Object[]{name, this.getConcretePath()};
            throw new InvalidTopicExpressionFault(_MESSAGES.get("SubTopicExists", filler));
        }
        String topicNS = childTopic.getTopicNamespace().getTargetNamespace();
        String targetNS = this.getTopicNamespace().getTargetNamespace();
        if (!targetNS.equals(topicNS)) {
            Object[] filler = new Object[]{topicNS, targetNS};
            throw new InvalidTopicExpressionFault(_MESSAGES.get("InvalidTopicNS", filler));
        }
        childTopic.setParentTopic(this);
        this._childTopics.put(name, childTopic);
    }

    public synchronized boolean equals(Object obj) {
        String thatNS;
        if (obj == null) {
            return false;
        }
        Topic that = (Topic)obj;
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        String thisNS = this.getTopicNamespace().getTargetNamespace();
        if (!thisNS.equals(thatNS = that.getTopicNamespace().getTargetNamespace())) {
            return false;
        }
        if (!this.getConcretePath().equals(that.getConcretePath())) {
            return false;
        }
        if (this.isFinal() != that.isFinal()) {
            return false;
        }
        String thisPattern = this.getMessagePattern();
        String thatPattern = that.getMessagePattern();
        if (thisPattern != null) {
            return thisPattern.equals(thatPattern);
        }
        return thatPattern == null;
    }

    public synchronized QName getConcretePath() {
        ConcretePathExpression path = new ConcretePathExpression(this);
        return path.getTopicPath();
    }

    public synchronized NotificationMessage getCurrentMessage() {
        return this._currentMessage;
    }

    public synchronized String getMessagePattern() {
        return this._messagePattern;
    }

    public String getMessagePatternDialect() {
        return "http://www.w3.org/TR/1999/REC-xpath-19991116";
    }

    public Set getMessageTypes() {
        return Collections.unmodifiableSet(this._messageTypes);
    }

    public final String getName() {
        return this._name;
    }

    public synchronized Topic getParentTopic() {
        return this._parentTopic;
    }

    public synchronized Topic getTopic(String topicName) {
        return (Topic)this._childTopics.get(topicName);
    }

    public synchronized TopicNamespace getTopicNamespace() {
        return this._topicSpace;
    }

    public synchronized Collection getTopics() {
        return Collections.unmodifiableCollection(this._childTopics.values());
    }

    public synchronized int hashCode() {
        String pattern = this.getMessagePattern();
        String ns = this.getTopicNamespace().getTargetNamespace();
        return this.getName().hashCode() + ns.hashCode() + this.getConcretePath().hashCode() + (this.isFinal() ? 1 : 0) + (pattern == null ? 0 : pattern.hashCode());
    }

    public synchronized boolean hasTopic(String topicName) {
        return this.getTopic(topicName) != null;
    }

    public synchronized boolean isFinal() {
        return this._isFinal;
    }

    public synchronized boolean isRootTopic() {
        return this.getParentTopic() == null;
    }

    public final synchronized void removeAllTopics() {
        this._childTopics.clear();
    }

    public final synchronized void removeMessageType(QName messageType) {
        if (messageType == null) {
            throw new NullPointerException(_MESSAGES.get("NullMessageType"));
        }
        this._messageTypes.remove(messageType);
    }

    public final synchronized void removeTopic(String topicName) {
        if (topicName == null) {
            throw new NullPointerException(_MESSAGES.get("NullTopicName"));
        }
        this._childTopics.remove(topicName);
    }

    public void setCurrentMessage(NotificationMessage message) {
        this._currentMessage = message;
    }

    public synchronized void setFinal(boolean isFinal) {
        this._isFinal = isFinal;
    }

    public synchronized void setMessagePattern(String messagePattern) {
        this._messagePattern = messagePattern;
    }

    public synchronized void setParentTopic(Topic parentTopic) {
        this._parentTopic = parentTopic;
    }

    public synchronized String toString() {
        return XmlUtils.toString(this.toXML(), false);
    }

    public synchronized Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public synchronized Element toXML(Document doc) {
        Iterator i;
        Set messageTypes;
        if (doc == null) {
            throw new NullPointerException(_MESSAGES.get("NullDocument"));
        }
        Element root = XmlUtils.createElement(doc, WstConstants.TOPIC_QNAME);
        root.setAttribute("name", this.getName());
        root.setAttribute("targetNamespace", this.getTopicNamespace().getTargetNamespace());
        root.setAttribute("final", Boolean.toString(this.isFinal()));
        String pattern = this.getMessagePattern();
        if (pattern != null) {
            Element patternXML = XmlUtils.createElement(doc, WstConstants.PATTERN_QNAME, pattern);
            root.appendChild(patternXML);
            patternXML.setAttribute("dialect", "http://www.w3.org/TR/1999/REC-xpath-19991116");
        }
        if (!(messageTypes = this.getMessageTypes()).isEmpty()) {
            i = messageTypes.iterator();
            int size = messageTypes.size();
            StringBuffer buffer = new StringBuffer(size * 128);
            int n = 1;
            while (i.hasNext()) {
                QName messageName = (QName)i.next();
                buffer.append(XmlUtils.toString(messageName));
                if (n != size) {
                    buffer.append(' ');
                }
                ++n;
            }
            root.setAttribute("messageTypes", buffer.toString());
        }
        i = this.getTopics().iterator();
        while (i.hasNext()) {
            Topic topic = (Topic)i.next();
            Element topicXML = topic.toXML(doc);
            root.appendChild(topicXML);
        }
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

