/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.notification.impl;

import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.notification.Filter;
import org.apache.muse.ws.notification.NotificationConsumer;
import org.apache.muse.ws.notification.NotificationMessage;
import org.apache.muse.ws.notification.NotificationMessageListener;
import org.apache.muse.ws.notification.PullPoint;
import org.apache.muse.ws.notification.PullPointDataStore;
import org.apache.muse.ws.notification.faults.UnableToGetMessagesFault;
import org.apache.muse.ws.notification.impl.PublishAllMessagesFilter;
import org.apache.muse.ws.notification.impl.SimplePullPointDataStore;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.impl.AbstractWsResourceCapability;

public class SimplePullPoint
extends AbstractWsResourceCapability
implements PullPoint,
NotificationMessageListener {
    private PullPointDataStore _dataStore = null;
    private WsResource _subscription = null;

    public boolean accepts(NotificationMessage message) {
        EndpointReference subEPR = message.getSubscriptionReference();
        return subEPR != null && this.getSubscription().equals(subEPR);
    }

    protected PullPointDataStore createDataStore() {
        return new SimplePullPointDataStore();
    }

    public PullPointDataStore getDataStore() {
        return this._dataStore;
    }

    public Filter getFilter() {
        return PublishAllMessagesFilter.getInstance();
    }

    public NotificationMessage[] getMessages(int maxNumber) throws UnableToGetMessagesFault {
        return this.getDataStore().getMessages(maxNumber);
    }

    public WsResource getSubscription() {
        return this._subscription;
    }

    public void initialize() throws SoapFault {
        super.initialize();
        this._dataStore = this.createDataStore();
        this._dataStore.initialize();
        NotificationConsumer wsn = (NotificationConsumer)this.getResource().getCapability("http://docs.oasis-open.org/wsn/bw-2/NotificationConsumer");
        wsn.addMessageListener(this);
    }

    public void process(NotificationMessage message) throws SoapFault {
        this.getDataStore().addMessage(message);
    }

    public void setSubscription(WsResource subscription) {
        this._subscription = subscription;
    }

    public void shutdown() throws SoapFault {
        this.getSubscription().shutdown();
        this.getDataStore().shutdown();
        super.shutdown();
    }
}

